<?php
/**
 * All settings related to footer recommended post.
 *
 * @package TrendingNews
 */
$wp_customize->add_section(
	'article_group',
	array(
		'title' => esc_html__( 'Article Group Section', 'trendingnews' ),
		'panel' => 'front_page_theme_options_panel',
	)
);

$wp_customize->add_setting(
    'trendingnews_options[enable_article_group]',
    array(
        'default'           => $trendingnews_default['enable_article_group'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_article_group]',
    array(
        'label'       => esc_html__( 'Enable Article Group Post', 'trendingnews' ),
        'section'     => 'article_group',
        'type'        => 'checkbox',
    )
);


$wp_customize->add_setting(
    'trendingnews_options[article_group_title]',
    array(
        'default' => $trendingnews_default['article_group_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[article_group_title]',
    array(
        'label' => __('Section Title', 'trendingnews'),
        'section' => 'article_group',
        'type' => 'text',
    )
);

$wp_customize->add_setting(
    'trendingnews_section_seperator_article_group_1',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new TrendingNews_Seperator_Control(
        $wp_customize,
        'trendingnews_section_seperator_article_group_1',
        array(
            'label'         => esc_html__( 'Article Group Column - 1', 'trendingnews' ),
            'settings' => 'trendingnews_section_seperator_article_group_1',
            'section' => 'article_group',
        )
    )
);

$wp_customize->add_setting(
    'trendingnews_options[article_group_category]',
    array(
        'default'           => $trendingnews_default['article_group_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new TrendingNews_Dropdown_Taxonomies_Control(
        $wp_customize,
        'trendingnews_options[article_group_category]',
        array(
            'label'           => __( 'Choose Column - 1 Category', 'trendingnews' ),
            'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'trendingnews' ),
            'section'         => 'article_group',
        )
    )
);


$wp_customize->add_setting(
    'trendingnews_options[article_group_offset]',
    array(
        'default' => $trendingnews_default['article_group_offset'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[article_group_offset]',
    array(
        'label' => __('Article Group Offset - 1', 'trendingnews'),
        'section' => 'article_group',
        'type' => 'number',
    )
);

$wp_customize->add_setting(
    'trendingnews_section_seperator_article_group_2',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new TrendingNews_Seperator_Control(
        $wp_customize,
        'trendingnews_section_seperator_article_group_2',
        array(
            'label'         => esc_html__( 'Article Group Column - 2', 'trendingnews' ),
            'settings' => 'trendingnews_section_seperator_article_group_2',
            'section' => 'article_group',
        )
    )
);

$wp_customize->add_setting(
    'trendingnews_options[article_group_slider_category]',
    array(
        'default'           => $trendingnews_default['article_group_slider_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new TrendingNews_Dropdown_Taxonomies_Control(
        $wp_customize,
        'trendingnews_options[article_group_slider_category]',
        array(
            'label'           => __( 'Choose Column - 2 Category', 'trendingnews' ),
            'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'trendingnews' ),
            'section'         => 'article_group',
        )
    )
);

$wp_customize->add_setting(
    'trendingnews_options[article_group_offset_2]',
    array(
        'default' => $trendingnews_default['article_group_offset_2'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[article_group_offset_2]',
    array(
        'label' => __('Article Slider Offset', 'trendingnews'),
        'section' => 'article_group',
        'type' => 'number',
    )
);

$wp_customize->add_setting(
    'trendingnews_section_seperator_article_group_meta',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new TrendingNews_Seperator_Control(
        $wp_customize,
        'trendingnews_section_seperator_article_group_meta',
        array(
            'label'         => esc_html__( 'Article Group Meta Option', 'trendingnews' ),
            'settings' => 'trendingnews_section_seperator_article_group_meta',
            'section' => 'article_group',
        )
    )
);

$wp_customize->add_setting(
    'trendingnews_options[enable_article_group_author_meta]',
    array(
        'default' => $trendingnews_default['enable_article_group_author_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_article_group_author_meta]',
    array(
        'label' => esc_html__('Display Author Meta', 'trendingnews'),
        'section' => 'article_group',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_article_group_author_meta]',
    array(
        'default' => $trendingnews_default['select_article_group_author_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_article_group_author_meta]',
    array(
        'label' => esc_html__('Select Author Meta', 'trendingnews'),
        'section' => 'article_group',
        'type' => 'select',
        'choices' => trendingnews_author_meta(),
    )
);
$wp_customize->add_setting(
    'trendingnews_options[article_group_author_meta_title]',
    array(
        'default' => $trendingnews_default['article_group_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[article_group_author_meta_title]',
    array(
        'label' => __('Author Meta Text', 'trendingnews'),
        'section' => 'article_group',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[enable_article_group_date_meta]',
    array(
        'default' => $trendingnews_default['enable_article_group_date_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_article_group_date_meta]',
    array(
        'label' => esc_html__('Display Published Date', 'trendingnews'),
        'section' => 'article_group',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_article_group_date]',
    array(
        'default' => $trendingnews_default['select_article_group_date'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_article_group_date]',
    array(
        'label' => esc_html__('Select Date Meta', 'trendingnews'),
        'section' => 'article_group',
        'type' => 'select',
        'choices' => trendingnews_date_meta(),
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_article_group_date_meta_title]',
    array(
        'default' => $trendingnews_default['select_article_group_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_article_group_date_meta_title]',
    array(
        'label' => __('Date Meta Text', 'trendingnews'),
        'section' => 'article_group',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_article_group_date_format]',
    array(
        'default' => $trendingnews_default['select_article_group_date_format'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_article_group_date_format]',
    array(
        'label' => esc_html__('Select Date Format', 'trendingnews'),
        'section' => 'article_group',
        'type' => 'select',
        'choices' => trendingnews_get_date_formats(),
    )
);
$wp_customize->add_setting(
    'trendingnews_options[enable_article_group_category_meta]',
    array(
        'default' => $trendingnews_default['enable_article_group_category_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_article_group_category_meta]',
    array(
        'label' => esc_html__('Enable Category Meta', 'trendingnews'),
        'section' => 'article_group',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_article_group_number_of_category]',
    array(
        'default' => $trendingnews_default['select_article_group_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_article_group_number_of_category]',
    array(
        'label' => __('Number of Category', 'trendingnews'),
        'section' => 'article_group',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[article_group_category_label]',
    array(
        'default' => $trendingnews_default['article_group_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[article_group_category_label]',
    array(
        'label' => __('Category Label', 'trendingnews'),
        'section' => 'article_group',
        'type' => 'text',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[select_article_group_category_color]',
    array(
        'default' => $trendingnews_default['select_article_group_category_color'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_article_group_category_color]',
    array(
        'label' => esc_html__('Select Category Color', 'trendingnews'),
        'section' => 'article_group',
        'type' => 'select',
        'choices' => trendingnews_category_color(),
    )
);