<?php
/**
 * All settings related to archive.
 *
 * @package TrendingNews
 */
$wp_customize->add_section(
	'archive_options',
	array(
		'title' => esc_html__( 'Archive Options', 'trendingnews' ),
		'panel' => 'archive_options_panel',
	)
);

// Archive Layout.
$wp_customize->add_setting(
    'trendingnews_options[archive_layout]',
    array(
        'default'           => $trendingnews_default['archive_layout'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'trendingnews_sanitize_radio'
    )
);

$wp_customize->add_control(
    new TrendingNews_Custom_Radio_Image_Control(
        $wp_customize,
        'trendingnews_options[archive_layout]',
        array(
            'label'         => esc_html__( 'Archive Layout', 'trendingnews' ),
            'section'       => 'archive_options',
            'choices'       => trendingnews_get_archive_layouts(),
        )
    )
);

$wp_customize->add_setting(
    'trendingnews_options[enable_archive_featured_post]',
    array(
        'default'           => $trendingnews_default['enable_archive_featured_post'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_archive_featured_post]',
    array(
        'label'    => __( 'Enable Featured Post', 'trendingnews' ),
        'description' => __( 'After enabling, set \'Mark as Featured\' to \'Yes\' in the single post options to display the post in the top section of the relevant archive page.', 'trendingnews' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',

    )
);

$wp_customize->add_setting(
    'trendingnews_section_seperator_archive_1',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new TrendingNews_Seperator_Control(
        $wp_customize,
        'trendingnews_section_seperator_archive_1',
        array(
            'label'         => esc_html__( 'Archive Meta Options', 'trendingnews' ),
            'settings' => 'trendingnews_section_seperator_archive_1',
            'section' => 'archive_options',
        )
    )
);

$wp_customize->add_setting(
    'trendingnews_options[enable_archive_post_count]',
    array(
        'default'           => $trendingnews_default['enable_archive_post_count'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_archive_post_count]',
    array(
        'label'    => __( 'Enable Archive Post Count', 'trendingnews' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',

    )
);


$wp_customize->add_setting(
    'trendingnews_options[archive_posts_title_limit]',
    array(
        'default'           => $trendingnews_default['archive_posts_title_limit'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[archive_posts_title_limit]',
    array(
        'label'    => __( 'Title Line Limit', 'trendingnews' ),
        'section'  => 'archive_options',
        'type'     => 'select',
        'choices'  => trendingnews_line_limit_choices(),
    )
);


$wp_customize->add_setting(
    'trendingnews_options[enable_excerpt_on_archive_1]',
    array(
        'default'           => $trendingnews_default['enable_excerpt_on_archive_1'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_excerpt_on_archive_1]',
    array(
        'label'    => __( 'Enable Excerpt On Archive', 'trendingnews' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
        'active_callback' => 'trendingnews_is_archive_excerpt_callbac_1',

    )
);



$wp_customize->add_setting(
    'trendingnews_options[enable_excerpt_on_archive_2]',
    array(
        'default'           => $trendingnews_default['enable_excerpt_on_archive_2'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_excerpt_on_archive_2]',
    array(
        'label'    => __( 'Enable Excerpt On Archive', 'trendingnews' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
        'active_callback' => 'trendingnews_is_archive_excerpt_callbac_2',
        
    )
);


$wp_customize->add_setting(
    'trendingnews_options[enable_excerpt_on_archive_3]',
    array(
        'default'           => $trendingnews_default['enable_excerpt_on_archive_3'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_excerpt_on_archive_3]',
    array(
        'label'    => __( 'Enable Excerpt On Archive', 'trendingnews' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
        'active_callback' => 'trendingnews_is_archive_excerpt_callbac_3',
        
    )
);

$wp_customize->add_setting(
    'trendingnews_options[enable_archive_author_meta]',
    array(
        'default'           => $trendingnews_default['enable_archive_author_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_archive_author_meta]',
    array(
        'label'       => esc_html__( 'Show Author Meta', 'trendingnews' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[select_author_meta]',
    array(
        'default'           => $trendingnews_default['select_author_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_author_meta]',
    array(
        'label'         => esc_html__( 'Author Meta Display Options', 'trendingnews' ),
        'section'     => 'archive_options',
        'type'        => 'select',
        'choices'       => trendingnews_author_meta(),
        'active_callback' => 'trendingnews_is_archive_author_meta_enabled',


    )
);

$wp_customize->add_setting(
    'trendingnews_options[archive_author_meta_title]',
    array(
        'default'           => $trendingnews_default['archive_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[archive_author_meta_title]',
    array(
        'label'    => __( 'Author Meta Text', 'trendingnews' ),
        'section'  => 'archive_options',
        'type'     => 'text',
        'active_callback' => function ( $control ) {
            return (
                trendingnews_is_archive_author_meta_enabled( $control )
                &&
                trendingnews_archive_author_meta_title( $control )
            );
        },
    )
);

$wp_customize->add_setting(
    'trendingnews_options[enable_archive_date_meta]',
    array(
        'default'           => $trendingnews_default['enable_archive_date_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_archive_date_meta]',
    array(
        'label'       => esc_html__( 'Show Date Meta', 'trendingnews' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[select_archive_date]',
    array(
        'default'           => $trendingnews_default['select_archive_date'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_archive_date]',
    array(
        'label'         => esc_html__( 'Date Meta Display Options', 'trendingnews' ),
        'section'     => 'archive_options',
        'type'        => 'select',
        'choices'       => trendingnews_date_meta(),
        'active_callback' => 'trendingnews_is_archive_date_meta_enabled',

    )
);

$wp_customize->add_setting(
    'trendingnews_options[archive_date_meta_title]',
    array(
        'default'           => $trendingnews_default['archive_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[archive_date_meta_title]',
    array(
        'label'    => __( 'Date Meta Text', 'trendingnews' ),
        'section'  => 'archive_options',
        'type'     => 'text',
        'active_callback' => function ( $control ) {
            return (
                trendingnews_is_archive_date_meta_enabled( $control )
                &&
                trendingnews_archive_date_meta_title( $control )
            );
        },
    )
);

$wp_customize->add_setting(
    'trendingnews_options[select_date_format]',
    array(
        'default'           => $trendingnews_default['select_date_format'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_date_format]',
    array(
        'label'         => esc_html__( 'Select Date Format', 'trendingnews' ),
        'section'     => 'archive_options',
        'type'        => 'select',
        'choices'  		=> trendingnews_get_date_formats(),
        'active_callback' => 'trendingnews_is_archive_date_meta_enabled',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[enable_category_meta]',
    array(
        'default'           => $trendingnews_default['enable_category_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_category_meta]',
    array(
        'label'       => esc_html__( 'Enable Category Meta', 'trendingnews' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[number_of_category_to_display]',
    array(
        'default' => $trendingnews_default['number_of_category_to_display'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[number_of_category_to_display]',
    array(
        'label' => __('Number of Category', 'trendingnews'),
        'section' => 'archive_options',
        'type' => 'number',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[archive_category_label]',
    array(
        'default'           => $trendingnews_default['archive_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[archive_category_label]',
    array(
        'label'    => __( 'Category Title', 'trendingnews' ),
        'section'  => 'archive_options',
        'type'     => 'text',
        'active_callback' => 'trendingnews_is_archive_category_meta_enabled',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[select_category_color]',
    array(
        'default'           => $trendingnews_default['select_category_color'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_category_color]',
    array(
        'label'         => esc_html__( 'Select Category Color', 'trendingnews' ),
        'section'     => 'archive_options',
        'type'        => 'select',
        'choices'  		=> trendingnews_category_color(),
        'active_callback' => 'trendingnews_is_archive_category_meta_enabled',

    )
);

$wp_customize->add_setting(
    'trendingnews_options[enable_tag_meta]',
    array(
        'default'           => $trendingnews_default['enable_tag_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_tag_meta]',
    array(
        'label'       => esc_html__( 'Enable Tag Meta', 'trendingnews' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[enable_comment_meta]',
    array(
        'default'           => $trendingnews_default['enable_comment_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_comment_meta]',
    array(
        'label'       => esc_html__( 'Enable Comment Meta', 'trendingnews' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
    )
);


$wp_customize->add_setting(
    'trendingnews_options[enable_read_time_meta]',
    array(
        'default'           => $trendingnews_default['enable_read_time_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_read_time_meta]',
    array(
        'label'       => esc_html__( 'Enable Read Time', 'trendingnews' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
    )
);
