<?php
if (!function_exists('trendingnews_get_option')) :
    /**
     * Get customizer value by key.
     *
     * @param string $key Option key.
     * @return mixed Option value.
     * @since 1.0.0
     *
     */
    function trendingnews_get_option($key)
    {
        $key_value = '';
        if (!$key) {
            return $key_value;
        }
        $default_values = trendingnews_get_all_customizer_default_values();
        $customizer_values = get_theme_mod('trendingnews_options');
        $customizer_values = wp_parse_args($customizer_values, $default_values);

        $key_value = (isset($customizer_values[$key])) ? $customizer_values[$key] : '';
        return $key_value;
    }
endif;

if ( ! function_exists( 'trendingnews_get_archive_layouts' ) ) :
	/**
	 * Returns archive layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function trendingnews_get_archive_layouts() {
		$options = apply_filters(
			'trendingnews_get_archive_layouts',
			array(
				'archive_style_1' => array(
					'url'   => get_template_directory_uri() . '/assets/images/archive-1.webp',
					'label' => esc_html__( 'Archive List View', 'trendingnews' ),
				),
				'archive_style_2' => array(
					'url'   => get_template_directory_uri() . '/assets/images/archive-2.webp',
					'label' => esc_html__( 'Archive Grid View', 'trendingnews' ),
				),
				'archive_style_3' => array(
					'url'   => get_template_directory_uri() . '/assets/images/archive-3.webp',
					'label' => esc_html__( 'Archive Alternate Grid View', 'trendingnews' ),
				),
			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'trendingnews_get_date_formats' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function trendingnews_get_date_formats() {
		$options = apply_filters(
			'trendingnews_archive_date_format',
			array(
				'classic'   => __( 'Classic', 'trendingnews' ),
				'time_ago' => __( 'Time Ago', 'trendingnews' ),
			)
		);
		return $options;
	}
endif;


if ( ! function_exists( 'trendingnews_line_limit_choices' ) ) :
	/**
	 * Returns title limit options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function trendingnews_line_limit_choices() {
		$options = apply_filters(
			'trendingnews_title_limit_options',
			array(
				''              => __( '&mdash; No Limit &mdash;', 'trendingnews' ),
				'limit-line-1' => __( '1 Line', 'trendingnews' ),
				'limit-line-2' => __( '2 Lines', 'trendingnews' ),
				'limit-line-3' => __( '3 Lines', 'trendingnews' ),
				'limit-line-4' => __( '4 Lines', 'trendingnews' ),
				'limit-line-5' => __( '5 Lines', 'trendingnews' ),
			)
		);
		return $options;
	}
endif;
if ( ! function_exists( 'trendingnews_archive_category_style' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function trendingnews_archive_category_style() {
		$options = apply_filters(
			'trendingnews_archive_category_style',
			array(
				'archive_cat_style_1'   => __( 'Category Style 1', 'trendingnews' ),
				'archive_cat_style_2'   => __( 'Category Style 2', 'trendingnews' ),
				'archive_cat_style_3'   => __( 'Category Style 3', 'trendingnews' ),

			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'trendingnews_archive_read_time_style' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function trendingnews_archive_read_time_style() {
		$options = apply_filters(
			'trendingnews_archive_read_time_style',
			array(
				'archive_read_time_style_1'   => __( 'Read Time Style 1', 'trendingnews' ),
				'archive_read_time_style_2'   => __( 'Read Time Style 2', 'trendingnews' ),
				'archive_read_time_style_3'   => __( 'Read Time Style 3', 'trendingnews' ),

			)
		);
		return $options;
	}
endif;


if ( ! function_exists( 'trendingnews_get_header_layout' ) ) :
	/**
	 * Returns header layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function trendingnews_get_header_layout() {
		$options = apply_filters(
			'trendingnews_get_header_layout',
			array(
				'header_style_1' => array(
					'url'   => get_template_directory_uri() . '/assets/images/header-1.webp',
					'label' => esc_html__( 'Header Style 1', 'trendingnews' ),
				),
				'header_style_2' => array(
					'url'   => get_template_directory_uri() . '/assets/images/header-2.webp',
					'label' => esc_html__( 'Header Style 2', 'trendingnews' ),
				),
        'header_style_3' => array(
            'url'   => get_template_directory_uri() . '/assets/images/header-3.webp',
            'label' => esc_html__( 'Header Style 3', 'trendingnews' ),
        ),
        'header_style_4' => array(
            'url'   => get_template_directory_uri() . '/assets/images/header-4.webp',
            'label' => esc_html__( 'Header Style 4', 'trendingnews' ),
        ),
			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'trendingnews_social_menu_style' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function trendingnews_social_menu_style() {
		$options = apply_filters(
			'trendingnews_social_menu_style',
			array(
				'has-brand-background'   => __( 'Has Brand Background', 'trendingnews' ),
				'has-brand-color'   => __( 'Has Brand Color', 'trendingnews' ),
				'none'   => __( 'None', 'trendingnews' ),

			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'trendingnews_pagination_style_choice' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function trendingnews_pagination_style_choice() {
		$options = apply_filters(
			'trendingnews_pagination_style_choice',
			array(
				'pagination_none'   => __( 'None', 'trendingnews' ),
				'pagination_numeric'   => __( 'Numeric', 'trendingnews' ),
				'pagination_default'   => __( 'Default(New/Old Post)', 'trendingnews' ),
				'pagination_ajax_on_scroll'   => __( 'Load More On Scroll', 'trendingnews' ),
				'pagination_ajax_on_click'   => __( 'Load More On Click', 'trendingnews' ),

			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'trendingnews_category_color' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function trendingnews_category_color() {
		$options = apply_filters(
			'trendingnews_category_color',
			array(
				'none'   => __( 'None', 'trendingnews' ),
				'has-background'   => __( 'Has background', 'trendingnews' ),
				'has-text-color'   => __( 'Has text color', 'trendingnews' ),

			)
		);
		return $options;
	}
endif;


if ( ! function_exists( 'trendingnews_get_footer_layouts' ) ) :
	/**
	 * Returns footer layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function trendingnews_get_footer_layouts() {
		$options = apply_filters(
			'trendingnews_footer_layouts',
			array(
				'footer_layout_1' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-4.webp',
					'label' => esc_html__( 'Four Columns', 'trendingnews' ),
				),
				'footer_layout_2' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-3.webp',
					'label' => esc_html__( 'Three Columns', 'trendingnews' ),
				),
				'footer_layout_3' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-2.webp',
					'label' => esc_html__( 'Two Columns', 'trendingnews' ),
				),
				'footer_layout_4' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-2-big-left.webp',
					'label' => esc_html__( 'Two Columns Big Left', 'trendingnews' ),
				),
				'footer_layout_5' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-3-big-middle.webp',
					'label' => esc_html__( 'Three Columns Big Middle', 'trendingnews' ),
				),
				'footer_layout_6' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-2-big-right.webp',
					'label' => esc_html__( 'Two Columns Big Right', 'trendingnews' ),
				),
				'footer_layout_7' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-1.webp',
					'label' => esc_html__( 'Single Column', 'trendingnews' ),
				),
			)
		);
		return $options;
	}
endif;


if ( ! function_exists( 'trendingnews_metro_style_option' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function trendingnews_metro_style_option() {
		$options = apply_filters(
			'trendingnews_metro_style_option',
			array(
				'metro-layout-1'   => __( 'Layout - 1', 'trendingnews' ),
				'metro-layout-2'   => __( 'Layout - 2', 'trendingnews' ),
			)
		);
		return $options;
	}
endif;


if ( ! function_exists( 'trendingnews_preloader_style_option' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function trendingnews_preloader_style_option() {
		$options = apply_filters(
			'trendingnews_preloader_style_option',
			array(
				'style-1'   => __( 'Style - 1', 'trendingnews' ),
				'style-2'   => __( 'Style - 2', 'trendingnews' ),
				'style-3'   => __( 'Style - 3', 'trendingnews' ),
				'style-4'   => __( 'Style - 4', 'trendingnews' ),
				'style-5'   => __( 'Style - 5', 'trendingnews' ),
				'style-6'   => __( 'Style - 6', 'trendingnews' ),
				'style-7'   => __( 'Style - 7', 'trendingnews' ),
				'style-8'   => __( 'Style - 8', 'trendingnews' ),
				'style-9'   => __( 'Style - 9', 'trendingnews' ),
				'style-10'   => __( 'Style - 10', 'trendingnews' ),

			)
		);
		return $options;
	}
endif;


if ( ! function_exists( 'trendingnews_get_recommended_post' ) ) :
	/**
	 * Returns recommended layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function trendingnews_get_recommended_post() {
		$options = apply_filters(
			'trendingnews_get_recommended_post',
			array(
				'wpi-post-recommendation-1' => array(
					'url'   => get_template_directory_uri() . '/assets/images/recommended-1.webp',
					'label' => esc_html__( 'Recommended List View', 'trendingnews' ),
				),
				'wpi-post-recommendation-2' => array(
					'url'   => get_template_directory_uri() . '/assets/images/recommended-2.webp',
					'label' => esc_html__( 'Recommended Grid View', 'trendingnews' ),
				),
				'wpi-post-recommendation-3' => array(
					'url'   => get_template_directory_uri() . '/assets/images/recommended-3.webp',
					'label' => esc_html__( 'Recommended Alternate Grid View', 'trendingnews' ),
				),
			)
		);
		return $options;
	}
endif;



if ( ! function_exists( 'trendingnews_author_meta' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function trendingnews_author_meta() {
		$options = apply_filters(
			'trendingnews_author_meta',
			array(
				'with_label'   => __( 'With Label', 'trendingnews' ),
				'with_icon'   => __( 'With Icon', 'trendingnews' ),
				'with_avatar_image'   => __( 'With Avatar Image', 'trendingnews' ),

			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'trendingnews_date_meta' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function trendingnews_date_meta() {
		$options = apply_filters(
			'trendingnews_date_meta',
			array(
				'with_label'   => __( 'With Label', 'trendingnews' ),
				'with_icon'   => __( 'With Icon', 'trendingnews' ),

			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'trendingnews_get_sidebar_layouts' ) ) :
	/**
	 * Returns general layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function trendingnews_get_sidebar_layouts() {
		$options = apply_filters(
			'trendingnews_sidebar_layouts',
			array(
				'left-sidebar'      => array(
					'url'   => get_template_directory_uri() . '/assets/images/left-sidebar.webp',
					'label' => esc_html__( 'Left Sidebar', 'trendingnews' ),
				),
				'right-sidebar'     => array(
					'url'   => get_template_directory_uri() . '/assets/images/right-sidebar.webp',
					'label' => esc_html__( 'Right Sidebar', 'trendingnews' ),
				),
				'no-sidebar'        => array(
					'url'   => get_template_directory_uri() . '/assets/images/no-sidebar.webp',
					'label' => esc_html__( 'No Sidebar - Wide', 'trendingnews' ),
				),
			)
		);
		return $options;
	}
endif;


if ( ! function_exists( 'trendingnews_get_social_links_styles' ) ) :
	/**
	 * Returns social links styles options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function trendingnews_get_social_links_styles() {
		$options = apply_filters(
			'trendingnews_social_links_styles',
			array(
				'style_1' => __( 'Style 1', 'trendingnews' ),
				'style_2' => __( 'Style 2', 'trendingnews' ),
				'style_3' => __( 'Style 3', 'trendingnews' ),
				'style_4' => __( 'Style 4', 'trendingnews' ),
			)
		);
		return $options;
	}
endif;
