<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Travel X
 */
$travelx_lite_blog_style = get_theme_mod('travelx_lite_blog_style', 'list');
if ($travelx_lite_blog_style == 'grid' && !is_single()) :
	get_template_part('template-parts/content', 'grid');
elseif ($travelx_lite_blog_style == 'list' && !is_single()) :
	get_template_part('template-parts/content', 'list');
else :

	$travel_x_categories = get_the_category();
	if ($travel_x_categories) {
		$travel_x_category = $travel_x_categories[mt_rand(0, count($travel_x_categories) - 1)];
	} else {
		$travel_x_category = '';
	}

?>

	<article id="post-<?php the_ID(); ?>" <?php post_class('myf-classic'); ?>>
		<div class="xpost-item py-4 mb-5">
			<div class="xpost-text p-3">
				<header class="entry-header pb-4 text-center">
					<?php if ('post' === get_post_type() && !empty($travel_x_category) && !is_single()) : ?>
						<a class="blog-categrory" href="<?php echo esc_url(get_category_link($travel_x_category)); ?>"><?php echo esc_html($travel_x_category->name); ?></a>
					<?php endif; ?>
					<?php
					if (is_singular()) :
						the_title('<h1 class="entry-title">', '</h1>');
					else :
						the_title('<h2 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>');
					endif;

					if ('post' === get_post_type()) :
					?>
						<div class="entry-meta">
							<?php travel_x_posted_on(); ?>
						</div><!-- .entry-meta -->
					<?php endif; ?>
				</header><!-- .entry-header -->
				<?php travel_x_post_thumbnail(); ?>

				<div class="entry-content">
					<?php
					if (is_single()) {
						the_content(
							sprintf(
								wp_kses(
									/* translators: %s: Name of current post. Only visible to screen readers */
									__('Continue reading<span class="screen-reader-text"> "%s"</span>', 'travelx-lite'),
									array(
										'span' => array(
											'class' => array(),
										),
									)
								),
								wp_kses_post(get_the_title())
							)
						);

						wp_link_pages(
							array(
								'before' => '<div class="page-links">' . esc_html__('Pages:', 'travelx-lite'),
								'after'  => '</div>',
							)
						);
					} else {
						the_excerpt();
					?>
						<a class="read-more-btn" href="<?php the_permalink(); ?>"><?php esc_html_e('Read More ', 'travelx-lite'); ?></a>
					<?php
					}

					?>
				</div><!-- .entry-content -->
				<?php if (is_single()) : ?>
					<footer class="entry-footer">
						<?php travel_x_entry_footer(); ?>
					</footer><!-- .entry-footer -->
				<?php endif; ?>
			</div>
		</div>
	</article><!-- #post-<?php the_ID(); ?> -->
<?php endif; ?>