<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Travel X
 */
$travel_x_categories = get_the_category();
if ($travel_x_categories) {
	$travel_x_category = $travel_x_categories[mt_rand(0, count($travel_x_categories) - 1)];
} else {
	$travel_x_category = '';
}
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('travel-x-list-item'); ?>>
	<div class="travel-x-item travel-x-text-list shadow-sm mb-5 <?php if (has_post_thumbnail()) : ?>has-thumbnail<?php endif; ?>">
		<div class="row">
			<?php if (has_post_thumbnail()) : ?>
				<div class="col-lg-5">
					<a href="<?php the_permalink(); ?>" aria-label="<?php echo esc_attr(sprintf(__('Read more about %s', 'travelx-lite'), get_the_title())); ?>">
						<?php the_post_thumbnail('medium_large', array('alt' => get_the_title())); ?>
					</a>
				</div>
				<div class="col-lg-7">
				<?php else : ?>
					<div class="col-lg-12 pb-3 pt-3">
					<?php endif; ?>
					<div class="travel-x-text p-3">
						<div class="travel-x-text-inner">
							<div class="grid-head">
								<?php the_title('<h2 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>'); ?>
								<?php if ('post' === get_post_type()) :
								?>
									<div class="list-meta list-author">
										<?php travel_x_posted_by(); ?>
									</div><!-- .entry-meta -->
								<?php endif; ?>
								<?php the_excerpt(); ?>
							</div>
							<a class="travel-x-readmore" href="<?php the_permalink(); ?>"><?php esc_html_e('Read More ', 'travelx-lite'); ?></a>
						</div>
					</div>
					</div>
				</div>

		</div>
</article><!-- #post-<?php the_ID(); ?> -->