<?php

/**
 * TravelX Lite Theme Customizer
 *
 * @package TravelX Lite
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */


function travelx_lite_customize_register($wp_customize)
{
    // Remove parent theme control
    $wp_customize->remove_control('travel_x_blog_style');

    // Add TravelX Lite blog style setting
    $wp_customize->add_setting('travelx_lite_blog_style', array(
        'default'        => 'list',
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'sanitize_callback' => 'travel_x_sanitize_select',
        'transport' => 'refresh',
    ));
    
    $wp_customize->add_control('travelx_lite_blog_style', array(
        'label'      => __('Select Blog Style', 'travelx-lite'),
        'section'    => 'travel_x_blog',
        'settings'   => 'travelx_lite_blog_style',
        'type'       => 'select',
        'choices'    => array(
            'classic' => __('Classic Style', 'travelx-lite'),
            'grid' => __('Grid Style', 'travelx-lite'),
            'list' => __('List Style', 'travelx-lite'),
        ),
    ));

    // Add custom colors section
    $wp_customize->add_section('travelx_lite_colors', array(
        'title'    => __('TravelX Lite Colors', 'travelx-lite'),
        'priority' => 40,
    ));

    // Primary color setting
    $wp_customize->add_setting('travelx_lite_primary_color', array(
        'default'   => '#0ca683',
        'capability' => 'edit_theme_options',
        'type'      => 'theme_mod',
        'sanitize_callback' => 'sanitize_hex_color',
        'transport' => 'postMessage',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'travelx_lite_primary_color', array(
        'label'    => __('Primary Color', 'travelx-lite'),
        'section'  => 'travelx_lite_colors',
        'settings' => 'travelx_lite_primary_color',
    )));

    // Add selective refresh for primary color
    if (isset($wp_customize->selective_refresh)) {
        $wp_customize->selective_refresh->add_partial('travelx_lite_primary_color', array(
            'selector' => ':root',
            'render_callback' => '__return_false',
        ));
    }
}
add_action('customize_register', 'travelx_lite_customize_register', 99);
