<?php
/*This file is part of TravelX Lite child theme.

All functions of this file will be loaded before of parent theme functions.
Learn more at https://codex.wordpress.org/Child_Themes.

Note: this function loads the parent stylesheet before, then child theme stylesheet
(leave it in place unless you know what you are doing.)
*/

if (! defined('TRAVELX_LITE_VERSION')) {
	$travelx_lite_theme = wp_get_theme();
	define('TRAVELX_LITE_VERSION', $travelx_lite_theme->get('Version'));
}


/**
 * Register custom fonts.
 */
function travelx_lite_fonts_url()
{
	$fonts_url = '';

	// Check if Google Fonts are needed
	if ('off' !== _x('on', 'Google font: on or off', 'travelx-lite')) {
		$font_families = array();

		$font_families[] = 'Irish Grover:wght@400';
		$font_families[] = 'Noto Serif:wght@400;700&ital@0;1';
		$font_families[] = 'Merriweather:wght@400;500;600;700&ital@0;1';

		$query_args = array(
			'family' => implode('&family=', $font_families),
			'display' => 'swap',
		);

		$fonts_url = add_query_arg($query_args, 'https://fonts.googleapis.com/css2');
	}

	return esc_url_raw($fonts_url);
}

function travelx_lite_enqueue_child_styles()
{
	wp_enqueue_style('travelx-lite-google-font', travelx_lite_fonts_url(), array(), null);
	wp_enqueue_style('travelx-lite-parent-style', get_template_directory_uri() . '/style.css', array('bootstrap', 'travel-x-main-style', 'travel-x-default-style'), TRAVELX_LITE_VERSION, 'all');
	wp_enqueue_style('travelx-lite-style', get_stylesheet_directory_uri() . '/assets/css/main-style.css', array('travelx-lite-parent-style'), TRAVELX_LITE_VERSION, 'all');
	
	// Add preconnect for external domains for performance
	add_action('wp_head', function() {
		echo '<link rel="preconnect" href="https://fonts.googleapis.com">' . "\n";
		echo '<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>' . "\n";
	}, 1);
}
add_action('wp_enqueue_scripts', 'travelx_lite_enqueue_child_styles');




/**
 * Customizer additions.
 */

require get_stylesheet_directory() . '/inc/customizer.php';



function custom_excerpt_length($length)
{
	if (!is_admin()) {
		return 25;
	}
	return $length;
}
add_filter('excerpt_length', 'custom_excerpt_length');



/**
 * Custom CSS for color customization
 */
function travelx_lite_customize_css() {
    $primary_color = get_theme_mod('travelx_lite_primary_color', '#0ca683');
    
    $custom_css = "
        :root {
            --color-primary: " . esc_attr($primary_color) . ";
        }
    ";
    
    wp_add_inline_style('travelx-lite-style', $custom_css);
}
add_action('wp_enqueue_scripts', 'travelx_lite_customize_css', 20);
