# TravelX Lite Child Theme

A modern WordPress child theme based on Travel X parent theme.

## Features

- **Modern Google Fonts API**: Updated to use the latest Google Fonts API with font-display: swap for better performance
- **CSS Custom Properties**: Uses CSS variables for easy customization
- **Block Editor Support**: Includes editor styles for better Gutenberg experience
- **Color Customization**: Custom color picker in the WordPress Customizer
- **Accessibility Improvements**: Enhanced accessibility features
- **Performance Optimized**: Includes preconnect hints for external resources

## Installation

1. Ensure the parent theme "Travel X" is installed and activated
2. Upload the child theme folder to `/wp-content/themes/`
3. Activate the child theme from WordPress admin

## Customization

### Colors
You can customize the primary color through:
- WordPress Customizer > TravelX Lite Colors > Primary Color

### CSS Variables
The theme uses CSS custom properties that can be easily modified:

```css
:root {
    --color-primary: #0ca683;
    --color-heading: #0d1013;
    --font-primary: "Noto Serif", serif;
    --font-heading: "Koh Santepheap", serif;
}
```

### Blog Layouts
Available through WordPress Customizer:
- Classic Style
- Grid Style  
- List Style

## File Structure

```
travelx-lite/
├── assets/
│   └── css/
│       ├── main-style.css      # Main theme styles
│       └── editor-style.css    # Block editor styles
├── inc/
│   └── customizer.php          # Theme customizer settings
├── template-parts/
│   ├── content.php             # Main content template
│   └── content-list.php        # List view template
├── languages/
│   └── travelx-lite.pot        # Translation template
├── functions.php               # Theme functions
├── style.css                   # Theme header
├── index.php                   # Main template
├── archive.php                 # Archive template
├── search.php                  # Search results template
├── header.php                  # Header template
└── readme.txt                  # Theme information
```

## Changelog

### Version 1.0.3
- Updated Google Fonts API to modern format
- Added CSS custom properties support
- Improved customizer with color controls
- Added block editor styles
- Enhanced accessibility
- Fixed typos in CSS variables
- Updated minimum PHP requirement to 7.4
- Added theme support for responsive embeds and custom logo

## Requirements

- WordPress 5.0+
- PHP 7.4+
- Travel X parent theme

## License

GPL v2 or later
