<?php
global $wp_query;
$travelfic_prefix      = 'travelfic_customizer_settings_';
$travelfic_sidebar     = get_theme_mod($travelfic_prefix . 'blog_sidebar', 'none');
$travelfic_main_class  = $travelfic_sidebar !== 'none' ? 'primary' : 'tft-full-width';

?>
<main id="tf-site-content" class="<?php echo esc_attr($travelfic_main_class); ?> site-main">

    <?php if (have_posts()) :

        if (is_home() && !is_front_page()) :
            ?>
            <header>
                <h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
            </header>
            <?php
        endif;

        /* Start the Loop */
        while (have_posts()) :
            the_post();

            /*
            * Include the Post-Type-specific template for the content.
            * If you want to override this in a child theme, then include a file
            * called content-___.php (where ___ is the Post Type name) and that will be used instead.
            */
            get_template_part('template-parts/content', get_post_type());

        endwhile; 
        if($wp_query->max_num_pages > 1): ?>
        <div class="tft-pagination">
            <?php travelfic_posts_pagination(); ?>
        </div>


    <?php endif; else :
        get_template_part('template-parts/content', 'none');
    endif; ?>

</main><!-- #main -->