<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package travelfic
 */

get_header();
$travelfic_prefix = 'travelfic_customizer_settings_';
$travelfic_sidebar = get_theme_mod($travelfic_prefix.'archive_sidebar', 'none');

if( $travelfic_sidebar == 'none' ){  
	$travelfic_content_wrap_class = 'tft-no-sidebar';
} elseif($travelfic_sidebar == 'left'){ 
	$travelfic_content_wrap_class = 'tft-left-sidebar';
}elseif($travelfic_sidebar == 'right'){
	$travelfic_content_wrap_class = 'tft-right-sidebar';
}else{
	$travelfic_content_wrap_class = 'tft-right-sidebar';
}

$container_class = apply_filters( 'travelfic_page_tftcontainer', '' );

?>
	<div id="site-content" class="tft-site-content tft-single-page tft-customizer-typography">	
	<div class="<?php echo esc_attr( $container_class . ' ' . $travelfic_content_wrap_class ); ?>">
			<main class="primary site-main">
				<?php if ( have_posts() ) : ?>
					<header class="page-header">
						<h1 class="page-title">
							<?php
							/* translators: %s: search query. */
							printf( esc_html__( 'Search Results for: %s', 'travelfic' ), '<span>' . get_search_query() . '</span>' );
							?>
						</h1>
					</header><!-- .page-header -->
					<?php
					/* Start the Loop */
					while ( have_posts() ) :
						the_post();
						/**
						 * Run the loop for the search to output the results.
						 * If you want to overload this in a child theme then include a file
						 * called content-search.php and that will be used instead.
						 */
						get_template_part( 'template-parts/content', 'search' );
					endwhile;
					the_posts_navigation();
				else :
					get_template_part( 'template-parts/content', 'none' );
				endif;
				?>
			</main><!-- #main -->
			
			<?php 
				if( $travelfic_sidebar != 'none'){
					get_sidebar();						
				} 
			?>
		</div>
	</div>
<?php

get_footer();
