<?php 

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function travelfic_setup()
{

    // text domain
    load_theme_textdomain('travelfic', get_template_directory() . '/languages');

    // autometic feed links theme support
    add_theme_support('automatic-feed-links');

    // title tag theme support
    add_theme_support('title-tag');

    // post thumbnails theme support
    add_theme_support('post-thumbnails');

    // register nav menus
    register_nav_menus(
        array(
            'primary_menu' => esc_html__('Primary', 'travelfic'),
            'secondary_menu' => __('Secondary Menu', 'travelfic'),
            'footer_menu'  => __('Footer Menu', 'travelfic'),
        )
    );

    /*
		* Switch default core markup for search form, comment form, and comments
		* to output valid HTML5.
	*/
    add_theme_support(
        'html5',
        array(
            'search-form',
            'comment-form',
            'comment-list',
            'gallery',
            'caption',
            'style',
            'script',
        )
    );

    // Add theme support for selective refresh for widgets.
    add_theme_support('customize-selective-refresh-widgets');

    // add custom logo size
    add_theme_support(
        'custom-logo',
        array(
            'height'      => 250,
            'width'       => 250,
            'flex-width'  => true,
            'flex-height' => true,
        )
    );

    // Add support for full and wide align images.
    add_theme_support('align-wide');

    // Add support for responsive embeds.
    add_theme_support('responsive-embeds');

    // Add support for editor style
    add_editor_style('assets/css/editor-style.css');

    // Add support for block style
    add_theme_support("wp-block-styles");

    // Set the content width in pixels, based on the theme's design and stylesheet.
    $GLOBALS['content_width'] = apply_filters('travelfic_content_width', 640);

    require get_template_directory() . '/inc/customizer/kirki-settings.php'; // Kirki-based customizer settings

    // Remove appearance section if Travelfic theme is active
    if ( is_plugin_active( 'tourfic/tourfic.php' ) ) {
		add_filter( 'tf_settings_sections', function( $sections ) {
			$theme        = wp_get_theme();
			$theme_name   = strtolower( $theme->get( 'Name' ) );
			$parent_theme = $theme->parent() ? strtolower( $theme->parent()->get( 'Name' ) ) : '';

			if ( $theme_name === 'travelfic' || $parent_theme === 'travelfic' ) {
				unset( $sections['appearance'] );
			}

			return $sections;
		} );
	}

}
add_action('after_setup_theme', 'travelfic_setup');
