<?php 

// Travelfic Header

use function PHPSTORM_META\elementType;

add_filter('travelfic_header', 'travelfic_header_callback');
function travelfic_header_callback($travelfic_header){
	$travelfic_prefix = 'travelfic_customizer_settings_';
    $travelfic_transparentHeader = get_theme_mod($travelfic_prefix.'transparent_header', false);
    $travelfic_transparentHeader = $travelfic_transparentHeader ? 'enabled' : 'disabled';
    $travelfic_transparent_showing = get_theme_mod($travelfic_prefix . 'transparent_showing', 'both');
    $travelfic_desktop_transparent_class = '';
    $travelfic_mobile_transparent_class = '';
    if (isset($travelfic_transparentHeader)) {
        if(!empty($travelfic_transparent_showing)){
            if ($travelfic_transparentHeader != 'disabled') {
                if ("both" == $travelfic_transparent_showing || "desktop" == $travelfic_transparent_showing) {
                    $travelfic_desktop_transparent_class = 'tft_has_transparent';
                }
                if ("both" == $travelfic_transparent_showing || "mobile" == $travelfic_transparent_showing) {
                    $travelfic_mobile_transparent_class = 'tft_has_transparent';
                }
            } else {
                $travelfic_desktop_transparent_class = '';
                $travelfic_mobile_transparent_class = '';
            }
        }else{
            $travelfic_desktop_transparent_class = 'tft_has_transparent';
            $travelfic_mobile_transparent_class = 'tft_has_transparent';
        }
    }

    $travelfic_archive_transparentHeader = get_theme_mod($travelfic_prefix.'archive_transparent_header', false);
    $travelfic_archive_transparentHeader = $travelfic_archive_transparentHeader ? 'enabled' : 'disabled';
    $travelfic_show_pages = is_home() || is_archive() || is_search() || is_single() || is_404() || is_page('tf-search') || is_page('my-account') || is_page('tf-login') || is_page('tf-register');
    if($travelfic_show_pages){
        if ("disabled" == $travelfic_archive_transparentHeader) {
            $travelfic_desktop_transparent_class = '';
            $travelfic_mobile_transparent_class = '';
        } else {
            $travelfic_desktop_transparent_class = 'tft_has_transparent';
            $travelfic_mobile_transparent_class = 'tft_has_transparent';
        }
        $travelfic_transparentHeader = $travelfic_archive_transparentHeader;
    }

    $travelfic_site_logo = get_theme_mod($travelfic_prefix . 'site_logo');
    $travelfic_transparent_logo = get_theme_mod($travelfic_prefix . 'trasnparent_logo');
    $travelfic_sticky_logo = get_theme_mod($travelfic_prefix . 'sticky_logo');
    $travelfic_stiky = get_theme_mod($travelfic_prefix.'stiky_header', true);
    $travelfic_stiky = $travelfic_stiky ? 'enabled' : 'disabled';
    $travelfic_header_bg = get_theme_mod($travelfic_prefix.'header_bg_color');

    if( isset( $travelfic_stiky ) ){
        if( $travelfic_stiky != 'disabled' ){
            $travelfic_stiky_class = 'tft_has_sticky';
        }else{
            $travelfic_stiky_class = '';
        }
    }
  
    if (is_page()) {
        $disable_single_page = get_post_meta(get_the_ID(), 'tft-pmb-transfar-header', 'disabled');
        if (!empty($disable_single_page) && $disable_single_page == 'enabled') {
            $travelfic_desktop_transparent_class = 'tft_has_transparent';
            $travelfic_mobile_transparent_class = 'tft_has_transparent';
        }else if(!empty($disable_single_page) && $disable_single_page == 'disabled'){
            $travelfic_desktop_transparent_class = '';
            $travelfic_mobile_transparent_class = '';
        }
    }

    $header_bg = ($travelfic_transparentHeader != 'enabled' && !empty($travelfic_header_bg)) ? esc_attr($travelfic_header_bg) : '';
    $header_back_style = $header_bg ? 'style="background: ' . $header_bg . '"' : '';

	ob_start();
	?>
	<header class="tft-header-design__one tft-customizer-typography <?php echo esc_attr($travelfic_stiky_class); ?>">
        <div class="tft-header-inner">
            <div class="tft-header-desktop tft-main-header-wrapper <?php echo esc_attr( $travelfic_desktop_transparent_class ); ?>" <?php echo $header_back_style; ?>>
                <div class="tf-grid justify-sp-between <?php echo esc_attr( apply_filters( 'travelfic_page_tftcontainer', $travelfic_tftcontainer = '') ); ?>">

                    <!-- Site Branding/Logo -->
                    <div class="tft-header-left site-header-section justify-content-start">
                        <div class="site--brand-logo">
                            <?php
                                if ( $travelfic_transparentHeader == 'enabled' && !empty($travelfic_transparent_logo) ) { ?>
                                    <a href="<?php echo esc_url(home_url('/')); ?>" class="transparent-logo">
                                        <img src="<?php echo esc_url($travelfic_transparent_logo); ?>" alt="<?php esc_attr_e("Logo", "travelfic"); ?>">
                                    </a>
                                <?php 
                                } elseif ( !empty($travelfic_site_logo) ) { ?>
                                    <a href="<?php echo esc_url(home_url('/')); ?>" class="site-logo">
                                        <img src="<?php echo esc_url($travelfic_site_logo); ?>" alt="<?php esc_attr_e("Logo", "travelfic"); ?>">
                                    </a>
                                <?php } else { ?>
                                    <div class="logo-text">
                                        <a href="<?php echo esc_url(home_url('/')); ?>">
                                            <?php bloginfo('name'); ?>
                                        </a>
                                    </div>
                                <?php 
                                }
                                if( isset( $travelfic_stiky ) ){
                                    if( $travelfic_stiky != 'disabled' && !empty($travelfic_sticky_logo) ){ ?>
                                        <a href="<?php echo esc_url(home_url('/')); ?>" class="sticky-logo">
                                            <img src="<?php echo esc_url($travelfic_sticky_logo); ?>" alt="<?php esc_attr_e("Logo", "travelfic"); ?>">
                                        </a>
                                    <?php
                                    }
                                }
                            ?>
                        </div>
                    </div>

                    <!-- Site Navigation Menu -->
                    <div class="tft-header-center site-header-section justify-content-center">
                        <nav class="tft-site-navigation" aria-label="Primary Menu">
                            <?php
                                wp_nav_menu(array(
                                    'theme_location' => 'primary_menu',
                                    'menu_id'        => 'navigation',
                                    'container'      => 'ul',
                                    'menu_class'     => 'main--header-menu tft-flex'
                                ));
                            ?>
                        </nav>
                    </div>
                </div>
            </div>
            <div class="tft-header-mobile <?php echo esc_attr($travelfic_mobile_transparent_class); ?>" <?php echo $header_back_style ?>>
                <div class="tft-main-header-wrapper tft-container-flex tft-align-center justify-sp-between <?php echo esc_attr( apply_filters( 'travelfic_page_tftcontainer', $travelfic_tftcontainer = '') ); ?>">
                    <!-- Site Branding/Logo -->
                    <div class="tft-header-left site-header-section">
                        <div class="site--brand-logo tft-brand-logo">
                        <?php
                            if ( $travelfic_transparentHeader == 'enabled' && !empty($travelfic_transparent_logo) ) { ?>
                                <a href="<?php echo esc_url(home_url('/')); ?>">
                                    <img src="<?php echo esc_url($travelfic_transparent_logo); ?>" alt="<?php esc_attr_e("Logo", "travelfic"); ?>">
                                </a>
                            <?php 
                            } elseif ( !empty($travelfic_site_logo) ) { ?>
                                <a href="<?php echo esc_url(home_url('/')); ?>">
                                    <img src="<?php echo esc_url($travelfic_site_logo); ?>" alt="<?php esc_attr_e("Logo", "travelfic"); ?>">
                                </a>
                            <?php } else { ?>
                                <div class="logo-text">
                                    <a href="<?php echo esc_url(home_url('/')); ?>">
                                        <?php bloginfo('name'); ?>
                                    </a>
                                </div>
                            <?php 
                            }
                            ?>
                        </div>
                    </div>
                    <!-- Site Search Bar -->
                    <div class="tft-header-center site-header-section">
                        <a href="#" class="tft-mobile_menubar">
                            <div class="tft-menubar-active">
                                <i class="fas fa-bars"></i>
                            </div>
                            <div class="tft-menubar-close">
                                <i class="fas fa-times"></i>
                            </div>
                        </a>
                    </div>
                </div>

                <div class="site-header-section tft-mobile-main-menu <?php echo esc_attr( apply_filters( 'travelfic_page_tftcontainer', $travelfic_tftcontainer = '') ); ?>">
                    <nav class="tft-site-navigation" aria-label="Primary Menu">
                        <?php
                        wp_nav_menu(array(
                            'theme_location' => 'primary_menu',
                            'menu_id'        => 'navigation',
                            'container' => 'ul',
                            'menu_class' => 'main--header-menu tft-flex',
                            'walker' => has_nav_menu('primary_menu') ? new Travelfic_Custom_Nav_Walker() : '',
                        ));
                        ?>
                    </nav>
                </div>
            </div>
        </div>
        <?php
        if( isset( $travelfic_stiky ) ){
            if( $travelfic_stiky != 'disabled' ){
            ?>
            <div class="tft-stiky-header-cover"></div>
            <?php
            }
        }
        ?>
    </header>
<?php
$travelfic_header_data = ob_get_clean();
return $travelfic_header_data;
}
