<?php

/**
 * Update Elementor Options
 */
function travelfic_load_elementor_options() {  
    update_option( 'elementor_disable_color_schemes', 'yes' );
    update_option( 'elementor_disable_typography_schemes', 'yes' );
    update_option( 'elementor_global_image_lightbox', '' );
}
add_action( 'elementor/loaded', 'travelfic_load_elementor_options' );

/**
 * Disable Getting Start - Elementor 
 */
function travelfic_elementor_loaded_function() {
    if ( did_action( 'elementor/loaded' ) ) {
        remove_action( 'admin_init', [ \Elementor\Plugin::$instance->admin, 'maybe_redirect_to_getting_started' ] );
    }
};
add_action( 'admin_init', 'travelfic_elementor_loaded_function', 1 );

/**
 * Posts Paginations
 */
if ( !function_exists('travelfic_posts_pagination') ) {
    function travelfic_posts_pagination(){
        the_posts_pagination( array(
            'mid_size'  => 1,
            'prev_text'          => '<i class="fas fa-arrow-left"></i>',
            'next_text'          => '<i class="fas fa-arrow-right"></i>',
            'before_page_number' => '<span class="meta-nav screen-reader-text">' . __( 'Page', 'travelfic' ) . ' </span>',
        ) );
    } 
}

/**
 * Social Share
 */
if ( !function_exists('travelfic_social_share') ) {
function travelfic_social_share($post){ ?>    
    <ul class="share-buttons tft-flex">
        <li>
        <?php 
            $travelfic_facebook_url = "https://www.facebook.com/sharer/sharer.php?u=". get_the_permalink(); ?>
            <a target="_blank" class="share-button share-facebook" href="<?php echo esc_url($travelfic_facebook_url); ?>" rel="noopener noreferrer" title="<?php _e( 'Share on Facebook', 'travelfic' );?>"><i class="fab fa-facebook-f"></i></a>
        </li>
        <li>
            <?php 
            $travelfic_twitter_url = "https://twitter.com/intent/tweet?url=".get_the_permalink()."&text=".get_the_title(); ?>
            <a class="share-twitter" href="<?php echo esc_url($travelfic_twitter_url); ?>" title="<?php _e( 'Tweet this', 'travelfic' );?>" target="_blank" rel="noopener noreferrer">
                <i class="fab fa-twitter"></i>
            </a>
        </li>
        <li>
            <?php 
            $travelfic_pinterest_url = "https://www.pinterest.com/pin/create/%20button?url=".get_the_permalink()."&description=".get_the_title();
            ?>
            <a class="share-pinterest" href="<?php echo esc_url($travelfic_pinterest_url); ?>" target="_blank" title="<?php _e( 'Pin it', 'travelfic' );?>" rel="noopener noreferrer">
                <i class="fab fa-pinterest-p"></i>
            </a>
        </li>
        <li>
            <?php 
            $travelfic_linkedin_url = 'http://www.linkedin.com/shareArticle?mini=true&url='.get_the_permalink().'&title'.get_the_title();
            ?>
            <a class="share-linkedin" href="<?php echo esc_url($travelfic_linkedin_url); ?>" title="<?php _e( 'Share on Linkedin', 'travelfic' );?>" target="_blank" rel="noopener noreferrer">
                <i class="fab fa-linkedin-in"></i>
            </a>
        </li>
    </ul>
<?php 
}
}

if ( ! function_exists( 'travelfic_archive_page_banner' ) ) {
    function travelfic_archive_page_banner(){
        $travelfic_prefix = 'travelfic_customizer_settings_';
        $travelfic_ImageUrl = get_theme_mod($travelfic_prefix.'tf_archive_header_img' , get_template_directory_uri() . '/assets/img/page_header.png');
        
        $travelfic_banner = get_theme_mod($travelfic_prefix . 'archive_banner', 'banner');
        $travelfic_disable_banner = get_post_meta( get_the_ID(), 'tft-pmb-banner', true );

        if( $travelfic_disable_banner != 1 && $travelfic_banner == 'banner' ){
            ?>
                <div class="tf-page-header-inner tft-page-banner blog" 
                    <?php if (!empty($travelfic_ImageUrl)) : ?>
                        style="background-image:url('<?php echo esc_url($travelfic_ImageUrl); ?>');"
                    <?php endif; ?>
                >
                    <div class="<?php echo esc_attr( apply_filters( 'travelfic_page_tftcontainer', $travelfic_tftcontainer = '') ); ?>">
                        <?php  
                            the_archive_title( '<h1 class="page-title">', '</h1>' );
                            the_archive_description( '<div class="archive-description">', '</div>' );
                        ?>
                    </div>
                </div>
            <?php
        }elseif( $travelfic_banner == 'title'){
            ?>
                <div class="<?php echo esc_attr( apply_filters( 'travelfic_page_tftcontainer', $travelfic_tftcontainer = '') ); ?>">
                    <div class="tft-blog-header">
                        <header class="entry-header">
                            <?php  
                                the_archive_title( '<h1 class="page-title">', '</h1>' );
                                the_archive_description( '<div class="archive-description">', '</div>' );
                            ?>
                        </header>
                    </div>
                </div>
            <?php
        }
    }
}

if ( ! function_exists( 'travelfic_blog_page_banner' ) ) {
    function travelfic_blog_page_banner(){
        $travelfic_prefix = 'travelfic_customizer_settings_';
        $travelfic_banner = get_theme_mod($travelfic_prefix . 'blog_banner', 'banner');
        $travelfic_disable_banner = get_post_meta( get_queried_object_id(), 'tft-pmb-banner', true );
        $page_bg_img = get_post_meta(get_queried_object_id(), 'tft-pmb-background-img', true);
        $travelfic_ImageUrl = get_template_directory_uri() . '/assets/img/page_header.png';

        if (!empty($page_bg_img)) {
            $travelfic_ImageUrl = $page_bg_img;
        } else {
            $travelfic_banner_image = get_theme_mod($travelfic_prefix . 'tf_blog_header_img', 'null');
            if ($travelfic_banner_image !== 'null') {
                if (!empty($travelfic_banner_image)) {
                    $travelfic_ImageUrl = $travelfic_banner_image;
                } else {
                    $travelfic_ImageUrl = '';
                }
            }
        }
        

        if( $travelfic_disable_banner != 1 && $travelfic_banner == 'banner' ){
            ?>
                <div class="tf-page-header-inner tft-page-banner blog" 
                    <?php if (!empty($travelfic_ImageUrl)) : ?>
                        style="background-image:url('<?php echo esc_url($travelfic_ImageUrl); ?>');"
                    <?php endif; ?>
                >
                    <h1 class="entry-title">
                        <?php 
                            if (is_home()) {
                                echo get_option('page_for_posts') ? get_the_title(get_option('page_for_posts')) : 'Blog';
                            }else {
                                the_title();
                            }
                        ?>
                    </h1>
                </div>
            <?php
        }elseif( $travelfic_banner == 'title' || $travelfic_banner != 'empty' ){
            ?>
                <div class="<?php echo esc_attr( apply_filters( 'travelfic_page_tftcontainer', $travelfic_tftcontainer = '') ); ?>">
                    <div class="tft-blog-header tft-title-wrap">
                        <header class="entry-header">
                            <h1 class="entry-title">
                            <?php 
                                if (is_home()) {
                                    echo get_option('page_for_posts') ? get_the_title(get_option('page_for_posts')) : 'Blog';
                                }else {
                                    the_title();
                                }
                            ?></h1>
                        </header><!-- .entry-header -->
                    </div>
                </div>
            <?php
        }
    }
}

/**
 * Fix skip link focus in IE11.
 *
 * This does not enqueue the script because it is tiny and because it is only for IE11,
 * thus it does not warrant having an entire dedicated blocking script being loaded.
 *
 * @link https://git.io/vWdr2
 */
function travelfic_skip_link_focus_fix() {
	// The following is minified via `terser --compress --mangle -- js/skip-link-focus-fix.js`.
	?>
	<script>
	/(trident|msie)/i.test(navigator.userAgent)&&document.getElementById&&window.addEventListener&&window.addEventListener("hashchange",function(){var t,e=location.hash.substring(1);/^[A-z0-9_-]+$/.test(e)&&(t=document.getElementById(e))&&(/^(?:a|select|input|button|textarea)$/i.test(t.tagName)||(t.tabIndex=-1),t.focus())},!1);
	</script>
	<?php
}
add_action( 'wp_print_footer_scripts', 'travelfic_skip_link_focus_fix' );


/** 
 * 
 * Travelfic Container Controller
 * 
*/

// Travelfic Page tft-container Controller
add_filter('travelfic_page_tftcontainer', 'travelfic_page_tftcontainer_callback');
function travelfic_page_tftcontainer_callback($travelfic_tftcontainer){
    return 'tft-container';
}



add_filter('widget_tag_cloud_args', 'check_empty_tag_cloud', 10, 1);

function check_empty_tag_cloud($args) {
    $tags = get_tags();
    if (empty($tags)) {
        echo '<p class="no-tags-message">No tags to display.</p>';
        return array('taxonomy' => 'post_tag', 'number' => 0); // Return empty result
    }
    return $args;
}