<?php 

// Travelfic Footer
add_filter('travelfic_footer', 'travelfic_footer_callback');
function travelfic_footer_callback($travelfic_footer){
    $current_year      = date('Y');
    $default_copyright = sprintf( __('© %s Copyright Tourfic Development Site by Themefic. All Rights Reserved.', 'travelfic'), $current_year);
    $copyright_text = get_theme_mod('travelfic_customizer_settings_copyright_text', $default_copyright);
	ob_start();
?>
<footer class="tft-site-footer tft-footer-design__one tft-customizer-typography">
    <div class="<?php echo esc_attr( apply_filters( 'travelfic_page_tftcontainer', $travelfic_tftcontainer = '') ); ?>">
        <?php if ( is_active_sidebar( 'footer_widgets' ) ) { ?>
            <div class="tft-footer-inner tft-container-grid tft-grid-clmn-4 <?php echo esc_attr( apply_filters( 'travelfic_page_tftcontainer', $travelfic_tftcontainer = '') ); ?>">
                <?php dynamic_sidebar( 'footer_widgets' ); ?>
            </div>
        <?php } ?>

        <div class="tft-footer-bottom tft-footer-bottom__one">
            <div class="tft-copyrgith-inner <?php echo esc_attr( apply_filters( 'travelfic_page_tftcontainer', $travelfic_tftcontainer = '') ); ?>">
                <p class="tft-center">
                    <?php echo wp_kses_post(do_shortcode($copyright_text)); ?>
                </p>
            </div>
        </div>
    </div>
</footer>
<?php
	$travelfic_footer_data = ob_get_clean();
	return $travelfic_footer_data;
}