<?php 

/**
 * Enqueue scripts and styles.
 */
function travelfic_scripts() {
    if ( !is_plugin_active( 'tourfic/tourfic.php' ) ) {
        wp_enqueue_style( 'travelfic-fontawesome', get_template_directory_uri() . '/assets/css/all.min.css', array(), TRAVELFIC_VERSION );
    }
	wp_enqueue_style( 'travelfic-style', get_stylesheet_uri(), array(), TRAVELFIC_VERSION, 'all' );
	wp_enqueue_style( 'travelfic-custom-style', get_template_directory_uri() . '/assets/css/travelfic-style.css', array(), TRAVELFIC_VERSION );
	wp_enqueue_script( 'travelfic-script', get_template_directory_uri() . '/assets/js/active.js', array('jquery'), TRAVELFIC_VERSION, true );
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

    wp_localize_script('travelfic-script', 'travelficStickySettings', [
        'stickyBehavior' => get_theme_mod('travelfic_customizer_settings_stiky_header_show_on', 'always'),
    ]);

}
add_action( 'wp_enqueue_scripts', 'travelfic_scripts');


function travelfic_admin_scripts( $screen ) {
    if ( !is_plugin_active( 'tourfic/tourfic.php' ) ) {
       wp_enqueue_style( 'travelfic-fontawesome', get_template_directory_uri() . '/assets/admin/css/all.min.css', array(), TRAVELFIC_VERSION );
    }
    wp_enqueue_style( 'travelfic-style', get_template_directory_uri() . '/assets/admin/css/admin-style.css', array(), TRAVELFIC_VERSION );
	wp_enqueue_script( 'travelfic-script', get_template_directory_uri() . '/assets/admin/js/admin-script.js', array('jquery'), TRAVELFIC_VERSION );
    wp_localize_script( 'travelfic-script', 'travelfic_script_params',
        array(
            'travelfic_theme_nonce'   => wp_create_nonce( 'updates' ),
            'ajax_url'       => admin_url( 'admin-ajax.php' ),
            'installing'     => __( 'Installing...', 'travelfic' ),
            'activating'     => __( 'Activating...', 'travelfic' ),
            'installed'      => __( 'Installed', 'travelfic' ),
            'activated'      => __( 'Activated', 'travelfic' ),
            'install_failed' => __( 'Install failed', 'travelfic' ),
            'redirect_url'   => admin_url('admin.php?page=travelfic-template-list'),
        )
    );
}
add_action( 'admin_enqueue_scripts', 'travelfic_admin_scripts' );
