<?php 

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function travelfic_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'travelfic' ),
			'id'            => 'tf-sidebar',
			'description'   => esc_html__( 'Add widgets here.', 'travelfic' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="tft-widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer Widgets', 'travelfic' ),
			'id'            => 'footer_widgets',
			'description'   => esc_html__( 'Add widgets here.', 'travelfic' ),
			'before_widget' => '<div id="%1$s" class="tft-footer-section %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h2 class="tft-widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'travelfic_widgets_init' );
