<?php

// Register Meta Box
function travelfic_page_meta_boxes()
{
    add_meta_box('travelfic-page-meta', 'Page Settings', 'travelfic_page_meta_boxes_fields', 'page', 'normal');
}
add_action('add_meta_boxes', 'travelfic_page_meta_boxes');

// Meta callback function
function travelfic_page_meta_boxes_fields($post)
{
    $travelfic_page_banner = get_post_meta($post->ID, 'tft-pmb-background-img', true);
    $travelfic_pmb_subtitle = get_post_meta($post->ID, 'tft-pmb-subtitle', true);
    $travelfic_pmb_sidebar = get_post_meta($post->ID, 'tft-pmb-disable-sidebar', true) ? get_post_meta($post->ID, 'tft-pmb-disable-sidebar', true) : '';
    $travelfic_pmb_banner = get_post_meta($post->ID, 'tft-pmb-banner', true) ? get_post_meta($post->ID, 'tft-pmb-banner', true) : '';
    $travelfic_pmb_transfar_header = get_post_meta($post->ID, 'tft-pmb-transfar-header', true) ? get_post_meta($post->ID, 'tft-pmb-transfar-header', true) : 'disabled';

?>
    <div class="travelfic-page-metabox-fields-wrapper">

        <!-- Sidebar -->
        <div class="travelfic-page-metabox-item">
            <div class="travelfic-page-metabox-title">
                <label><?php echo esc_html__('Sidebar', 'travelfic'); ?></label>
            </div>
            <div class="travelfic-page-metabox-field sidebar-selection">
                <label>
                    <span><?php echo esc_html__('Left', 'travelfic'); ?></span>
                    <input type="radio" name="tft-pmb-disable-sidebar" value="left" 
                        <?php checked($travelfic_pmb_sidebar, 'left'); ?> />
                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/admin/img/customizer/sidebar-left.svg"
                        alt="<?php echo esc_attr__('Sidebar Left', 'travelfic'); ?>" class="sidebar-preview">
                </label>

                <label>
                    <span><?php echo esc_html__('Right', 'travelfic'); ?></span>
                    <input type="radio" name="tft-pmb-disable-sidebar" value="right" 
                        <?php checked($travelfic_pmb_sidebar, 'right'); ?> />
                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/admin/img/customizer/sidebar-right.svg" 
                        alt="<?php echo esc_attr__('Sidebar Right', 'travelfic'); ?>" class="sidebar-preview">
                </label>

                <label>
                    <span><?php echo esc_html__('None', 'travelfic'); ?></span>
                    <input type="radio" name="tft-pmb-disable-sidebar" value="none" 
                        <?php checked($travelfic_pmb_sidebar, 'none'); ?> />
                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/admin/img/customizer/container-fullwidth.svg" 
                        alt="<?php echo esc_attr__('No Sidebar', 'travelfic'); ?>" class="sidebar-preview">
                </label>
            </div>
        </div>

        <!-- Page Title Style -->
        <div class="travelfic-page-metabox-item">
            <div class="travelfic-page-metabox-title">
                <label><?php echo esc_html__('Page Title Style', 'travelfic'); ?></label>
            </div>
            <div class="travelfic-page-metabox-field page-title-tabs">
                <label class="page-title-tab">
                    <input type="radio" name="tft-pmb-banner" value="banner" 
                        <?php checked($travelfic_pmb_banner, 'banner'); ?> />
                    <span><?php esc_html_e('Banner', 'travelfic'); ?></span>
                </label>

                <label class="page-title-tab">
                    <input type="radio" name="tft-pmb-banner" value="title-only" 
                        <?php checked($travelfic_pmb_banner, 'title-only'); ?> />
                    <span><?php esc_html_e('Title Only', 'travelfic'); ?></span>
                </label>

                <label class="page-title-tab">
                    <input type="radio" name="tft-pmb-banner" value="none" 
                        <?php checked($travelfic_pmb_banner, 'none'); ?> />
                    <span><?php esc_html_e('None', 'travelfic'); ?></span>
                </label>
            </div>
        </div>

        <!-- Background Image -->
        <div class="travelfic-page-metabox-item" id="background-image-field" style="display: none;">
            <div class="travelfic-page-metabox-title">
                <label for="tft-pmb-background-img"><?php echo esc_html__('Background Image', 'travelfic'); ?></label>
            </div>
            <div class="travelfic-page-metabox-field">
                <div class="travelfic-media-upload-wrapper">
                    <input type="text" class="travelfic-media-url-preview" value="<?php echo !empty($travelfic_page_banner) ? esc_url($travelfic_page_banner) : ''; ?>" disabled>
                    <input type="hidden" class="travelfic-media-url" value="<?php echo !empty($travelfic_page_banner) ? esc_url($travelfic_page_banner) : ''; ?>" name="tft-pmb-background-img">
                    <a href="#" class="travelfic-media-btn upload-btn"><?php echo esc_html__('Upload', 'travelfic'); ?></a>
                    <a href="#" class="travelfic-media-btn remove-btn"><?php echo esc_html__('Remove', 'travelfic'); ?></a>
                </div>
            </div>
        </div>
        
        <!-- Subtitle -->
        <div class="travelfic-page-metabox-item" id="subtitle-field" style="display: none;">
            <div class="travelfic-page-metabox-title">
                <label for="tft-pmb-subtitle"><?php echo esc_html__('Subtitle', 'travelfic'); ?></label>
            </div>
            <div class="travelfic-page-metabox-field">
                <textarea name="tft-pmb-subtitle" id="tft-pmb-subtitle"><?php echo esc_textarea($travelfic_pmb_subtitle); ?></textarea>
            </div>
        </div>
 
        <!-- Transparent Header -->
        <div class="travelfic-page-metabox-item">
            <div class="travelfic-page-metabox-title">
                <label for="tft-pmb-transfar-header"><?php echo esc_html__('Transparent Header', 'travelfic'); ?></label>
            </div>
            <div class="travelfic-page-metabox-field">
                <select name="tft-pmb-transfar-header" id="tft-pmb-transfar-header">
                    <option value="default" <?php selected($travelfic_pmb_transfar_header, 'default'); ?>><?php esc_html_e('Default', 'travelfic'); ?></option>
                    <option value="enabled" <?php selected($travelfic_pmb_transfar_header, 'enabled'); ?>><?php esc_html_e('Enabled', 'travelfic'); ?></option>
                    <option value="disabled" <?php selected($travelfic_pmb_transfar_header, 'disabled'); ?>><?php esc_html_e('Disabled', 'travelfic'); ?></option>
                </select>
            </div>
        </div>
    </div>
<?php
}

// Save meta values
function travelfic_page_meta_boxes_data_save($post_id)
{
    if (isset($_POST['tft-pmb-background-img'])) {
        update_post_meta($post_id, 'tft-pmb-background-img', esc_url_raw($_POST['tft-pmb-background-img']));
    }
    if (isset($_POST['tft-pmb-subtitle'])) {
        update_post_meta($post_id, 'tft-pmb-subtitle', sanitize_text_field($_POST['tft-pmb-subtitle']));
    }
    if(isset($_POST['tft-pmb-disable-sidebar'])){
        update_post_meta($post_id, 'tft-pmb-disable-sidebar', sanitize_text_field($_POST['tft-pmb-disable-sidebar']));
    }
    if(isset($_POST['tft-pmb-banner'])){
        update_post_meta($post_id, 'tft-pmb-banner', sanitize_text_field($_POST['tft-pmb-banner']));
    }
    if(isset($_POST['tft-pmb-transfar-header'])){
        update_post_meta($post_id, 'tft-pmb-transfar-header', sanitize_text_field($_POST['tft-pmb-transfar-header']));
    }
}
add_action('save_post', 'travelfic_page_meta_boxes_data_save');
