const KirkiReactColorfulSwatches = ({ colors = [], onClick }) => {
	return (
		<div className="kirki-color-swatches">
			{colors.map((clr, index) => {
				const color = typeof clr === 'object' && clr?.color ? clr.color : clr;
				const isTransparent = color === 'transparent';

				return (
					<button
						key={index}
						type="button"
						className={`kirki-color-swatch${isTransparent ? ' is-transparent' : ''}`}
						data-kirki-color={color}
						style={{
							backgroundColor: color,
							backgroundImage: isTransparent
								? `linear-gradient(45deg, #ccc 25%, transparent 25%, transparent 75%, #ccc 75%, #ccc),
								   linear-gradient(45deg, #ccc 25%, transparent 25%, transparent 75%, #ccc 75%, #ccc)`
								: 'none',
							backgroundSize: isTransparent ? '10px 10px' : undefined,
							backgroundPosition: isTransparent ? '0 0, 5px 5px' : undefined,
						}}
						onClick={() => onClick?.(color)}
						aria-label={`Select color ${color}`}
					/>
				);
			})}
		</div>
	);
};

export default KirkiReactColorfulSwatches;
