<?php 
travelfic_Kirki::add_section( 'travelfic_customizer_page', array(
	'title'          => esc_html__( 'Page', 'travelfic' ),
	'capability'     => 'edit_theme_options',
	'priority'       => 14,
));



// Page Sidebar
travelfic_Kirki::add_field('travelfic_customizer_options', array(
	'type'        => 'radio-image',
	'settings'    => $prefix . 'page_sidebar',
	'label'       => esc_html__('Sidebar Layout', 'travelfic'),
	'section'     => 'travelfic_customizer_page',
	'default'     => 'right',
	'priority'    => 11,
	'choices'     => array(
		'left'    => get_template_directory_uri() . '/assets/admin/img/customizer/sidebar-left.png',
		'right' => get_template_directory_uri() . '/assets/admin/img/customizer/sidebar-right.png',
		'none' => get_template_directory_uri() . '/assets/admin/img/customizer/sidebar-none.png',
	),
));

// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', array(
	'type'     => 'custom',
	'settings' => $prefix . 'page_banner_before_separator_line',
	'section'  => 'travelfic_customizer_page',
	'default'  => '<hr style="border-top: 1px solid #D1D5DB; margin: 12px -22px 12px;">',
    'priority'       => 12,
));

// page banner style
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'radio-buttonset',
    'settings'    => $prefix . 'page_banner',
    'label'    => esc_html__('Page Title Style', 'travelfic'),
    'section'     => 'travelfic_customizer_page',
    'default'     => 'banner',
    'priority'       => 17,
    'choices'     => [
        'banner'   => esc_html__('Banner', 'travelfic'),
        'title' => esc_html__('Title Only', 'travelfic'),
        'none' => esc_html__('None', 'travelfic'),
    ],
]);

// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'page_banner_after_separator_line',
    'section'     => 'travelfic_customizer_page',
    'priority'   => 18,
    'default'     => '<div class="border-dashed border-bottom tf-pt-12 tf-mb-12"></div>',
	'required' => [
        [
            'setting'  => $prefix . 'page_banner',
            'operator' => '==',
            'value'    => 'banner',
        ],
    ],
]);


// Page Background Image
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'image',
    'settings'    => $prefix . 'page_banner_image',
    'label'       => esc_html__('Background Image', 'travelfic'),
    'section'     => 'travelfic_customizer_page',
    'priority'    => 19,
	'required' => [
        [
            'setting'  => $prefix . 'page_banner',
            'operator' => '==',
            'value'    => 'banner',
        ],
    ],
]);