<?php
travelfic_Kirki::add_section('travelfic_customizer_header', array(
    'title'          => esc_html__('Header Builder', 'travelfic'),
    'capability'     => 'edit_theme_options',
    'priority'       => 11,
));

// Normal Header
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'normal_header',
    'section'     => 'travelfic_customizer_header',
    'default'     => '<h2 class="travelfic-customizer-heading">' . esc_html__('Header', 'travelfic') . '</h2>',
    'priority'    => 10,
]);

// Header background
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'        => 'color',
    'settings'    => $prefix . 'header_bg_color',
    'label'       => esc_html__('Background', 'travelfic'),
    'choices'     => [
        'alpha' => true,
    ],
    'section'     => 'travelfic_customizer_header',
    'priority'    => 11,
    'tab'      => 'settings',
));

// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'header_bg_color_separator_line',
    'section'     => 'travelfic_customizer_header',
    'default'     => '<div class="border-dashed border-bottom tf-pt-12 tf-mb-12"></div>',
    'priority'    => 12,
    'tab'      => 'settings',
]);

// Header Menu Color
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'        => 'multicolor',
    'settings'    => $prefix . 'header_menu_color',
    'label'       => esc_html__('Menu Color', 'travelfic'),
    'section'     => 'travelfic_customizer_header',
    'tab'         => 'settings',
    'priority'    => 13,
    'alpha'       => true,
    'choices'  => [
        'hover'  => esc_html__('Hover', 'travelfic'),
        'normal' => esc_html__('Normal', 'travelfic'),
    ],
));

// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'header_submenu_color_separator_line',
    'section'     => 'travelfic_customizer_header',
    'default'     => '<div class="border-dashed border-bottom tf-mb-12"></div>',
    'priority'    => 14,
    'tab'         => 'settings',
]);

travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'        => 'multicolor',
    'settings'    => $prefix . 'header_submenu_color',
    'label'       => esc_html__('Submenu Color', 'travelfic'),
    'section'     => 'travelfic_customizer_header',
    'tab'         => 'settings',
    'priority'    => 15,
    'alpha'       => true,
    'choices'  => [
        'hover'  => esc_html__('Hover', 'travelfic'),
        'normal' => esc_html__('Normal', 'travelfic'),
    ],
));

//Sticky Header
new \Kirki\Pro\Field\HeadlineToggle(
    [
        'settings' => $prefix . 'stiky_header',
        'label'    => esc_html__('Sticky Header', 'travelfic'),
        'section'  => 'travelfic_customizer_header',
        'default'  => false,
        'priority' => 40,
        'tab'      => 'settings',
    ]
);

travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'radio-buttonset',
    'settings'    => $prefix . 'stiky_header_show_on',
    'label'       => esc_html__('Sticky Show', 'travelfic'),
    'section'     => 'travelfic_customizer_header',
    'default'     => 'always',
    'priority'    => 41,
    'tab'         => 'settings',
    'choices'     => [
        'up'   => esc_html__('Up', 'travelfic'),
        'down' => esc_html__('Down', 'travelfic'),
        'always' => esc_html__('Always', 'travelfic'),
    ],
    'required' => [
        [
            'setting'  => $prefix . 'stiky_header',
            'operator' => '!=',
            'value'    => false,
        ],
    ],
]);

// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'stiky_header_show_on_separator_line',
    'section'     => 'travelfic_customizer_header',
    'priority'   => 41,
    'tab'      => 'settings',
    'default'     => '<div class="border-dashed border-bottom tf-pb-12 tf-mb-12"></div>',
    'required' => [
        [
            'setting'  => $prefix . 'stiky_header',
            'operator' => '!=',
            'value'    => false,
        ],
    ],
]);


// Sticky Header Menu Color
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'        => 'multicolor',
    'settings'    => $prefix . 'stiky_header_menu_text_color',
    'label'       => esc_html__('Menu', 'travelfic'),
    'section'     => 'travelfic_customizer_header',
    'priority'    => 43,
    'alpha'       => true,
    'tab'      => 'settings',
    'choices'     => [
        'hover'  => esc_html__('Hover', 'travelfic'),
        'normal' => esc_html__('Normal', 'travelfic'),
    ],
    'required' => [
        [
            'setting'  => $prefix . 'stiky_header',
            'operator' => '!=',
            'value'    => false,
        ],
    ],
));

// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'stiky_header_menu_text_color_separator_line',
    'section'     => 'travelfic_customizer_header',
    'priority'   => 44,
    'tab'      => 'settings',
    'default'     => '<div class="border-dashed border-bottom tf-pb-12"></div>',
    'required' => [
        [
            'setting'  => $prefix . 'stiky_header',
            'operator' => '!=',
            'value'    => false,
        ],
    ],
]);

//Sticky Header Background color
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'        => 'color',
    'settings'    => $prefix . 'stiky_header_bg_color',
    'label'       => esc_html__('Background', 'travelfic'),
    'section'     => 'travelfic_customizer_header',
    'choices'     => [
        'alpha' => true,
    ],
    'priority'    => 45,
    'tab'      => 'settings',
    'required' => [
        [
            'setting'  => $prefix . 'stiky_header',
            'operator' => '!=',
            'value'    => false,
        ],
    ],
));

// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'sticky_background_blur_before_separator_line',
    'section'     => 'travelfic_customizer_header',
    'priority'    => 46,
    'tab'         => 'settings',
    'default'     => '<div class="border-dashed border-bottom tf-mb-12"></div>',
    'required' => [
        [
            'setting'  => $prefix . 'stiky_header',
            'operator' => '!=',
            'value'    => false,
        ],
    ],
]);

//Sticky Header Background Blur
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'     => 'kirki-input-slider',
    'settings' => $prefix . 'stiky_header_blur',
    'section'  => 'travelfic_customizer_header',
    'label'    => esc_html__('Background Blur', 'travelfic'),
    'priority' => 47,
    'default'  => 24,
    'tab'      => 'settings',
    'required' => [
        [
            'setting'  => $prefix . 'stiky_header',
            'operator' => '!=',
            'value'    => false,
        ],
    ],
));

// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'sticky_background_blur_after_separator_line',
    'section'     => 'travelfic_customizer_header',
    'priority'   => 48,
    'tab'      => 'settings',
    'default'     => '<div class="border-dashed border-bottom tf-pb-12"></div>',
    'required' => [
        [
            'setting'  => $prefix . 'stiky_header',
            'operator' => '!=',
            'value'    => false,
        ],
    ],
]);

// background opacity
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'     => 'kirki-input-slider',
    'settings' => $prefix . 'stiky_header_background_opacity',
    'section'  => 'travelfic_customizer_header',
    'label'    => esc_html__('Background Opacity', 'travelfic'),
    'priority' => 49,
    'tab'      => 'settings',
    'default'  => "100%",
    'choices'     => [
        'min'  => 0,
        'max'  => 100,
        'step' => 1,
    ],
    'choices'    => [
        'units' => "%",
    ],
    'required' => [
        [
            'setting'  => $prefix . 'stiky_header',
            'operator' => '!=',
            'value'    => false,
        ],
    ],
));

// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'stiky_header_background_opacity_before_separator_line',
    'section'     => 'travelfic_customizer_header',
    'priority'   => 50,
    'tab'      => 'settings',
    'default'     => '<div class="border-dashed border-bottom tf-pb-12 tf-mb-12"></div>',
    'required' => [
        [
            'setting'  => $prefix . 'stiky_header',
            'operator' => '!=',
            'value'    => false,
        ],
    ],
]);

// padding
new \Kirki\Pro\Field\Padding([
    'settings'   => $prefix . 'stiky_header_padding',
    'section'    => 'travelfic_customizer_header',
    'label'      => esc_html__('Padding', 'travelfic'),
    'priority'   => 51,
    'tab'      => 'settings',
    'default'     => [
        'desktop' => [
            'top'    => 25,
            'right'  => 12,
            'bottom' => 25,
            'left'   => 12,
        ],
        'tablet' => '',
        'mobile' => '',
    ],
    'responsive' => true,
    'required' => [
        [
            'setting'  => $prefix . 'stiky_header',
            'operator' => '!=',
            'value'    => false,
        ],
    ],
]);


//Transparent Header
new \Kirki\Pro\Field\HeadlineToggle(
    [
        'settings' => $prefix . 'transparent_header',
        'label'    => esc_html__('Transparent Header', 'travelfic'),
        'section'  => 'travelfic_customizer_header',
        'default'  => false,
        'priority' => 54,
        'tab'      => 'settings',  
    ]
);

// mobile header head
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'mobile_header_head',
    'section'     => 'travelfic_customizer_header',
    'default'     => '<h2 class="travelfic-customizer-heading tf-mb-12">' . esc_html__('Mobile Header', 'travelfic') . '</h2>',
    'priority' => 55,
]);

// blog Header Menu Color
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'        => 'color',
    'settings'    => $prefix . 'mobile_header_menu_color',
    'label'       => esc_html__('Menu', 'travelfic'),
    'section'     => 'travelfic_customizer_header',
    'choices'     => [
        'alpha' => true,
    ],
    'priority' => 56,
));

// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'mobile_header_menu_color_separator_line',
    'section'     => 'travelfic_customizer_header',
    'default'     => '<div class="border-dashed border-bottom tf-mb-12 tf-pb-12"></div>',
    'priority' => 57,
]);

// blog Header Menu Color
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'        => 'color',
    'settings'    => $prefix . 'mobile_header_submenu_color',
    'label'       => esc_html__('Submenu', 'travelfic'),
    'section'     => 'travelfic_customizer_header',
    'choices'     => [
        'alpha' => true,
    ],
    'priority'    => 58,
    'tab'         => 'design',
));