<?php
/**
 * 
 * Tagline Theme Options
 * 
 */

//  transparent logo
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'image',
    'settings'    => $prefix . 'site_logo',
    'label'       => esc_html__('Logo', 'travelfic'),
    'section'     => 'title_tagline',
    'priority'    => 7,
    'transport'   => 'refresh',
]);

// Header logo width
new \Kirki\Pro\Field\InputSlider(
    [
        'type'     => 'custom',
        'settings' => $prefix . 'logo_width',
        'section'     => 'title_tagline',
        'label'    => esc_html__('Logo Width', 'travelfic'),
        'priority'    => 8,
        'tab'         => 'settings',
        'default'  => [
            'desktop' => '',
            'tablet'  => '',
            'mobile'  => '',
        ],
        'choices' => [
            'min'  => 0,
            'max'  => 1000,
            'step' => 2,
        ],
        'responsive'  => true,
    ]
);

//  transparent logo
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'image',
    'settings'    => $prefix . 'trasnparent_logo',
    'label'       => esc_html__('Transparent Logo', 'travelfic'),
    'section'     => 'title_tagline',
    'priority'    => 10,
    'transport'   => 'refresh',
]);

//  transparent logo
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'image',
    'settings'    => $prefix . 'sticky_logo',
    'label'       => esc_html__('Sticky Logo', 'travelfic'),
    'section'     => 'title_tagline',
    'priority'    => 11,
    'transport'   => 'refresh',
]);

// global settings
travelfic_Kirki::add_panel('travelfic_customizer_global', array(
    'title'      => esc_html__('Global', 'travelfic'),
    'priority'   => 10,
    'capability' => 'edit_theme_options',
));

/*----------------------------------------
	Typography section -- Typography
------------------------------------------*/
travelfic_Kirki::add_section('travelfic_customizer_typography', array(
    'title'    => esc_html__('Typography', 'travelfic'),
    'panel'    => 'travelfic_customizer_global',
    'priority' => 10,
));

// presets
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'typography_preset_head',
    'section'     => 'travelfic_customizer_typography',
    'default'     => '<h2 class="travelfic-customizer-heading tf-mb-12">' . esc_html__('Presets', 'travelfic') . '</h2>',
]);

// typography presets
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'radio',
    'settings'    => $prefix . 'typography_preset',
    'section'     => 'travelfic_customizer_typography',
    'choices'     => [
        'Cormorant_Garamond/Josefin_Sans' => esc_html__('Aa', 'travelfic'),
        'Brygada_1918/Ubuntu' =>esc_html__('Aa', 'travelfic'),
        'Playfair_Display/Rubik' =>esc_html__('Aa', 'travelfic'),
        'Inter/Inter' =>esc_html__('Aa', 'travelfic'),
        'Chivo/Lora' =>esc_html__('Aa', 'travelfic'),
        'Manrope/Work_Sans' =>esc_html__('Aa', 'travelfic'),
    ],
]);

// base font head
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'typography_base_font_head',
    'section'     => 'travelfic_customizer_typography',
    'default'     => '<h2 class="travelfic-customizer-heading">' . esc_html__('Base Font', 'travelfic') . '</h2>',
]);


// body font
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'body_font',
    'section'     => 'travelfic_customizer_typography',
    'default'     => '
        <div class="d-flex justify-content-between tf-customizer-subtitle-wrapper border-dashed border-bottom tf-mt-12 tf-pb-24">
            <span class="tf-heading-font-title tf-customizer-subtitle">' . esc_html__('Body Font', 'travelfic') . '</span>
            <div class="tf-body-font-edit tf-edit">
                <i class="dashicons dashicons-edit"></i>
                <i class="dashicons dashicons-no-alt"></i>
            </div>
        </div>
    ',
]);

// font wrapper
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'section'     => 'travelfic_customizer_typography',
    'default'     => '<div class="travelfic-body-font-wrapper"></div>',
]);

travelfic_add_font_family_field($prefix . 'body_font_family', 'Font Family', 'travelfic_customizer_typography', 'Nunito');
travelfic_add_font_weight_field($prefix . 'body_font_weight', 'Font Weight', 'travelfic_customizer_typography');
travelfic_add_font_size_field($prefix . 'body_font_size', 'Font Size', 'travelfic_customizer_typography');
travelfic_add_line_height_field($prefix . 'body_font_line_height', 'travelfic_customizer_typography');
travelfic_add_letter_spacing_field($prefix . 'body_font_letter_space', 'travelfic_customizer_typography');
travelfic_add_section_divider($prefix . 'section_divider', 'travelfic_customizer_typography');
travelfic_add_text_transform_field($prefix . 'body_font_transform', 'travelfic_customizer_typography');
travelfic_add_text_decoration_field($prefix . 'body_font_decoration', 'travelfic_customizer_typography');


// headings font fields
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'heading_font',
    'section'     => 'travelfic_customizer_typography',
    'default'     => '
        <div class="d-flex justify-content-between tf-customizer-subtitle-wrapper">
            <span class="tf-heading-font-title tf-customizer-subtitle">' . esc_html__('Headings Font', 'travelfic') . '</span>
            <div class="tf-heading-font-edit tf-edit">
                <i class="dashicons dashicons-edit"></i>
                <i class="dashicons dashicons-no-alt"></i>
            </div>
        </div>
    ',
]);

// font wrapper
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'section'     => 'travelfic_customizer_typography',
    'default'     => '<div class="travelfic-heading-font-wrapper"></div>',
]);
travelfic_add_font_family_field($prefix . 'heading_font_family', 'Font Family', 'travelfic_customizer_typography', 'Cormorant_Garamond');
travelfic_add_font_weight_field($prefix . 'heading_font_weight', 'Font Weight', 'travelfic_customizer_typography');
travelfic_add_font_size_field($prefix . 'heading_font_size', 'Font Size', 'travelfic_customizer_typography');
travelfic_add_line_height_field($prefix . 'heading_font_line_height', 'travelfic_customizer_typography');
travelfic_add_letter_spacing_field($prefix . 'heading_font_letter_space', 'travelfic_customizer_typography');
travelfic_add_section_divider($prefix . 'section_divider', 'travelfic_customizer_typography');
travelfic_add_text_transform_field($prefix . 'heading_font_transform', 'travelfic_customizer_typography');
travelfic_add_text_decoration_field($prefix . 'heading_font_decoration', 'travelfic_customizer_typography');

// Heading font head
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'heading_font_head',
    'section'     => 'travelfic_customizer_typography',
    'default'     => '<h2 class="travelfic-customizer-heading">' . esc_html__('Heading Font', 'travelfic') . '</h2>',
    'priority'    => 10,
]);


// h1 font fields
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'h1_font',
    'section'     => 'travelfic_customizer_typography',
    'default'     => '
        <div class="d-flex justify-content-between tf-customizer-subtitle-wrapper">
            <span class="tf-heading-font-title tf-customizer-subtitle">' . esc_html__('H1 Font', 'travelfic') . '</span>
            <div class="tf-h1-font-edit tf-edit">
                <i class="dashicons dashicons-edit"></i>
                <i class="dashicons dashicons-no-alt"></i>
            </div>
        </div>
    ',
]);

// font wrapper
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'section'     => 'travelfic_customizer_typography',
    'default'     => '<div class="travelfic-h1-font-wrapper"></div>',
]);
travelfic_add_font_family_field($prefix . 'h1_font_family', 'Font Family', 'travelfic_customizer_typography');
travelfic_add_font_weight_field($prefix . 'h1_font_weight', 'Font Weight', 'travelfic_customizer_typography');
travelfic_add_font_size_field($prefix . 'h1_font_size', 'Font Size', 'travelfic_customizer_typography');
travelfic_add_line_height_field($prefix . 'h1_font_line_height', 'travelfic_customizer_typography');
travelfic_add_letter_spacing_field($prefix . 'h1_font_letter_space', 'travelfic_customizer_typography');
travelfic_add_section_divider($prefix . 'section_divider', 'travelfic_customizer_typography');
travelfic_add_text_transform_field($prefix . 'h1_font_transform', 'travelfic_customizer_typography');
travelfic_add_text_decoration_field($prefix . 'h1_font_decoration', 'travelfic_customizer_typography');

//  h2 font fields
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'h2_font',
    'section'     => 'travelfic_customizer_typography',
    'default'     => '
        <div class="d-flex justify-content-between tf-customizer-subtitle-wrapper">
            <span class="tf-heading-font-title tf-customizer-subtitle">' . esc_html__('H2 Font', 'travelfic') . '</span>
            <div class="tf-h2-font-edit tf-edit">
                <i class="dashicons dashicons-edit"></i>
                <i class="dashicons dashicons-no-alt"></i>
            </div>
        </div>
    ',
]);

// font wrapper
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'section'     => 'travelfic_customizer_typography',
    'default'     => '<div class="travelfic-h2-font-wrapper"></div>',
]);
travelfic_add_font_family_field($prefix . 'h2_font_family', 'Font Family', 'travelfic_customizer_typography');
travelfic_add_font_weight_field($prefix . 'h2_font_weight', 'Font Weight', 'travelfic_customizer_typography');
travelfic_add_font_size_field($prefix . 'h2_font_size', 'Font Size', 'travelfic_customizer_typography');
travelfic_add_line_height_field($prefix . 'h2_font_line_height', 'travelfic_customizer_typography');
travelfic_add_letter_spacing_field($prefix . 'h2_font_letter_space', 'travelfic_customizer_typography');
travelfic_add_section_divider($prefix . 'section_divider', 'travelfic_customizer_typography');
travelfic_add_text_transform_field($prefix . 'h2_font_transform', 'travelfic_customizer_typography');
travelfic_add_text_decoration_field($prefix . 'h2_font_decoration', 'travelfic_customizer_typography');

//  h3 font fields
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'h3_font',
    'section'     => 'travelfic_customizer_typography',
    'default'     => '
        <div class="d-flex justify-content-between tf-customizer-subtitle-wrapper">
            <span class="tf-heading-font-title tf-customizer-subtitle">' . esc_html__('H3 Font', 'travelfic') . '</span>
            <div class="tf-h3-font-edit tf-edit">
                <i class="dashicons dashicons-edit"></i>
                <i class="dashicons dashicons-no-alt"></i>
            </div>
        </div>
    ',
]);

// font wrapper
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'section'     => 'travelfic_customizer_typography',
    'default'     => '<div class="travelfic-h3-font-wrapper"></div>',
]);
travelfic_add_font_family_field($prefix . 'h3_font_family', 'Font Family', 'travelfic_customizer_typography');
travelfic_add_font_weight_field($prefix . 'h3_font_weight', 'Font Weight', 'travelfic_customizer_typography');
travelfic_add_font_size_field($prefix . 'h3_font_size', 'Font Size', 'travelfic_customizer_typography');
travelfic_add_line_height_field($prefix . 'h3_font_line_height', 'travelfic_customizer_typography');
travelfic_add_letter_spacing_field($prefix . 'h3_font_letter_space', 'travelfic_customizer_typography');
travelfic_add_section_divider($prefix . 'section_divider', 'travelfic_customizer_typography');
travelfic_add_text_transform_field($prefix . 'h3_font_transform', 'travelfic_customizer_typography');
travelfic_add_text_decoration_field($prefix . 'h3_font_decoration', 'travelfic_customizer_typography');

//  h4 font fields
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'h4_font',
    'section'     => 'travelfic_customizer_typography',
    'default'     => '
        <div class="d-flex justify-content-between tf-customizer-subtitle-wrapper">
            <span class="tf-heading-font-title tf-customizer-subtitle">' . esc_html__('H4 Font', 'travelfic') . '</span>
            <div class="tf-h4-font-edit tf-edit">
                <i class="dashicons dashicons-edit"></i>
                <i class="dashicons dashicons-no-alt"></i>
            </div>
        </div>
    ',
]);

// font wrapper
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'section'     => 'travelfic_customizer_typography',
    'default'     => '<div class="travelfic-h4-font-wrapper"></div>',
]);
travelfic_add_font_family_field($prefix . 'h4_font_family', 'Font Family', 'travelfic_customizer_typography');
travelfic_add_font_weight_field($prefix . 'h4_font_weight', 'Font Weight', 'travelfic_customizer_typography');
travelfic_add_font_size_field($prefix . 'h4_font_size', 'Font Size', 'travelfic_customizer_typography');
travelfic_add_line_height_field($prefix . 'h4_font_line_height', 'travelfic_customizer_typography');
travelfic_add_letter_spacing_field($prefix . 'h4_font_letter_space', 'travelfic_customizer_typography');
travelfic_add_section_divider($prefix . 'section_divider', 'travelfic_customizer_typography');
travelfic_add_text_transform_field($prefix . 'h4_font_transform', 'travelfic_customizer_typography');
travelfic_add_text_decoration_field($prefix . 'h4_font_decoration', 'travelfic_customizer_typography');

//  h5 font fields
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'h5_font',
    'section'     => 'travelfic_customizer_typography',
    'default'     => '
        <div class="d-flex justify-content-between tf-customizer-subtitle-wrapper">
            <span class="tf-heading-font-title tf-customizer-subtitle">' . esc_html__('H5 Font', 'travelfic') . '</span>
            <div class="tf-h5-font-edit tf-edit">
                <i class="dashicons dashicons-edit"></i>
                <i class="dashicons dashicons-no-alt"></i>
            </div>
        </div>
    ',
]);

// font wrapper
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'section'     => 'travelfic_customizer_typography',
    'default'     => '<div class="travelfic-h5-font-wrapper"></div>',
]);
travelfic_add_font_family_field($prefix . 'h5_font_family', 'Font Family', 'travelfic_customizer_typography');
travelfic_add_font_weight_field($prefix . 'h5_font_weight', 'Font Weight', 'travelfic_customizer_typography');
travelfic_add_font_size_field($prefix . 'h5_font_size', 'Font Size', 'travelfic_customizer_typography');
travelfic_add_line_height_field($prefix . 'h5_font_line_height', 'travelfic_customizer_typography');
travelfic_add_letter_spacing_field($prefix . 'h5_font_letter_space', 'travelfic_customizer_typography');
travelfic_add_section_divider($prefix . 'section_divider', 'travelfic_customizer_typography');
travelfic_add_text_transform_field($prefix . 'h5_font_transform', 'travelfic_customizer_typography');
travelfic_add_text_decoration_field($prefix . 'h5_font_decoration', 'travelfic_customizer_typography');

//  h6 font fields
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'h6_font',
    'section'     => 'travelfic_customizer_typography',
    'default'     => '
        <div class="d-flex justify-content-between tf-customizer-subtitle-wrapper">
            <span class="tf-heading-font-title tf-customizer-subtitle">' . esc_html__('H6 Font', 'travelfic') . '</span>
            <div class="tf-h6-font-edit tf-edit">
                <i class="dashicons dashicons-edit"></i>
                <i class="dashicons dashicons-no-alt"></i>
            </div>
        </div>
    ',
]);

// font wrapper
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'section'     => 'travelfic_customizer_typography',
    'default'     => '<div class="travelfic-h6-font-wrapper"></div>',
]);
travelfic_add_font_family_field($prefix . 'h6_font_family', 'Font Family', 'travelfic_customizer_typography');
travelfic_add_font_weight_field($prefix . 'h6_font_weight', 'Font Weight', 'travelfic_customizer_typography');
travelfic_add_font_size_field($prefix . 'h6_font_size', 'Font Size', 'travelfic_customizer_typography');
travelfic_add_line_height_field($prefix . 'h6_font_line_height', 'travelfic_customizer_typography');
travelfic_add_letter_spacing_field($prefix . 'h6_font_letter_space', 'travelfic_customizer_typography');
travelfic_add_section_divider($prefix . 'section_divider', 'travelfic_customizer_typography');
travelfic_add_text_transform_field($prefix . 'h6_font_transform', 'travelfic_customizer_typography');
travelfic_add_text_decoration_field($prefix . 'h6_font_decoration', 'travelfic_customizer_typography');

/*----------------------------------------
	Colors section -- Colors
------------------------------------------*/
travelfic_Kirki::add_section('travelfic_customizer_colors', array(
    'title'       => esc_html__('Colors', 'travelfic'),
    'panel'       => 'travelfic_customizer_global',
    'priority'    => 20,
));

travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'base_font_head',
    'section'     => 'travelfic_customizer_colors',
    'default'     => '<h2 class="travelfic-customizer-heading tf-mb-12">' . esc_html__('Global Palette', 'travelfic') . '</h2>',
]);

// color palette
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type' => 'palette',
    'settings' => $prefix . 'color_palette',
    'section'  => 'travelfic_customizer_colors',
    'default'  => 'design-1',
    'choices'  => array(
        'design-1'  => ['#0E3DD8', '#003C7A', '#686E7A', '#060D1C'],
        'design-2' => ['#B58E53', '#917242', '#99948D', '#595349'],
        'design-3'    => ['#FF6B00', '#C15100', '#6E655E', '#1A0B00'],
        'design-4'  => ['#003162', '#0054A8', '#000', '#faeedc'],
        'custom'   => ['#ddd', '#ccc', '#ddd', '#ccc'],
    ),
));

// brand color head
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'brand_color_head',
    'section'     => 'travelfic_customizer_colors',
    'default'     => '<h2 class="travelfic-customizer-heading">' . esc_html__('Brand Color', 'travelfic') . '</h2>',
]);

// brand default color
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type' => 'color',
    'settings' => $prefix . 'primary_color',
    'label'    => esc_html__('Default', 'travelfic'),
    'section'  => 'travelfic_customizer_colors',
    'default'     => '#0E3DD8',
    'choices'     => [
        'alpha' => true,
    ],
));

// brand dark color
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type' => 'color',
    'settings' => $prefix . 'secondary_color',
    'label'    => esc_html__('Dark', 'travelfic'),
    'section'  => 'travelfic_customizer_colors',
    'default'     => '#003C7A',
    'choices'     => [
        'alpha' => true,
    ],
));

// brand lite color
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type' => 'color',
    'settings' => $prefix . 'brand_lite_color',
    'label'    => esc_html__('Lite', 'travelfic'),
    'section'  => 'travelfic_customizer_colors',
    'default'     => '#C9D4F7',
    'choices'     => [
        'alpha' => true,
    ],
));

// text color head
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'text_color_head',
    'section'     => 'travelfic_customizer_colors',
    'default'     => '<h2 class="travelfic-customizer-heading">' . esc_html__('Text Color', 'travelfic') . '</h2>',
]);

// Heading color
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type' => 'color',
    'settings' => $prefix . 'heading_color',
    'label'    => esc_html__('Heading', 'travelfic'),
    'section'  => 'travelfic_customizer_colors',
    'default'     => '#060D1C',
    'choices'     => [
        'alpha' => true,
    ],
));

// paragraph color
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type' => 'color',
    'settings' => $prefix . 'body_text_color',
    'label'    => esc_html__('Paragraph', 'travelfic'),
    'section'  => 'travelfic_customizer_colors',
    'default'     => '#686E7A',
    'choices'     => [
        'alpha' => true,
    ],
));

// text lite color
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type' => 'color',
    'settings' => $prefix . 'text_lite_color',
    'label'    => esc_html__('Lite', 'travelfic'),
    'section'  => 'travelfic_customizer_colors',
    'default'     => '#F3F5FD',
    'choices'     => [
        'alpha' => true,
    ],
));

// border color head
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'border_color_head',
    'section'     => 'travelfic_customizer_colors',
    'default'     => '<h2 class="travelfic-customizer-heading">' . esc_html__('Border Color', 'travelfic') . '</h2>',
]);

// Border color 
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type' => 'color',
    'settings' => $prefix . 'border_default_color',
    'label'    => esc_html__('Default', 'travelfic'),
    'section'  => 'travelfic_customizer_colors',
    'default'     => '#163A5F',
    'choices'     => [
        'alpha' => true,
    ],
));

// Border color 
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type' => 'color',
    'settings' => $prefix . 'border_lite_color',
    'label'    => esc_html__('Lite', 'travelfic'),
    'section'  => 'travelfic_customizer_colors',
    'default'     => '#D1DFEE',
    'choices'     => [
        'alpha' => true,
    ],
));

// filling color head
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'filling_color_head',
    'section'     => 'travelfic_customizer_colors',
    'default'     => '<h2 class="travelfic-customizer-heading">' . esc_html__('Filling Color', 'travelfic') . '</h2>',
]);

// Light background color
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type' => 'color',
    'settings' => $prefix . 'filling_background',
    'label'    => esc_html__('Background', 'travelfic'),
    'section'  => 'travelfic_customizer_colors',
    'default'     => '#ffffff',
    'choices'     => [
        'alpha' => true,
    ],
));

// Highlights background color
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type' => 'color',
    'settings' => $prefix . 'filling_foreground',
    'label'    => esc_html__('Foreground', 'travelfic'),
    'section'  => 'travelfic_customizer_colors',
    'default'     => '#FFF9F5',
    'choices'     => [
        'alpha' => true,
    ],
));

// Accent color head
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'accent_color_head',
    'section'     => 'travelfic_customizer_colors',
    'default'     => '<h2 class="travelfic-customizer-heading">' . esc_html__('Accent Color', 'travelfic') . '</h2>',
]);

// Links color
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'     => 'color',
    'settings' => $prefix . 'links_color',
    'label'    => esc_html__('Links', 'travelfic'),
    'section'  => 'travelfic_customizer_colors',
    'default'  => '#0E3DD8',
    'choices'     => [
        'alpha' => true,
    ],
));

// Box shadow color 
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type' => 'color',
    'settings' => $prefix . 'box_shadow_color',
    'label'    => esc_html__('Box Shadow', 'travelfic'),
    'section'  => 'travelfic_customizer_colors',
    'default'     => '#E0E8EE',
    'choices'     => [
        'alpha' => true,
    ],
));


/*----------------------------------------
	Container section -- Container
------------------------------------------*/

// Container Section
travelfic_Kirki::add_section('travelfic_customizer_container', array(
    'title'       => esc_html__('Container', 'travelfic'),
    'panel'       => 'travelfic_customizer_global',
    'priority'    => 30,
));

// page width
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'        => 'radio-image',
    'settings'    => $prefix . 'page_width',
    'label'       => esc_html__('Container Layout', 'travelfic'),
    'section'     => 'travelfic_customizer_container',
    'default'     => 'default',
    'priority'    => 10,
    'choices'     => array(
        'default'    => get_template_directory_uri() . '/assets/admin/img/customizer/container-normal.png',
        'full' => get_template_directory_uri() . '/assets/admin/img/customizer/container-fullwidth.png',
    ),
));

// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'     => 'custom',
    'settings' => $prefix . 'page_width_separator_line',
    'section'  => 'travelfic_customizer_container',
    'default'  => '<hr style="border-top: 1px solid #D1D5DB; margin: 0 -22px 12px;">',

));

// Container width
new \Kirki\Pro\Field\InputSlider(
    [
        'type'     => 'custom',
        'settings' => $prefix . 'container_width',
        'section'  => 'travelfic_customizer_container',
        'label'    => esc_html__('Container Width', 'travelfic'),
        'default'  => [
            'desktop' => '',
            'tablet'  => '',
            'mobile'  => '',
        ],
        'choices' => [
            'min'  => 0,
            'max'  => 3000,
            'step' => 100,
        ],
        'responsive'  => true,
        'required' => [
            [
                'setting'  => $prefix . 'page_width',
                'operator' => '==',
                'value'    => 'default',
            ],
        ]
    ]
);

// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'container_padding_before_separator_line',
    'section'     => 'travelfic_customizer_container',
    'tab'        => 'primary',
    'priority'   => 11,
    'default'     => '<div class="border-dashed border-bottom tf-pt-12 tf-mb-12"></div>',
    'required' => [
        [
            'setting'  => $prefix . 'page_width',
            'operator' => '==',
            'value'    => 'default',
        ],
    ],
]);

// Container Padding
new \Kirki\Pro\Field\Padding([
    'settings'   => $prefix . 'container_padding',
    'section'    => 'travelfic_customizer_container',
    'label'       => esc_html__('Padding', 'travelfic'),
    'default'     => [
        'desktop' => '',
        'tablet'  => '',
        'mobile'  => '',
    ],
    'responsive' => true,
    'priority'   => 12,
]);

/*----------------------------------------
	Buttons section -- Buttons
------------------------------------------*/
travelfic_Kirki::add_section('travelfic_customizer_buttons', [
    'title' => esc_html__('Buttons', 'travelfic'),
    'panel' => 'travelfic_customizer_global',
    'priority' => 50,
    'tabs'  => [
        'general' => [
            'label' => esc_html__('General', 'travelfic'),
        ],
        'design'  => [
            'label' => esc_html__('Design', 'travelfic'),
        ],
    ],
]);


// button primary settings
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'        => 'radio',
    'settings'    => $prefix . 'button_primary_preset',
    'label'       => esc_html__('Button Presets', 'travelfic'),
    'section'     => 'travelfic_customizer_buttons',
    'priority'    => 10,
    'tab'         => 'general',
    'choices'     => array(
        'set-1' => esc_html__('Button', 'travelfic'),
        'set-2' => esc_html__('Button', 'travelfic'),
        'set-3' => esc_html__('Button', 'travelfic'),
        'set-4' => esc_html__('Button', 'travelfic'),
        'set-5' => esc_html__('Button', 'travelfic'),
        'set-6' => esc_html__('Button', 'travelfic'),
    ),
));


// separator line 
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'button_primary_color_before_separator_line',
    'section'     => 'travelfic_customizer_buttons',
    'priority'    => 11,
    'tab'         => 'general',
    'default'     => '<div class="border-dashed border-bottom tf-pt-12 tf-mb-12"></div>',
]);


// button primary font
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'button_primary_font',
    'section'     => 'travelfic_customizer_buttons',
    'priority'    => 16,
    'tab'         => 'general',
    'default'     => '
        <div class="d-flex justify-content-between tf-customizer-subtitle-wrapper">
            <span class="tf-buttons-font-title tf-customizer-subtitle">' . esc_html__('Font', 'travelfic') . '</span>
            <div class="tf-buttons-font-edit tf-edit">
                <i class="dashicons dashicons-edit"></i>
                <i class="dashicons dashicons-no-alt"></i>
            </div>
        </div>
    ',
]);

// button primary font wrapper
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'section'     => 'travelfic_customizer_buttons',
    'default'     => '<div class="travelfic-buttons-font-wrapper"></div>',
    'priority'    => 17,
    'tab'         => 'general',
]);
travelfic_add_font_family_field($prefix . 'buttons_font_family', 'Font Family', 'travelfic_customizer_buttons');
travelfic_add_font_weight_field($prefix . 'buttons_font_weight', 'Font Weight', 'travelfic_customizer_buttons');
travelfic_add_font_size_field($prefix . 'buttons_font_size', 'Font Size', 'travelfic_customizer_buttons');
travelfic_add_line_height_field($prefix . 'buttons_font_line_height', 'travelfic_customizer_buttons');
travelfic_add_letter_spacing_field($prefix . 'buttons_font_letter_space', 'travelfic_customizer_buttons');
travelfic_add_section_divider($prefix . 'section_divider', 'travelfic_customizer_buttons');
travelfic_add_text_transform_field($prefix . 'buttons_font_transform', 'travelfic_customizer_buttons');
travelfic_add_text_decoration_field($prefix . 'buttons_font_decoration', 'travelfic_customizer_buttons');

// separator line 
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'button_primary_padding_before_separator_line',
    'section'     => 'travelfic_customizer_buttons',
    'priority'    => 18,
    'tab'         => 'general',
    'default'     => '<div class="border-dashed border-bottom tf-mb-12"></div>',
]);

// button padding
new \Kirki\Pro\Field\Padding([
    'settings'   => $prefix . 'button_primary_padding',
    'section'    => 'travelfic_customizer_buttons',
    'label'      => esc_html__('Padding', 'travelfic'),
    'tab'        => 'general',
    'default'     => [
        'desktop' => '',
        'tablet'  => '',
        'mobile'  => '',
    ],
    'choices'=> [
        'unit' => 'px',
    ],
    'responsive' => true,
    'priority'   => 19,
]);



// separator line 
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'button_primary_padding_after_separator_line',
    'section'     => 'travelfic_customizer_buttons',
    'priority'    => 20,
    'tab'         => 'general',
    'default'     => '<div class="border-dashed border-bottom tf-mb-12"></div>',
]);

// button border
new \Kirki\Pro\Field\Padding([
    'settings'   => $prefix . 'button_primary_border',
    'section'    => 'travelfic_customizer_buttons',
    'label'      => esc_html__('Border Width', 'travelfic'),
    'priority'   => 21,
    'tab'        => 'general',
    'default'     => [
        'desktop' => '',
        'tablet'  => '',
        'mobile'  => '',
    ],
    'responsive' => true,
]);

// separator line 
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'button_primary_border_after_separator_line',
    'section'     => 'travelfic_customizer_buttons',
    'priority'    => 22,
    'tab'         => 'general',
    'default'     => '<div class="border-dashed border-bottom tf-mb-12"></div>',
]);

// button border radius
new \Kirki\Pro\Field\Padding([
    'settings'   => $prefix . 'button_primary_border_radius',
    'section'    => 'travelfic_customizer_buttons',
    'label'      => esc_html__('Border Radius', 'travelfic'),
    'priority'   => 23,
    'tab'        => 'general',
    'default'     => [
        'desktop' => '',
        'tablet'  => '',
        'mobile'  => '',
    ],
    'responsive' => true,
]);

// button box shadow
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'button_primary_box_shadow',
    'section'     => 'travelfic_customizer_buttons',
    'default'     => '<h2 class="travelfic-customizer-heading">' . esc_html__('Box Shadow', 'travelfic') . '</h2>',
    'priority'    => 24,
    'tab'         => 'general',
]);


// shadow color
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'        => 'color',
    'settings'    => $prefix . 'button_primary_shadow_color',
    'label'       => esc_html__('Color', 'travelfic'),
    'section'     => 'travelfic_customizer_buttons',
    'priority'    => 25,
    'tab'         => 'general',
    'choices'     => [
        'alpha' => true,
    ],
));


// shadow blur
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'     => 'slider',
    'settings' => $prefix . 'button_primary_shadow_blur',
    'section'  => 'travelfic_customizer_buttons',
    'label'    => esc_html__('Blur', 'travelfic'),
    'priority' => 26,
    'default'  => 10,
    'tab'      => 'general',
    'choices'  => [
        'min'  => 0,
        'max'  => 100,
        'step' => 1,
    ],
));

// shadow horizontal
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'     => 'slider',
    'settings' => $prefix . 'button_primary_shadow_horizontal',
    'section'  => 'travelfic_customizer_buttons',
    'label'    => esc_html__('Horizontal', 'travelfic'),
    'priority' => 27,
    'default'  => 0,
    'tab'      => 'general',
    'choices'  => [
        'min'  => -100,
        'max'  => 100,
        'step' => 1,
    ],
));

// shadow vertical
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'     => 'slider',
    'settings' => $prefix . 'button_primary_shadow_vertical',
    'section'  => 'travelfic_customizer_buttons',
    'label'    => esc_html__('Vertical', 'travelfic'),
    'priority' => 28,
    'default'  => 0,
    'tab'      => 'general',
    'choices'  => [
        'min'  => -100,
        'max'  => 100,
        'step' => 1,
    ],
));

// button primary color
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'        => 'multicolor',
    'settings'    => $prefix . 'button_primary_text_colors',
    'label'       => esc_html__('Text Color', 'travelfic'),
    'section'     => 'travelfic_customizer_buttons',
    'priority'    => 10,
    'tab'         => 'design',
    'alpha'       => true,
    'choices'  => [
        'hover'  => esc_html__('Hover', 'travelfic'),
        'normal' => esc_html__('Normal', 'travelfic'),
    ],
));

// button background color
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'        => 'multicolor',
    'settings'    => $prefix . 'button_primary_background_colors',
    'label'       => esc_html__('Background Color', 'travelfic'),
    'section'     => 'travelfic_customizer_buttons',
    'priority'    => 11,
    'tab'         => 'design',
    'alpha'       => true,
    'choices'  => [
        'hover'  => esc_html__('Hover', 'travelfic'),
        'normal' => esc_html__('Normal', 'travelfic'),
    ],
));

// button border color
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'        => 'multicolor',
    'settings'    => $prefix . 'button_primary_border_colors',
    'label'       => esc_html__('Border Color', 'travelfic'),
    'section'     => 'travelfic_customizer_buttons',
    'priority'    => 12,
    'tab'         => 'design',
    'alpha'       => true,
    'choices'  => [
        'hover'  => esc_html__('Hover', 'travelfic'),
        'normal' => esc_html__('Normal', 'travelfic'),
    ],
));

/*----------------------------------------
	Scroll To Top section -- Scroll To Top
------------------------------------------*/
travelfic_Kirki::add_section('travelfic_customizer_scroll_to_top', [
    'title' => esc_html__('Scroll To Top', 'travelfic'),
    'panel' => 'travelfic_customizer_global',
    'priority' => 50,
    'tabs'  => [
        'general' => [
            'label' => esc_html__('General', 'travelfic'),
        ],
        'design'  => [
            'label' => esc_html__('Design', 'travelfic'),
        ],
    ],
]);

// enable scroll to top
new \Kirki\Pro\Field\HeadlineToggle(
    [
        'settings' => $prefix . 'enable_scroll_to_top',
        'label'    => esc_html__('Scroll to Top', 'travelfic'),
        'section'  => 'travelfic_customizer_scroll_to_top',
        'tab' => 'general',
        'default'  => false,
    ]
);

// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'     => 'custom',
    'settings' => $prefix . 'enable_scroll_to_top_separator_line',
    'section'  => 'travelfic_customizer_scroll_to_top',
    'default'  => '<hr style="border-top: 1px solid #D1D5DB; margin: 18px -22px 18px;">',
    'tab'      => 'general',
    'required' => [
        [
            'setting'  => $prefix . 'enable_scroll_to_top',
            'operator' => '==',
            'value'    => true,
        ],
    ],
));

// display
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'radio-buttonset',
    'settings'    => $prefix . 'scroll_to_top_display',
    'label'    => esc_html__('Display On', 'travelfic'),
    'section'     => 'travelfic_customizer_scroll_to_top',
    'tab' => 'general',
    'default'     => 'both',
    'choices'     => [
        'desktop'   => esc_html__('Desktop', 'travelfic'),
        'mobile' => esc_html__('Mobile', 'travelfic'),
        'both' => esc_html__('Desktop + Mobile', 'travelfic'),
    ],
    'required' => [
        [
            'setting'  => $prefix . 'enable_scroll_to_top',
            'operator' => '==',
            'value'    => true,
        ],
    ],
]);

// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'     => 'custom',
    'settings' => $prefix . 'scroll_to_top_display_separator_line',
    'section'  => 'travelfic_customizer_scroll_to_top',
    'default'  => '<hr style="border-top: 1px solid #D1D5DB; margin: 18px -22px;">',
    'tab'      => 'general',
    'required' => [
        [
            'setting'  => $prefix . 'enable_scroll_to_top',
            'operator' => '==',
            'value'    => true,
        ],
    ],
));

// position
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'radio-buttonset',
    'settings'    => $prefix . 'scroll_to_top_position',
    'label'    => esc_html__('Position', 'travelfic'),
    'section'     => 'travelfic_customizer_scroll_to_top',
    'tab' => 'general',
    'default'     => 'right',
    'choices'     => [
        'left'   => esc_html__('Left', 'travelfic'),
        'right' => esc_html__('Right', 'travelfic'),
    ],
    'required' => [
        [
            'setting'  => $prefix . 'enable_scroll_to_top',
            'operator' => '==',
            'value'    => true,
        ],
    ],
]);

// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'     => 'custom',
    'settings' => $prefix . 'scroll_to_top_position_separator_line',
    'section'  => 'travelfic_customizer_scroll_to_top',
    'default'  => '<hr style="border-top: 1px solid #D1D5DB; margin: 18px -22px 12px;">',
    'tab'      => 'general',
    'required' => [
        [
            'setting'  => $prefix . 'enable_scroll_to_top',
            'operator' => '==',
            'value'    => true,
        ],
    ],
));

// icon size
new \Kirki\Pro\Field\InputSlider([
    'settings' => $prefix . 'scroll_to_top_size',
    'section'  => 'travelfic_customizer_scroll_to_top',
    'label'    => esc_html__('Icon Size', 'travelfic'),
    'tab'      => 'general',
    'default'  => [
        'desktop' => '15',
        'tablet'  => '',
        'mobile'  => '',
    ],
    'responsive' => true,
    'required' => [
        [
            'setting'  => $prefix . 'enable_scroll_to_top',
            'operator' => '==',
            'value'    => true,
        ],
    ],
]);


// icon color
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'        => 'multicolor',
    'settings'    => $prefix . 'scroll_icon_color',
    'label'       => esc_html__('Icon Color', 'travelfic'),
    'section'     => 'travelfic_customizer_scroll_to_top',
    'tab'         => 'design',
    'priority'   => 10,
    'alpha'       => true,
    'choices'  => [
        'hover'  => esc_html__('Hover', 'travelfic'),
        'normal' => esc_html__('Normal', 'travelfic'),
    ],
));
// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'scroll_icon_color_separator_line',
    'section'     => 'travelfic_customizer_scroll_to_top',
    'tab'         => 'design',
    'priority'    => 10,
    'default'     => '<div class="border-dashed border-bottom tf-pt-12 tf-mb-12"></div>',
]);

// icon background color
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'        => 'multicolor',
    'settings'    => $prefix . 'scroll_icon_background',
    'label'       => esc_html__('Background Color', 'travelfic'),
    'section'     => 'travelfic_customizer_scroll_to_top',
    'tab'         => 'design',
    'priority'    => 11,
    'alpha'       => true,
    'choices'  => [
        'hover'  => esc_html__('Hover', 'travelfic'),
        'normal' => esc_html__('Normal', 'travelfic'),
    ],
));

// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'scroll_icon_background_separator_line',
    'section'     => 'travelfic_customizer_scroll_to_top',
    'tab'         => 'design',
    'priority'    => 12,
    'default'     => '<div class="border-dashed border-bottom tf-pt-12 tf-mb-12"></div>',
]);

// icon border radius
new \Kirki\Pro\Field\Padding([
    'settings'   => $prefix . 'scroll_icon_border_radius',
    'section'    => 'travelfic_customizer_scroll_to_top',
    'label'      => esc_html__('Border Radius', 'travelfic'),
    'tab'        => 'design',
    'priority'   => 13,
    'default'     => [
        'desktop' => '',
        'tablet'  => '',
        'mobile'  => '',
    ],
    'responsive' => true,
]);

