<?php
travelfic_Kirki::add_panel('travelfic_customizer_blog', array(
    'title'          => esc_html__('Blog', 'travelfic'),
    'capability'     => 'edit_theme_options',
    'priority'       => 12,
));

/*----------------------------------------
	Blog/Archive section -- Blog/Archive
------------------------------------------*/
travelfic_Kirki::add_section('travelfic_customizer_archive', array(
    'title'       => esc_html__('Blog / Archive', 'travelfic'),
    'panel'       => 'travelfic_customizer_blog',
));

// blog head
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'blog_head',
    'section'     => 'travelfic_customizer_archive',
    'default'     => '<h2 class="travelfic-customizer-heading">' . esc_html__('Blog', 'travelfic') . '</h2>',
    'priority'    => 10,
]);

// blog sidebar
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'        => 'radio-image',
    'settings'    => $prefix . 'blog_sidebar',
    'label'       => esc_html__('Sidebar Layout', 'travelfic'),
    'section'     => 'travelfic_customizer_archive',
    'default'     => 'none',
    'priority'    => 11,
    'choices'     => array(
        'left'    => get_template_directory_uri() . '/assets/admin/img/customizer/sidebar-left.png',
        'right' => get_template_directory_uri() . '/assets/admin/img/customizer/sidebar-right.png',
        'none' => get_template_directory_uri() . '/assets/admin/img/customizer/sidebar-none.png',
    ),
));

// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'blog_sidebar_after_separator_line',
    'section'     => 'travelfic_customizer_archive',
    'default'     => '<div class="border-dashed border-bottom tf-pt-12 tf-mb-12"></div>',
    'priority'    => 12,
   
]);

// archive transparent header
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'switch',
    'settings'    => $prefix . 'archive_transparent_header',
    'label'       => esc_html__('Transparent Header', 'travelfic'),
    'section'     => 'travelfic_customizer_archive',
    'default'     => 'disabled',
    'priority'    => 14,
    'choices'     => [
        'enabled'  => esc_html__('Enabled', 'travelfic'),
        'disabled' => esc_html__('Disabled', 'travelfic'),
    ],
]);

// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'archive_transparent_header_after_separator_line',
    'section'     => 'travelfic_customizer_archive',
    'default'     => '<div class="border-dashed border-bottom tf-pt-12 tf-mb-12"></div>',
    'priority'    => 15,
   
]);

// blog banner
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'radio-buttonset',
    'settings'    => $prefix . 'blog_banner',
    'label'       => esc_html__('Page Title Style', 'travelfic'),
    'section'     => 'travelfic_customizer_archive',
    'default'     => 'banner',
    'priority'    => 18,
    'choices'     => [
        'banner'=> esc_html__('Banner', 'travelfic'),
        'title' => esc_html__('Title', 'travelfic'),
        'empty' => esc_html__('No title', 'travelfic'),
    ],
]);

// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'blog_banner_after_separator_line',
    'section'     => 'travelfic_customizer_archive',
    'priority'   => 19,
    'default'     => '<div class="border-dashed border-bottom tf-mb-12"></div>',
	'required' => [
        [
            'setting'  => $prefix . 'blog_banner',
            'operator' => '==',
            'value'    => 'banner',
        ],
    ],
]);


// Blog Page Background Image
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'image',
    'settings'    => $prefix . 'tf_blog_header_img',
    'label'       => esc_html__('Background Image', 'travelfic'),
    'section'     => 'travelfic_customizer_archive',
    'priority'    => 20,
    'transport'   => 'refresh',
	'required' => [
        [
            'setting'  => $prefix . 'blog_banner',
            'operator' => '==',
            'value'    => 'banner',
        ],
    ],
]);

// archive head
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'archive_head',
    'section'     => 'travelfic_customizer_archive',
    'priority'    => 21,
    'default'     => '<h2 class="travelfic-customizer-heading tf-mb-12">' . esc_html__('Archive', 'travelfic') . '</h2>',
]);

// archive sidebar
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'        => 'radio-image',
    'settings'    => $prefix . 'archive_sidebar',
    'label'       => esc_html__('Sidebar Layout', 'travelfic'),
    'section'     => 'travelfic_customizer_archive',
    'default'     => 'none',
    'priority'    => 22,
    'choices'     => array(
        'left'    => get_template_directory_uri() . '/assets/admin/img/customizer/sidebar-left.png',
        'right' => get_template_directory_uri() . '/assets/admin/img/customizer/sidebar-right.png',
        'none' => get_template_directory_uri() . '/assets/admin/img/customizer/sidebar-none.png',
    ),
));

// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'archive_sidebar_before_separator_line',
    'section'     => 'travelfic_customizer_archive',
    'default'     => '<div class="border-dashed border-bottom tf-pt-12 tf-mb-12"></div>',
    'priority'    => 23,
]);

// archive banner
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'radio-buttonset',
    'settings'    => $prefix . 'archive_banner',
    'label'       => esc_html__('Page Title Style', 'travelfic'),
    'section'     => 'travelfic_customizer_archive',
    'default'     => 'banner',
    'priority'    => 24,
    'choices'     => [
        'banner'=> esc_html__('Banner', 'travelfic'),
        'title' => esc_html__('Title', 'travelfic'),
        'empty' => esc_html__('No title', 'travelfic'),
    ],
]);

// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'archive_banner_after_separator_line',
    'section'     => 'travelfic_customizer_archive',
    'default'     => '<div class="border-dashed border-bottom tf-pt-12 tf-mb-12"></div>',
    'priority'    => 25,
]);

// archive header image
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'image',
    'settings'    => $prefix . 'tf_archive_header_img',
    'label'       => esc_html__('Background Image', 'travelfic'),
    'section'     => 'travelfic_customizer_archive',
    'priority'    => 26,
    'transport'   => 'refresh',
    'required'    => array(
        array(
            'setting'  => $prefix . 'archive_banner',
            'operator' => '==',
            'value'    => 'banner',
        ),
    ),
]);


/*----------------------------------------
	Single Post section -- Single Post
------------------------------------------*/
travelfic_Kirki::add_section('travelfic_customizer_single_post', array(
    'title'       => esc_html__('Single Post', 'travelfic'),
    'panel'       => 'travelfic_customizer_blog',
));

// single sidebar
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'        => 'radio-image',
    'settings'    => $prefix . 'single_sidebar',
    'label'       => esc_html__('Sidebar Layout', 'travelfic'),
    'section'     => 'travelfic_customizer_single_post',
    'default'     => 'right',
    'priority'    => 10,
    'choices'     => array(
        'left'    => get_template_directory_uri() . '/assets/admin/img/customizer/sidebar-left.png',
        'right' => get_template_directory_uri() . '/assets/admin/img/customizer/sidebar-right.png',
        'none' => get_template_directory_uri() . '/assets/admin/img/customizer/sidebar-none.png',
    ),
));

