<?php
travelfic_Kirki::add_section('travelfic_customizer_404', array(
    'title'          => esc_html__('404', 'travelfic'),
    'capability'     => 'edit_theme_options',
    'priority'       => 17,
));

// page 404 head
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'page_404_head',
    'section'     => 'travelfic_customizer_404',
    'default'     => '<h2 class="travelfic-customizer-heading tf-mb-12">' . esc_html__('404 Content', 'travelfic') . '</h2>',
    'priority'    => 10,
]);

// Page Title
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'        => 'text',
    'settings'    => $prefix . '404_title',
    'label'       => esc_html__('Title', 'travelfic'),
    'section'     => 'travelfic_customizer_404',
    'default'     => esc_html__('Oops! page not found', 'travelfic'),
));

// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'page_404_subtitle_before_separator_line',
    'section'     => 'travelfic_customizer_404',
    'default'     => '<div class="border-dashed border-bottom tf-mb-12 tf-pt-12"></div>',
]);

// Page Sub Title
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'        => 'text',
    'settings'    => $prefix . '404_sub_title',
    'label'       => esc_html__('Sub Title', 'travelfic'),
    'section'     => 'travelfic_customizer_404',
    'default'     => esc_html__('The page you requested could not be found or may have been deleted from the server.', 'travelfic'),
));

// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'page_404_subtitle_after_separator_line',
    'section'     => 'travelfic_customizer_404',
    'default'     => '<div class="border-dashed border-bottom tf-mb-12 tf-pt-12"></div>',
]);

// Button Label
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'        => 'text',
    'settings'    => $prefix . '404_button_label',
    'label'       => esc_html__('Button Label', 'travelfic'),
    'section'     => 'travelfic_customizer_404',
    'default'     => esc_html__('Back to Home', 'travelfic'),
));

// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'page_404_button_url_before_separator_line',
    'section'     => 'travelfic_customizer_404',
    'default'     => '<div class="border-dashed border-bottom tf-mb-12 tf-pt-12"></div>',
]);

// Button URL
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'        => 'url',
    'settings'    => $prefix . '404_button_url',
    'label'       => esc_html__('Button URL', 'travelfic'),
    'section'     => 'travelfic_customizer_404',
    'default'     => esc_url(home_url('/')),
));

// separator line
travelfic_Kirki::add_field('travelfic_customizer_options', [
    'type'        => 'custom',
    'settings'    => $prefix . 'page_404_button_url_after_separator_line',
    'section'     => 'travelfic_customizer_404',
    'default'     => '<div class="border-dashed border-bottom tf-mb-12 tf-pt-12"></div>',
]);

// Background Image
travelfic_Kirki::add_field('travelfic_customizer_options', array(
    'type'        => 'image',
    'settings'    => $prefix . 'tf_404_img',
    'label'       => esc_html__('Background Image', 'travelfic'),
    'section'     => 'travelfic_customizer_404',
    'default'     => get_template_directory_uri() . '/assets/img/page-404.png',
));
