<?php

if (!defined('ABSPATH')) exit;

// class travelfic Kirki
require get_template_directory() . '/inc/customizer/class-travelfic-kirki.php';


// Kirki Tabs pro feature
if (! class_exists('\Kirki\Pro\Tabs\Init')) {
    require_once get_template_directory() . '/inc/kirki/pro-src/packages/kirki-pro-tabs/vendor/autoload.php';
    new \Kirki\Pro\Tabs\Init();
}

// Kirki headline divider pro feature
if (! class_exists('\Kirki\Pro\HeadlineDivider\Init')) {
    require_once get_template_directory() . '/inc/kirki/pro-src/packages/kirki-pro-headline-divider/vendor/autoload.php';
    new \Kirki\Pro\HeadlineDivider\Init();
}

// Kirki input slider pro feature
if (! class_exists('\Kirki\Pro\InputSlider\Init')) {
    require_once get_template_directory() . '/inc/kirki/pro-src/packages/kirki-pro-input-slider/vendor/autoload.php';
    new \Kirki\Pro\InputSlider\Init();
}

// Kirki margin padding pro feature
if (! class_exists('\Kirki\Pro\MarginPadding\Init')) {
    require_once get_template_directory() . '/inc/kirki/pro-src/packages/kirki-pro-margin-padding/vendor/autoload.php';
    new \Kirki\Pro\MarginPadding\Init();
}

// Kirki responsive pro feature
if (! class_exists('\Kirki\Pro\Responsive\Init')) {
    require_once get_template_directory() . '/inc/kirki/pro-src/packages/kirki-pro-responsive/vendor/autoload.php';
    new \Kirki\Pro\Responsive\Init();
}



$prefix = "travelfic_customizer_settings_";


// theme options
require get_template_directory() . '/inc/customizer/theme-options/theme-404.php';
require get_template_directory() . '/inc/customizer/theme-options/theme-blog.php';
require get_template_directory() . '/inc/customizer/theme-options/theme-footer.php';
require get_template_directory() . '/inc/customizer/theme-options/theme-global.php';
require get_template_directory() . '/inc/customizer/theme-options/theme-header.php';
require get_template_directory() . '/inc/customizer/theme-options/theme-page.php';
require get_template_directory() . '/inc/customizer/theme-options/theme-tourfic.php';
require get_template_directory() . '/inc/customizer/theme-options/theme-social.php';

/**
 * 
 * Typography functions
 * Author: Mofazzal Hossain
 * 
 */

// Function to add a font family field
function travelfic_add_font_family_field($settings, $label, $section, $default = '')
{
    travelfic_Kirki::add_field('travelfic_customizer_options', [
        'type'        => 'select',
        'settings'    => $settings,
        'label'       => sprintf(__('%s', 'travelfic'), $label),
        'section'     => $section,
        'default'     => $default,
        'choices'     => function_exists('travelfic_google_fonts_list') ? travelfic_google_fonts_list() : [],
    ]);
}

// Function to add a font weight field
function travelfic_add_font_weight_field($settings, $label, $section, $default = '')
{
    travelfic_Kirki::add_field('travelfic_customizer_options', [
        'type'        => 'radio-buttonset',
        'settings'    => $settings,
        'label'       => sprintf(__('%s', 'travelfic'), $label),
        'section'     => $section,
        'default'     => $default,
        'choices'     => [
            'inherit' => esc_html__('Inherit', 'travelfic'),
            '300'     => esc_html__('300', 'travelfic'),
            '400'     => esc_html__('400', 'travelfic'),
            '500'     => esc_html__('500', 'travelfic'),
            '700'     => esc_html__('700', 'travelfic'),
        ],
    ]);
}

// Function to add a font size field
function travelfic_add_font_size_field($settings, $label, $section, $default = '')
{
    $default_value = [
        'desktop' => '',
        'tablet'  => '',
        'mobile'  => '',
    ];

    if (!empty($default)) {
        $default_value = $default;
    }

    new \Kirki\Pro\Field\InputSlider([
        'settings'   => $settings,
        'label'      => sprintf(__('%s', 'travelfic'), $label),
        'section'    => $section,
        'responsive' => true,
        'default'    => $default_value,
        'choices'    => [
            'max'  => 500,
            'step' => 2,
        ],
    ]);
}

// Function to add a line height field
function travelfic_add_line_height_field($settings, $section, $default = '')
{
    travelfic_Kirki::add_field('travelfic_customizer_options', [
        'type'        => 'number',
        'settings'    => $settings,
        'section'     => $section,
        'default'     => $default,
    ]);
}

// Function to add a letter spacing field
function travelfic_add_letter_spacing_field($settings, $section, $default = '')
{
    travelfic_Kirki::add_field('travelfic_customizer_options', [
        'type'        => 'number',
        'settings'    => $settings,
        'section'     => $section,
        'default'     => $default,
    ]);
}

// Function to add a section divider
function travelfic_add_section_divider($settings, $section)
{
    travelfic_Kirki::add_field('travelfic_customizer_options', [
        'type'        => 'custom',
        'settings'    => $settings,
        'section'     => $section,
    ]);
}

// Function to add a text transform field
function travelfic_add_text_transform_field($settings, $section, $default = '')
{
    travelfic_Kirki::add_field('travelfic_customizer_options', [
        'type'        => 'radio-buttonset',
        'settings'    => $settings,
        'section'     => $section,
        'default'     => $default,
        'choices'     => [
            'initial'   => esc_html__('A', 'travelfic'),
            'lowercase'   => esc_html__('aa', 'travelfic'),
            'capitalize' => esc_html__('Aa', 'travelfic'),
            'uppercase'  => esc_html__('AA', 'travelfic'),
        ],
    ]);
}

// Function to add a text decoration field
function travelfic_add_text_decoration_field($settings, $section, $default = '')
{
    travelfic_Kirki::add_field('travelfic_customizer_options', [
        'type'        => 'radio-buttonset',
        'settings'    => $settings,
        'section'     => $section,
        'default'     => $default,
        'choices'     => [
            'initial'       => esc_html__('Aa', 'travelfic'),
            'italic'       => esc_html__('I', 'travelfic'),
            'underline'     => esc_html__('Aa', 'travelfic'),
            'line-through'  => esc_html__('AA', 'travelfic'),
        ],
    ]);
}


// Function to add a button preset
function travelfic_add_button_preset_class($classes)
{
    $prefix = 'travelfic_customizer_settings_';
    $travelfic_button_preset = get_theme_mod($prefix . 'button_primary_preset', 'set-1');
    $tf_button_bg_colors = get_theme_mod($prefix . 'button_primary_background_colors', []);
    $tf_button_bg_normal = isset($tf_button_bg_colors['normal']) ? $tf_button_bg_colors['normal'] : '';
    if (('set-4' == $travelfic_button_preset || 'set-5' == $travelfic_button_preset || 'set-6' == $travelfic_button_preset) && empty($tf_button_bg_normal)) {
        $classes[] = 'button-' . esc_attr($travelfic_button_preset);
    }
    return $classes;
}
add_filter('body_class', 'travelfic_add_button_preset_class');


// get padding
function get_tf_padding($padding_array, $device)
{
    return [
        'top'    => $padding_array[$device]['top'] ?? '',
        'right'  => $padding_array[$device]['right'] ?? '',
        'bottom' => $padding_array[$device]['bottom'] ?? '',
        'left'   => $padding_array[$device]['left'] ?? '',
    ];
}

// get border width
function get_tf_border_width($border_width_array, $device)
{
    return [
        'top'    => $border_width_array[$device]['top'] ?? '',
        'right'  => $border_width_array[$device]['right'] ?? '',
        'bottom' => $border_width_array[$device]['bottom'] ?? '',
        'left'   => $border_width_array[$device]['left'] ?? '',
    ];
}

// get border
function get_tf_border($border_array, $device)
{
    return [
        'top'    => $border_array[$device]['top'] ?? '',
        'right'  => $border_array[$device]['right'] ?? '',
        'bottom' => $border_array[$device]['bottom'] ?? '',
        'left'   => $border_array[$device]['left'] ?? '',
    ];
}

// get border radius
function get_tf_border_radius($border_radius_array, $device)
{
    return [
        'top'    => $border_radius_array[$device]['top'] ?? '',
        'right'  => $border_radius_array[$device]['right'] ?? '',
        'bottom' => $border_radius_array[$device]['bottom'] ?? '',
        'left'   => $border_radius_array[$device]['left'] ?? '',
    ];
}

// tablet responsive styles
function tf_tablet_responsive_styles($padding = [], $border = [], $radius = [],  $font_size = '', $width = '')
{
    $styles = '';

     if (!empty(array_filter($padding))) {
        if (!empty($padding['top']) && !empty($padding['right']) && !empty($padding['bottom']) && !empty($padding['left'])) {
            $styles .= "padding: " . esc_attr("{$padding['top']} {$padding['right']} {$padding['bottom']} {$padding['left']}") . ";";
        } else {
            if (!empty($padding['top'])) {
                $styles .= "padding-top: " . esc_attr($padding['top']) . ";";
            }
            if (!empty($padding['right'])) {
                $styles .= "padding-right: " . esc_attr($padding['right']) . ";";
            }
            if (!empty($padding['bottom'])) {
                $styles .= "padding-bottom: " . esc_attr($padding['bottom']) . ";";
            }
            if (!empty($padding['left'])) {
                $styles .= "padding-left: " . esc_attr($padding['left']) . ";";
            }
        }
    }

    if (!empty(array_filter($border))) {
        if (!empty($border['top']) && !empty($border['right']) && !empty($border['bottom']) && !empty($border['left']) ) {
            $styles .= "border-width: " . esc_attr("{$border['top']} {$border['right']} {$border['bottom']} {$border['left']}") . ";";
        } else {
            if (!empty($border['top'])) {
                $styles .= "border-top-width: " . esc_attr($border['top']) . ";";
            }
            if (!empty($border['right'])) {
                $styles .= "border-right-width: " . esc_attr($border['right']) . ";";
            }
            if (!empty($border['bottom'])) {
                $styles .= "border-bottom-width: " . esc_attr($border['bottom']) . ";";
            }
            if (!empty($border['left'])) {
                $styles .= "border-left-width: " . esc_attr($border['left']) . ";";
            }
        }
    }

    if (!empty(array_filter($radius))) {
        if (!empty($radius['top']) && !empty($radius['right']) && !empty($radius['bottom']) && !empty($radius['left']) ) {
            $styles .= "border-radius: " . esc_attr("{$radius['top']} {$radius['right']} {$radius['bottom']} {$radius['left']}") . ";";
        } else {
            if (!empty($radius['top'])) {
                $styles .= "border-top-left-radius: " . esc_attr($radius['top']) . ";";
            }
            if (!empty($radius['right'])) {
                $styles .= "border-top-right-radius: " . esc_attr($radius['right']) . ";";
            }
            if (!empty($radius['bottom'])) {
                $styles .= "border-bottom-right-radius: " . esc_attr($radius['bottom']) . ";";
            }
            if (!empty($radius['left'])) {
                $styles .= "border-bottom-left-radius: " . esc_attr($radius['left']) . ";";
            }
        }
    }

    if (!empty($font_size)) {
        $styles .= "font-size: " . esc_attr($font_size) . "px;";
    }

    if (!empty($width)) {
        $styles .= "max-width: " . esc_attr($width);
    }

    return $styles;
}

// mobile responsive styles
function tf_mobile_responsive_styles($padding = [], $border = [], $radius = [],  $font_size = '', $width = '')
{
    $styles = '';

    if (!empty(array_filter($padding))) {
        if (!empty($padding['top']) && !empty($padding['right']) && !empty($padding['bottom']) && !empty($padding['left'])) {
            $styles .= "padding: " . esc_attr("{$padding['top']} {$padding['right']} {$padding['bottom']} {$padding['left']}") . ";";
        } else {
            if (!empty($padding['top'])) {
                $styles .= "padding-top: " . esc_attr($padding['top']) . ";";
            }
            if (!empty($padding['right'])) {
                $styles .= "padding-right: " . esc_attr($padding['right']) . ";";
            }
            if (!empty($padding['bottom'])) {
                $styles .= "padding-bottom: " . esc_attr($padding['bottom']) . ";";
            }
            if (!empty($padding['left'])) {
                $styles .= "padding-left: " . esc_attr($padding['left']) . ";";
            }
        }
    }

    if (!empty(array_filter($border))) {
        if (!empty($border['top']) && !empty($border['right']) && !empty($border['bottom']) && !empty($border['left']) ) {
            $styles .= "border-width: " . esc_attr("{$border['top']} {$border['right']} {$border['bottom']} {$border['left']}") . ";";
        } else {
            if (!empty($border['top'])) {
                $styles .= "border-top-width: " . esc_attr($border['top']) . ";";
            }
            if (!empty($border['right'])) {
                $styles .= "border-right-width: " . esc_attr($border['right']) . ";";
            }
            if (!empty($border['bottom'])) {
                $styles .= "border-bottom-width: " . esc_attr($border['bottom']) . ";";
            }
            if (!empty($border['left'])) {
                $styles .= "border-left-width: " . esc_attr($border['left']) . ";";
            }
        }
    }


    if (!empty(array_filter($radius))) {
        if (!empty($radius['top']) && !empty($radius['right']) && !empty($radius['bottom']) && !empty($radius['left']) ) {
            $styles .= "border-radius: " . esc_attr("{$radius['top']} {$radius['right']} {$radius['bottom']} {$radius['left']}") . ";";
        } else {
            if (!empty($radius['top'])) {
                $styles .= "border-top-left-radius: " . esc_attr($radius['top']) . ";";
            }
            if (!empty($radius['right'])) {
                $styles .= "border-top-right-radius: " . esc_attr($radius['right']) . ";";
            }
            if (!empty($radius['bottom'])) {
                $styles .= "border-bottom-right-radius: " . esc_attr($radius['bottom']) . ";";
            }
            if (!empty($radius['left'])) {
                $styles .= "border-bottom-left-radius: " . esc_attr($radius['left']) . ";";
            }
        }
    }

    if (!empty($font_size)) {
        $styles .= "font-size: " . esc_attr($font_size) . "px;";
    }

    if (!empty($width)) {
        $styles .= "max-width: " . esc_attr($width);
    }

    return $styles;
}
