<?php
/**
 * travelfic Theme Customizer
 *
 * @package travelfic
 *
 *
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */


function travelfic_customize_register($wp_customize)
{
    class Travelfic_Separator_Control extends WP_Customize_Control
    {
        public function render_content()
        {
            ?>
			 <br><hr>
			<?php
        }
    }
    class Travelfic_Info_Control extends WP_Customize_Control {
        public function render_content() {
            ?>
            <label style="font-size: 14px;">
                <span style="font-weight:bold"><?php echo esc_html( $this->label ); ?>:</span>                
                <span><?php echo esc_html( $this->description ); ?></span>
            </label>
            <?php
        }
    }


    
    $wp_customize->get_setting("blogname")->transport = "postMessage";
    $wp_customize->get_setting("blogdescription")->transport = "postMessage";
    if (isset($wp_customize->selective_refresh)) {
        $wp_customize->selective_refresh->add_partial("blogname", [
            "selector" => ".site-title a",
            "render_callback" => "travelfic_customize_partial_blogname",
        ]);
        $wp_customize->selective_refresh->add_partial("blogdescription", [
            "selector" => ".site-description",
            "render_callback" => "travelfic_customize_partial_blogdescription",
        ]);
    }

}
add_action("customize_register", "travelfic_customize_register");
/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function travelfic_customize_partial_blogname()
{
    bloginfo("name");
}
/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function travelfic_customize_partial_blogdescription()
{
    bloginfo("description");
}


/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function travelfic_customizer_admin_scripts() {
    wp_enqueue_style( 'travelfic-customizer-css', get_template_directory_uri() . '/assets/admin/css/customizer.css', array(), TRAVELFIC_VERSION );
	wp_enqueue_script( 'travelfic-customizer-js', get_template_directory_uri() . '/assets/js/customizer.js', array( 'jquery','customize-preview' ), TRAVELFIC_VERSION, true );
}
add_action( 'customize_controls_enqueue_scripts', 'travelfic_customizer_admin_scripts' );
add_action( 'customize_preview_init', 'travelfic_customizer_admin_scripts' );