<?php

if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

add_action('after_setup_theme', 'travelfic_customizer_migrator');

function travelfic_customizer_migrator() {
    if (get_option('travelfic_customizer_migrated')) {
        return;
    }

    $travelfic_prefix = 'travelfic_customizer_settings_';
    $travelfic_customizer_keys = [
        'stiky_header',
        'transparent_header',
        'archive_transparent_header'
    ];

    foreach ($travelfic_customizer_keys as $key) {
        $travelfic_customizer_key = $travelfic_prefix . $key;
        $travelfic_customizer_value = get_theme_mod($travelfic_customizer_key);

        if ($travelfic_customizer_value === 'enabled') {
            set_theme_mod($travelfic_customizer_key, true);
        } elseif ($travelfic_customizer_value === 'disabled') {
            set_theme_mod($travelfic_customizer_key, false);
        }
    }

    update_option('travelfic_customizer_migrated', true);

}
