<?php

// travelfic Customizer Options

use WPForms\Vendor\Core\Logger\ConsoleLogger;

function travelfic_customizer_style()

{

    $prefix = 'travelfic_customizer_settings_';


    // logo width
    $tf_logo_width = get_theme_mod($prefix . 'logo_width', []);
    $tf_desktop_logo_width = isset( $tf_logo_width['desktop'] ) && $tf_logo_width['desktop'] !== 'NaN' ? $tf_logo_width['desktop'].'px' : '';
    $tf_tablet_logo_width  = isset( $tf_logo_width['tablet'] ) && $tf_logo_width['tablet'] !== 'NaN' ? $tf_logo_width['tablet'].'px' : '';
    $tf_mobile_logo_width  = isset( $tf_logo_width['mobile'] ) && $tf_logo_width['mobile'] !== 'NaN' ? $tf_logo_width['mobile'].'px' : '';


    /**
     * 
     * Global Settings 
     * 
     */

    // body typography settings
    $tf_body_font_family = get_theme_mod($prefix . 'body_font_family', '');
    $tf_body_font_family = !empty($tf_body_font_family) ? str_replace("_", " ", $tf_body_font_family) : '';
    $tf_body_font_weight = get_theme_mod($prefix . 'body_font_weight', '');
    $tf_body_font_size = get_theme_mod($prefix . 'body_font_size', []);
    
    $tf_desktop_body_size = isset( $tf_body_font_size['desktop'] ) && $tf_body_font_size['desktop'] != 'NaN' ? $tf_body_font_size['desktop'] : '';
    $tf_tablet_body_size  = isset( $tf_body_font_size['tablet'] ) && $tf_body_font_size['tablet'] != 'NaN' ? $tf_body_font_size['tablet'] : '';
    $tf_mobile_body_size  = isset( $tf_body_font_size['mobile'] ) && $tf_body_font_size['mobile'] != 'NaN' ? $tf_body_font_size['mobile'] : '';

    $tf_body_font_line_height = get_theme_mod($prefix . 'body_font_line_height', '');
    $tf_body_font_letter_space = get_theme_mod($prefix . 'body_font_letter_space', '');
    $tf_body_font_transform = get_theme_mod($prefix . 'body_font_transform', '');
    $tf_body_font_decoration = get_theme_mod($prefix . 'body_font_decoration', '');
    $tf_body_font_style = '';

    if('italic' === $tf_body_font_decoration) {
        $tf_body_font_style = $tf_body_font_decoration;
        $tf_body_font_decoration = '';
    }

    // headings typography settings
    $tf_headings_font_family = get_theme_mod($prefix . 'heading_font_family');
    $tf_headings_font_family = !empty($tf_headings_font_family) ? str_replace("_", " ", $tf_headings_font_family) : '';
    $tf_headings_font_weight = get_theme_mod($prefix . 'heading_font_weight');
    $tf_headings_font_size = get_theme_mod($prefix . 'heading_font_size', []);
    $tf_desktop_headings_size = isset($tf_headings_font_size['desktop']) && $tf_headings_font_size['desktop'] !== 'NaN' ? $tf_headings_font_size['desktop'] : '';
    $tf_tablet_headings_size  = isset( $tf_headings_font_size['tablet'] ) && $tf_headings_font_size['tablet'] !== 'NaN' ? $tf_headings_font_size['tablet'] : '';
    $tf_mobile_headings_size  = isset( $tf_headings_font_size['mobile'] ) && $tf_headings_font_size['mobile'] !== 'NaN' ? $tf_headings_font_size['mobile'] : '';


    $tf_headings_font_line_height = get_theme_mod($prefix . 'heading_font_line_height');
    $tf_headings_font_letter_space = get_theme_mod($prefix . 'heading_font_letter_space');
    $tf_headings_font_transform = get_theme_mod($prefix . 'heading_font_transform');
    $tf_headings_font_decoration = get_theme_mod($prefix . 'heading_font_decoration');

    // h1 to h6 typography settings
    $headings = ['h1', 'h2', 'h3', 'h4', 'h5', 'h6'];
    $tf_headings = [];

    foreach ($headings as $heading) {
        $tf_headings[$heading] = [
            'font_family' => get_theme_mod($prefix . $heading . '_font_family'),
            'font_weight' => get_theme_mod($prefix . $heading . '_font_weight'),
            'font_size' => get_theme_mod($prefix . $heading . '_font_size'),
            'font_line_height' => get_theme_mod($prefix . $heading . '_font_line_height'),
            'font_letter_space' => get_theme_mod($prefix . $heading . '_font_letter_space'),
            'font_transform' => get_theme_mod($prefix . $heading . '_font_transform'),
            'font_decoration' => get_theme_mod($prefix . $heading . '_font_decoration'),
        ];
    }

    // theme brand color
    $tf_primary_color = get_theme_mod($prefix . 'primary_color', '#0E3DD8');
    $tf_secondary_color = get_theme_mod($prefix . 'secondary_color', '#003C7A');
    $tf_brand_lite_color = get_theme_mod($prefix . 'brand_lite_color', '#C9D4F7');
    
    // theme text color
    $tf_heading_color = get_theme_mod($prefix . 'heading_color', '#060D1C');
    $tf_body_text_color = get_theme_mod($prefix . 'body_text_color', '#686E7A');
    $tf_text_lite_color = get_theme_mod($prefix . 'text_lite_color', '#F3F5FD');

    // theme border color
    $tf_border_default_color = get_theme_mod($prefix . 'border_default_color', '#163A5F');
    $tf_border_lite_color = get_theme_mod($prefix . 'border_lite_color', '#f4f4f4');

    // filling color
    $tf_filling_background = get_theme_mod($prefix . 'filling_background', '#ffffff');
    $tf_filling_foreground = get_theme_mod($prefix . 'filling_foreground', '#FFF9F5');

    // theme accent color
    $tf_links_color = get_theme_mod($prefix . 'links_color', $tf_primary_color);
    $tf_box_shadow_color = get_theme_mod($prefix . 'box_shadow_color', '#e0e8ee');

    // Theme global container
    $tf_container_layout = get_theme_mod($prefix . 'page_width', 'default');
    $tf_container_width = get_theme_mod($prefix . 'container_width', []);

    // container width
    $tf_tablet_container_width = '';
    $tf_mobile_container_width = '';
    $tf_container_maxwidth = '';

    if ('full' === $tf_container_layout) {
        $tf_container_maxwidth = '100%';
        $tf_tablet_container_width = '100%';
        $tf_mobile_container_width = '100%';
    } else if ('default' === $tf_container_layout && !empty($tf_container_width)) {
        $tf_container_maxwidth = (!empty($tf_container_width['desktop']) && 'NaN' !== $tf_container_width['desktop']) ? $tf_container_width['desktop'] .'px' : '';
        $tf_tablet_container_width = (!empty($tf_container_width['tablet']) && 'NaN' !== $tf_container_width['tablet'])  ? $tf_container_width['tablet'] .'px' : '';
        $tf_mobile_container_width = (!empty($tf_container_width['mobile']) && 'NaN' !== $tf_container_width['mobile'])  ? $tf_container_width['mobile'] .'px' : '';
    }

    // container padding
    $tf_container_padding = get_theme_mod($prefix . 'container_padding', []);
    $tf_desktop_container_padding = get_tf_padding($tf_container_padding, 'desktop');
    $tf_tablet_container_padding = get_tf_padding($tf_container_padding, 'tablet');
    $tf_mobile_container_padding = get_tf_padding($tf_container_padding, 'mobile');


    // normal header
    $tf_header_menu_colors = get_theme_mod($prefix . 'header_menu_color', []);
    $tf_header_menu_color = '';
    $tf_header_menu_hover_color = '';
    
    if (is_array($tf_header_menu_colors) && !empty($tf_header_menu_colors)) {
        $tf_header_menu_color = isset($tf_header_menu_colors['normal']) ? $tf_header_menu_colors['normal'] : '';
        $tf_header_menu_hover_color = isset($tf_header_menu_colors['hover']) ? $tf_header_menu_colors['hover'] : '';
    }

    // normal header submenu
    $tf_header_submenu_colors = get_theme_mod($prefix . 'header_submenu_color', []);
    $tf_header_submenu_color = '';
    $tf_header_submenu_hover_color = '';
    if (is_array($tf_header_submenu_colors) && !empty($tf_header_submenu_colors)) {
        $tf_header_submenu_color = isset($tf_header_submenu_colors['normal']) ? $tf_header_submenu_colors['normal'] : '';
        $tf_header_submenu_hover_color = isset($tf_header_submenu_colors['hover']) ? $tf_header_submenu_colors['hover'] : '';
    }


    // mobile header
    $travelfic_mobile_menu_color = get_theme_mod($prefix . 'mobile_header_menu_color');
    $travelfic_mobile_submenu_color = get_theme_mod($prefix . 'mobile_header_submenu_color', []);


    // Stiky Header
    $tf_sticky_bg_color = get_theme_mod($prefix . 'stiky_header_bg_color', '');

    $tf_sticky_menu_colors = get_theme_mod($prefix . 'stiky_header_menu_text_color', []);
    if (is_array($tf_sticky_menu_colors) && !empty($tf_sticky_menu_colors)) {
        $tf_sticky_menu_color = isset($tf_sticky_menu_colors['normal']) ? $tf_sticky_menu_colors['normal'] : '';
        $tf_sticky_color_hover = isset($tf_sticky_menu_colors['hover']) ? $tf_sticky_menu_colors['hover'] : '';
    }
    $tf_sticky_bg_blur = get_theme_mod($prefix . 'stiky_header_blur', '24');
    $tf_sticky_bg_opacity = get_theme_mod($prefix . 'stiky_header_background_opacity', '100%');

    $tf_sticky_bg_padding = get_theme_mod($prefix . 'stiky_header_padding', []);
    $tf_desktop_sticky_padding = get_tf_padding($tf_sticky_bg_padding, 'desktop');
    $tf_tablet_sticky_padding = get_tf_padding($tf_sticky_bg_padding, 'tablet');
    $tf_mobile_sticky_padding = get_tf_padding($tf_sticky_bg_padding, 'mobile');


    // buttons
    $tf_button_preset = get_theme_mod($prefix . 'button_primary_preset', '');
    $tf_button_text_colors = get_theme_mod($prefix . 'button_primary_text_colors', []);
    $tf_button_text_color = '';
    $tf_button_text_hover_color = '';
    if (is_array($tf_button_text_colors) && !empty($tf_button_text_colors)) {
        $tf_button_text_color = isset($tf_button_text_colors['normal']) ? $tf_button_text_colors['normal'] : '';
        $tf_button_text_hover_color = isset($tf_button_text_colors['hover']) ? $tf_button_text_colors['hover'] : '';
    }

    $tf_button_bg_colors = get_theme_mod($prefix . 'button_primary_background_colors', []);
    $tf_button_bg_color = '';
    $tf_button_bg_hover_color = '';
    if (is_array($tf_button_bg_colors) && !empty($tf_button_bg_colors)) {
        $tf_button_bg_color = isset($tf_button_bg_colors['normal']) ? $tf_button_bg_colors['normal'] : '';
        $tf_button_bg_hover_color = isset($tf_button_bg_colors['hover']) ? $tf_button_bg_colors['hover'] : '';
    }

    $tf_button_border_colors = get_theme_mod($prefix . 'button_primary_border_colors', []);
    $tf_button_border_color = '';
    $tf_button_border_hover_color = '';
    if (is_array($tf_button_border_colors) && !empty($tf_button_border_colors)) {
        $tf_button_border_color = $tf_button_border_colors['normal'] ? $tf_button_border_colors['normal'] : '';
        $tf_button_border_hover_color = $tf_button_border_colors['hover'] ? $tf_button_border_colors['hover'] : '';
    }

    $tf_button_font_family = get_theme_mod($prefix . 'buttons_font_family', '');
    $tf_button_font_family = !empty($tf_button_font_family) ? str_replace("_", ' ', $tf_button_font_family) : '';
    $tf_button_font_weight = get_theme_mod($prefix . 'buttons_font_weight', '');
    
    // button font size
    $tf_button_font_size = get_theme_mod($prefix . 'buttons_font_size', []);
    $tf_desktop_button_size = isset($tf_button_font_size['desktop']) && $tf_button_font_size['desktop'] != 'NaN' ? $tf_button_font_size['desktop'] : '';
    $tf_tablet_button_size = isset($tf_button_font_size['tablet']) && $tf_button_font_size['tablet'] != 'NaN' ? $tf_button_font_size['tablet'] : '';
    $tf_mobile_button_size = isset($tf_button_font_size['mobile']) && $tf_button_font_size['mobile'] != 'NaN' ? $tf_button_font_size['mobile'] : '';

    $tf_button_font_line_height = get_theme_mod($prefix . 'buttons_font_line_height', '');
    $tf_button_font_letter_space = get_theme_mod($prefix . 'buttons_font_letter_space', '');
    $tf_button_font_transform = get_theme_mod($prefix . 'buttons_font_transform', '');
    $tf_button_font_decoration = get_theme_mod($prefix . 'buttons_font_decoration', '');

    // button padding
    $tf_button_padding = get_theme_mod($prefix . 'button_primary_padding', []);
    $tf_desktop_button_padding = get_tf_padding($tf_button_padding, 'desktop');
    $tf_tablet_button_padding = get_tf_padding($tf_button_padding, 'tablet');
    $tf_mobile_button_padding = get_tf_padding($tf_button_padding, 'mobile');

    // button border
    $tf_button_border = get_theme_mod($prefix . 'button_primary_border', []);
    $tf_desktop_button_border = get_tf_border($tf_button_border, 'desktop');
    $tf_tablet_button_border = get_tf_border($tf_button_border, 'tablet');
    $tf_mobile_button_border = get_tf_border($tf_button_border, 'mobile');

    // button radius
    $tf_button_radius = get_theme_mod($prefix . 'button_primary_border_radius', []);
    $tf_desktop_button_radius = get_tf_border_radius($tf_button_radius, 'desktop');
    $tf_tablet_button_radius = get_tf_border_radius($tf_button_radius, 'tablet');
    $tf_mobile_button_radius = get_tf_border_radius($tf_button_radius, 'mobile');

    // button shadow
    $tf_button_shadow_color = get_theme_mod($prefix . 'button_primary_shadow_color', '');
    $tf_button_shadow_blur = get_theme_mod($prefix . 'button_primary_shadow_blur', '');
    $tf_button_shadow_horizontal = get_theme_mod($prefix . 'button_primary_shadow_horizontal', '');
    $tf_button_shadow_vertical = get_theme_mod($prefix . 'button_primary_shadow_vertical', '');

    // scroll back to top
    $tf_scroll_icon_size = get_theme_mod($prefix . 'scroll_to_top_size', []);
    $tf_desktop_scroll_icon_size = isset( $tf_scroll_icon_size['desktop'] ) && $tf_scroll_icon_size['desktop'] != 'NaN' ? $tf_scroll_icon_size['desktop'] : 15;
    $tf_tablet_scroll_icon_size  = isset( $tf_scroll_icon_size['tablet'] ) && $tf_scroll_icon_size['tablet'] != 'NaN' ? $tf_scroll_icon_size['tablet'] : '';
    $tf_mobile_scroll_icon_size  = isset( $tf_scroll_icon_size['mobile'] ) && $tf_scroll_icon_size['mobile'] != 'NaN' ? $tf_scroll_icon_size['mobile'] : '';

    $tf_scroll_icon_position = get_theme_mod($prefix . 'scroll_to_top_position', 'right');
    $tf_scroll_icon_display = get_theme_mod($prefix . 'scroll_to_top_display', 'both');
    $tf_scroll_icon = get_theme_mod($prefix . 'scroll_icon_color', []);
    $tf_scroll_icon_color = $tf_scroll_icon['normal'] ?? '#fff';
    $tf_scroll_icon_hover = $tf_scroll_icon['hover'] ?? '#fff';
    $tf_scroll_icon_background = get_theme_mod($prefix . 'scroll_icon_background', []);
    $tf_scroll_icon_background_color = $tf_scroll_icon_background['normal'] ?? '';
    $tf_scroll_icon_background_hover = $tf_scroll_icon_background['hover'] ?? '';

    $tf_scroll_icon_radius = get_theme_mod($prefix . 'scroll_icon_border_radius', []);
    $tf_desktop_scroll_radius = get_tf_border_radius($tf_scroll_icon_radius, 'desktop');
    $tf_tablet_scroll_radius = get_tf_border_radius($tf_scroll_icon_radius, 'tablet');
    $tf_mobile_scroll_radius = get_tf_border_radius($tf_scroll_icon_radius, 'mobile');


    /**
     * 
     * Footer settings
     * 
     */
    $tf_footer_bg = get_theme_mod($prefix . 'footer_bg_color');
    $tf_footer_heading_color = get_theme_mod($prefix . 'footer_heading_color');
    $tf_footer_text_color = get_theme_mod($prefix . 'footer_text_color');
?>


    <style>
        :root {

            --tf-logo-width: <?php echo esc_attr($tf_desktop_logo_width); ?>;

            /* Body */
            --tf-body-font-family: <?php echo !empty($tf_body_font_family) ? '"' . esc_attr($tf_body_font_family) . '"' : "'Nunito', sans-serif"; ?>;
            --tf-body-font-weight: <?php echo !empty($tf_body_font_weight) ? esc_attr($tf_body_font_weight) : '400'; ?>;
            --tf-body-font-size: <?php echo !empty($tf_desktop_body_size) ? esc_attr($tf_desktop_body_size . 'px') : '1rem'; ?>;
            --tf-body-line-height: <?php echo !empty($tf_body_font_line_height) ? esc_attr($tf_body_font_line_height) : '1.5'; ?>;
            --tf-body-letter-space: <?php echo !empty($tf_body_font_letter_space) ? esc_attr($tf_body_font_letter_space . 'px') : '0px'; ?>;
            --tf-body-text-transform: <?php echo !empty($tf_body_font_transform) ? esc_attr($tf_body_font_transform) : 'none'; ?>;
            --tf-body-font-style: <?php echo !empty($tf_body_font_style) ? esc_attr($tf_body_font_style) : 'normal'; ?>;
            --tf-body-text-decoration: <?php echo !empty($tf_body_font_decoration) ? esc_attr($tf_body_font_decoration) : 'none'; ?>;


            /* Headings */
            --tf-headings-font-family: <?php echo !empty($tf_headings_font_family) ? '"' . esc_attr($tf_headings_font_family) . '"' : "'Cormorant Garamond', sans-serif"; ?>;
           
            /* Colors */
            --tf-color-white: #ffffff;

            /* brand colors */
            --tf-primary: <?php echo esc_attr($tf_primary_color); ?> ;
            --tf-brand-dark: <?php echo esc_attr($tf_secondary_color); ?> ;
            --tf-brand-lite: <?php echo esc_attr($tf_brand_lite_color); ?> ;
           
            /* text colors */
            --tf-text-heading: <?php echo esc_attr($tf_heading_color); ?> ;
            --tf-text-paragraph: <?php echo esc_attr($tf_body_text_color); ?> ;
            --tf-text-lite: <?php echo esc_attr($tf_text_lite_color); ?> ;

            /* border colors */
            --tf-border-default: <?php echo esc_attr($tf_border_default_color); ?> ;
            --tf-border-lite: <?php echo esc_attr($tf_border_lite_color) ?> ;
            
            /* filling colors */
            --tf-filling-foreground: <?php echo esc_attr($tf_filling_foreground); ?> ;
            --tf-filling-background: <?php echo esc_attr($tf_filling_background); ?> ;

            /* accent colors */
            --tf-links-color: <?php echo esc_attr($tf_links_color) ?> ;
            --tf-box-shadow-color: <?php echo esc_attr($tf_box_shadow_color) ?> ;
        }

        /* 
         * Body font
        */
        html,
        #tft-site-main-body .site {
            font-family: var(--tf-body-font-family);
            color: var(--tf-text-paragraph);
            font-size: var(--tf-body-font-size);
            font-weight: var(--tf-body-font-weight);
            line-height: var(--tf-body-line-height);
            letter-spacing: var(--tf-body-letter-space);
            text-transform: var(--tf-body-text-transform);
            <?php if ( ! empty( $tf_body_font_decoration ) ) : ?>
                text-decoration: <?php echo esc_attr( $tf_body_font_decoration ); ?>;
            <?php endif; ?>
            <?php if ( ! empty( $tf_body_font_style ) ) : ?>
                font-style: <?php echo esc_attr( $tf_body_font_style ); ?>;
            <?php endif; ?>
        }

        <?php
      
        /* 
         * Headings font
        */
        // General heading styles (applies to all headings)

        ?>

        /* font family */
        #tft-site-main-body h1, h2, h3, h4, h5, h6 {
            font-family: var(--tf-headings-font-family);
        }

        <?php

        $tf_general_heading_styles = [];
        
        if (!empty($tf_headings_font_weight)) {
            $tf_general_heading_styles[] = "font-weight: " . esc_attr($tf_headings_font_weight) . ";";
        }
        if (!empty($tf_desktop_headings_size)) {
            $tf_general_heading_styles[] = "font-size: " . esc_attr($tf_desktop_headings_size) . "px;";
        }
        if (!empty($tf_headings_font_line_height)) {
            $tf_general_heading_styles[] = "line-height: " . esc_attr($tf_headings_font_line_height) . ";";
        }
        if (!empty($tf_headings_font_letter_space)) {
            $tf_general_heading_styles[] = "letter-spacing: " . esc_attr($tf_headings_font_letter_space) . "px;";
        }
        if (!empty($tf_headings_font_transform)) {
            $tf_general_heading_styles[] = "text-transform: " . esc_attr($tf_headings_font_transform) . ";";
        }
        if (!empty($tf_headings_font_decoration) && $tf_headings_font_decoration != 'italic') {
            $tf_general_heading_styles[] = "text-decoration: " . esc_attr($tf_headings_font_decoration) . ";";
        }elseif(!empty($tf_headings_font_decoration) && $tf_headings_font_decoration == 'italic'){
            $tf_general_heading_styles[] = "font-style: italic;";
            $tf_general_heading_styles[] = "text-decoration: none;";

        }
        if (!empty($tf_general_heading_styles)) {
            $styles = implode(" ", $tf_general_heading_styles);
            echo "
                #tft-site-main-body .site :is(h1, h1> *),
                #tft-site-main-body .site :is(h2, h2> *),
                #tft-site-main-body .site :is(h3, h3> *),
                #tft-site-main-body .site :is(h4, h4> *),
                #tft-site-main-body .site :is(h5, h5> *),
                #tft-site-main-body .site :is(h6, h6> *) {
                    $styles
                }
            ";
        }

        // Individual heading styles
        foreach ($headings as $heading) {
            $tf_heading_styles = [];
            if (!empty($tf_headings[$heading]['font_family'])) {
                $tf_heading_styles[] = 'font-family: "' . str_replace('_', ' ', esc_attr($tf_headings[$heading]['font_family'])) . '";';
            }
            if (!empty($tf_headings[$heading]['font_weight'])) {
                $tf_heading_styles[] = "font-weight: " . esc_attr($tf_headings[$heading]['font_weight']) . ";";
            }
            $font_sizes = $tf_headings[$heading]['font_size'];

            if (!empty($font_sizes['desktop']) && $font_sizes['desktop'] != 'NaN') {
                $tf_heading_styles[] = "font-size: " . esc_attr($font_sizes['desktop']) . "px;";
            }
            if (!empty($tf_headings[$heading]['font_line_height'])) {
                $tf_heading_styles[] = "line-height: " . esc_attr($tf_headings[$heading]['font_line_height']) . ";";
            }
            if (!empty($tf_headings[$heading]['font_letter_space'])) {
                $tf_heading_styles[] = "letter-spacing: " . esc_attr($tf_headings[$heading]['font_letter_space']) . "px;";
            }
            if (!empty($tf_headings[$heading]['font_transform'])) {
                $tf_heading_styles[] = "text-transform: " . esc_attr($tf_headings[$heading]['font_transform']) . ";";
            }
            if (!empty($tf_headings[$heading]['font_decoration']) && $tf_headings[$heading]['font_decoration'] != 'italic') {
                $tf_heading_styles[] = "text-decoration: " . esc_attr($tf_headings[$heading]['font_decoration']) . ";";
            }elseif(!empty($tf_headings[$heading]['font_decoration']) && $tf_headings[$heading]['font_decoration'] == 'italic'){
                $tf_heading_styles[] = "font-style: italic;";
            }
            if (!empty($tf_heading_styles)) {
                echo "#tft-site-main-body #page :is(" . $heading . ", " . $heading . ">*) { " . implode(" ", $tf_heading_styles) . " }";
            }
           
            if (!empty($font_sizes['tablet']) && $font_sizes['tablet'] != 'NaN') {
                echo "@media (max-width: 992px) { #tft-site-main-body #page :is(" . $heading . ", " . $heading . ">*) { font-size: " . esc_attr($font_sizes['tablet']) . "px; } }";
            }

            if (!empty($font_sizes['mobile']) && $font_sizes['mobile'] != 'NaN') {
                echo "@media (max-width: 600px) { #tft-site-main-body #page :is(" . $heading . ", " . $heading . ">*) { font-size: " . esc_attr($font_sizes['mobile']) . "px; } }";
            }
        }
        
        /* 
         * Container
        */

        $container_styles = '';

        if (!empty($tf_container_maxwidth)) {
            $container_styles .= 'max-width: ' . esc_attr($tf_container_maxwidth) . ';';
        }

        $has_padding = !empty(array_filter($tf_desktop_container_padding));

        if ($has_padding) {
            $top    = $tf_desktop_container_padding['top'] ?? '';
            $right  = $tf_desktop_container_padding['right'] ?? '';
            $bottom = $tf_desktop_container_padding['bottom'] ?? '';
            $left   = $tf_desktop_container_padding['left'] ?? '';

            if ($top && $right && $bottom && $left) {
                $container_styles .= 'padding: ' . esc_attr("$top $right $bottom $left") . ';';
            } else {
                if ($top) {
                    $container_styles .= 'padding-top: ' . esc_attr($top) . ';';
                }
                if ($right) {
                    $container_styles .= 'padding-right: ' . esc_attr($right) . ';';
                }
                if ($bottom) {
                    $container_styles .= 'padding-bottom: ' . esc_attr($bottom) . ';';
                }
                if ($left) {
                    $container_styles .= 'padding-left: ' . esc_attr($left) . ';';
                }
            }
        }
        if (!empty($container_styles)) : ?>
            #tft-site-main-body .tft-container,
            #tft-site-main-body .tft-fullwidth-container,
            #tft-site-main-body .tf-container {
                <?php echo esc_attr($container_styles); ?>
            }
    
        <?php endif;

        if (! empty($tf_body_text_color)): ?>
            /* 
            * Body Text Color
            */
            #tft-site-main-body p path {
                fill: <?php echo esc_attr($tf_body_text_color); ?>;
            }

            #tft-site-main-body :is(.tft-color-white, .tft-icon-text-single:hover .tft-hover-color-white, .tft-testimonials-inner:hover .tft-hover-color-white) {
                color: #ffffff;
            }

        <?php endif; if (! empty($tf_primary_color)): ?>
            /* 
            * Primary Color
            */

            /* Background  */
            #tft-site-main-body .tft-btn:not(.tft-btn-transparent),
            #tft-site-main-body :is( .tft-account a:hover, .comment-form .submit, .tft-theme-bg,  .tft-account ul li a.login:hover, .tft-footer-social-link ul li a, .tf-sidebar .wp-block-search__button, .tft-pagination .page-numbers.current, .tft-fields-subscriptions .wpcf7-submit, .tf-sidebar .wp-block-search__button, .wpcf7-form .wpcf7-submit,.tft-hero-slider-selector .slick-prev, .tft-hero-slider-selector .slick-next, .widget li.wp-social-link, .tft-team-design__two .social-media-icons .social-media, .tft-testimonials-design__three .tft-slider-arrows .tft-arrow:hover, .tft-team-design__two .slick-dots li.slick-active button, .tft-bg-hover-primary:hover, .tft-team-design__one .member-details a, button.wp-block-search__button),
            #tft-site-main-body .tft-about-image::before  {
                background: <?php echo esc_attr($tf_primary_color); ?>;
            }

            /* Color */
            #tft-site-main-body :is(.tft-heading-content .tft-section-subtitle, .tft-tour-serach-fields-wrap .tf_input-inner *, .tft-footer-contact ul li i, .tft-tour-serach-fields-wrap .tf_input-inner, .slider__counter, .tft-meta-info i, .tft-single-tour-info .important-single-info i, .tft-site-navigation ul li a:hover, .tft-header-search a:hover, .widget_nav_menu ul li a:hover, .tft-destination-details ul li a:hover, .tft-color-primary, .tft-color-hover-primary:hover, .tft-color-primary h2:hover a, .tft-color-primary i, .tft-testimonials-design__two li.slick-active button::before, .tft-popular-hotels-design__two .tft-btn,
            .tft-latest-posts-design__three .tft-read-more a, .tf-section-title h3, .tf-section-title h3, .section-title-suffix) {
                color: <?php echo esc_attr($tf_primary_color); ?>;
            }

            #tft-site-main-body .site .tft-site-navigation li.current-menu-item > a[aria-current="page"]{
                color: <?php echo esc_attr($tf_primary_color); ?>;
            }

            /* border */
            #tft-site-main-body :is(.tft-bg-hover-primary:hover, .tft-account ul li a.login, input[type=submit].tft-form-btn, .tft-team-design__two .slick-dots li.slick-active, .tft-icon-text-design__two .tft-icon-text-single:hover .icon_outter, .tft-testimonials-design__two li.slick-active) {
                border-color: <?php echo esc_attr($tf_primary_color); ?>;
            }

            /* svg */
            #tft-site-main-body :is( .tft-destination-content .tft-destination-slides .slick-arrow path, .tft-destination-slides-arrows path, .tft-tour-destination-slides-arrows path ) {
                stroke: <?php echo esc_attr($tf_primary_color); ?>;
                fill: <?php echo esc_attr($tf_primary_color); ?>;
            }
       
            #tft-site-main-body .site :is( .tft-destination-design__three .tft-heading-content .tft-btn) {
                background-color: #f2f2f2;
            }
            #tft-site-main-body .site .tft-popular-hotels-design__two .tft-destination-content .tft-btn {
                background-color: rgba(250,100,0,.1);
            }
            #tft-site-main-body .site :is(.tft-latest-posts-design__three a.tft-btn) {
                background-color: rgba(250,100,0,.09);
            }

            #tft-site-main-body .site :is(.tft-btn.tft-btn_gray){
                background-color: #99948d;
            }

        <?php endif; if (! empty($tf_secondary_color)): ?>

            /* 
            * Secondary Color
            */
            #tft-site-main-body .site :is( .tft-btn:hover, .tft-account a:hover, .comment-form .submit:hover, button.wp-block-search__button:hover, input[type=submit].tft-form-btn:hover, .wpcf7-form .wpcf7-submit:hover) {
                background: <?php echo esc_attr($tf_secondary_color); ?>;
            }
            #tft-site-main-body :is(input[type=submit].tft-form-btn:hover, .wpcf7-form .wpcf7-submit:hover) {
                border-color: <?php echo esc_attr($tf_secondary_color); ?>;
            }

            #tft-site-main-body :is( .tft-popular-hotels-design__two .tft-btn:hover, .tft-latest-posts-design__three .tft-read-more a:hover, .tft-destination-design__three .tft-btn:hover ) {
                color: #ffffff;
            }

        <?php endif; if (!empty($tf_heading_color)): ?>
            #tft-site-main-body :is(.tft-content-box :is(h1, h2, h3, h4, h5, h6), .tft-icon-text-design__one .tft-icon-text-single:hover h3) {
                color: #ffffff;
            }
        <?php endif; ?>


        /* Header Menu */
        <?php if(!empty($tf_header_menu_color)): ?>
             #tft-site-main-body header :is(.main--header-menu > li > a, .tft-site-navigation > ul > li a, a i, .logo-text a){
                color: <?php echo esc_attr($tf_header_menu_color); ?>;
            }
        <?php endif; ?>

        /* Header Menu Hover */
        <?php if(!empty($tf_header_menu_hover_color)): ?>
            #tft-site-main-body header :is(.main--header-menu > li > a:hover, .logo-text a:hover){
                color: <?php echo esc_attr($tf_header_menu_hover_color); ?>;
            }
        <?php endif; ?>

        /* Header Submenu */
        <?php if(!empty($tf_header_submenu_color)): ?>
            #tft-site-main-body header .tft-site-navigation :is(ul.sub-menu, ul.children) > li > a,
             #tft-site-main-body header .tft-site-navigation :is(ul.sub-menu, ul.children) > li > a::after {
                color: <?php echo !empty($tf_header_submenu_color) ? esc_attr($tf_header_submenu_color) : ''; ?>;
            }
        <?php endif; ?>

         /* Header Submenu Hover */
        <?php if(!empty($tf_header_submenu_hover_color)): ?>
            #tft-site-main-body header .tft-site-navigation :is(ul.sub-menu, ul.children)>li:hover>a,
            #tft-site-main-body header .tft-site-navigation :is(ul.sub-menu, ul.children)>li:hover>a::after
            {
                color: <?php echo !empty($tf_header_submenu_hover_color) ? esc_attr($tf_header_submenu_hover_color) : ''; ?>;
            }
        <?php endif;?>

       
        /* Sticky Header */
        <?php if(!empty($tf_sticky_bg_color) || !empty($tf_sticky_bg_blur) || !empty($tf_sticky_bg_opacity)): ?>
            #tft-site-main-body .tft_has_sticky.tft-navbar-shrink .tft-menus-section,
            #tft-site-main-body header.tft_has_sticky.tf-navbar-shrink,
            #tft-site-main-body header.tft_has_sticky.tf-navbar-shrink .tft-header-desktop  {
                <?php if(!empty($tf_sticky_bg_color)): ?>
                    background-color: <?php echo esc_attr($tf_sticky_bg_color); ?>!important;
                <?php endif; ?>
                <?php if(!empty($tf_sticky_bg_blur)): ?>
                    backdrop-filter: blur(<?php echo esc_attr($tf_sticky_bg_blur) . 'px'; ?>);
                <?php endif; ?>
                <?php if(!empty($tf_sticky_bg_opacity)): ?>
                    opacity: <?php echo !empty($tf_sticky_bg_opacity) ? esc_attr($tf_sticky_bg_opacity) : '1'; ?>;
                <?php endif; ?>
            }
        <?php endif; 
        /* Sticky Header Padding */

        if (!empty(array_filter($tf_desktop_sticky_padding))) :
            echo '#tft-site-main-body .tft_has_sticky.tf-navbar-shrink :is(.tft-main-header-wrapper, .tft-menus-section, .tft-header-design__three__bottom) {';
            if (!empty($tf_desktop_sticky_padding['top']) && !empty($tf_desktop_sticky_padding['right']) && !empty($tf_desktop_sticky_padding['bottom']) && !empty($tf_desktop_sticky_padding['left']) ) {
                echo 'padding: ' . esc_attr("{$tf_desktop_sticky_padding['top']} {$tf_desktop_sticky_padding['right']} {$tf_desktop_sticky_padding['bottom']} {$tf_desktop_sticky_padding['left']}") . ';';
            } else {
                if (!empty($tf_desktop_sticky_padding['top'])) {
                    echo 'padding-top: ' . esc_attr($tf_desktop_sticky_padding['top']) . ';';
                }
                if (!empty($tf_desktop_sticky_padding['right'])) {
                    echo 'padding-right: ' . esc_attr($tf_desktop_sticky_padding['right']) . ';';
                }
                if (!empty($tf_desktop_sticky_padding['bottom'])) {
                    echo 'padding-bottom: ' . esc_attr($tf_desktop_sticky_padding['bottom']) . ';';
                }
                if (!empty($tf_desktop_sticky_padding['left'])) {
                    echo 'padding-left: ' . esc_attr($tf_desktop_sticky_padding['left']) . ';';
                }
            }
            echo '}';
        endif;
         

        /* sticky menu color */
        if(!empty($tf_sticky_menu_color)): ?>
            #tft-site-main-body .tft_has_sticky.tf-navbar-shrink :is(.main--header-menu > li > a, .tft-site-navigation > ul > li a, a i, .logo-text a),
            #tft-site-main-body .tft_has_sticky.tf-navbar-shrink .tft-site-navigation ul > li > a:after, 
            #tft-site-main-body .tft_has_sticky.tf-navbar-shrink .menu-item-has-children > a:after {
                color: <?php echo !empty($tf_sticky_menu_color) ? esc_attr($tf_sticky_menu_color) : ''; ?>;
            }
        <?php endif; ?>
        /* sticky menu hover */
        <?php if(!empty($tf_sticky_color_hover)): ?>
            #tft-site-main-body .tft_has_sticky.tf-navbar-shrink :is(.main--header-menu > li > a:hover, .tft-site-navigation > ul > li a:hover, a i:hover, .logo-text a:hover),
            #tft-site-main-body .tft_has_sticky.tf-navbar-shrink .tft-site-navigation ul > li > a:hover:after, 
            #tft-site-main-body .tft_has_sticky.tf-navbar-shrink .menu-item-has-children > a:hover:after {
                color: <?php echo !empty($tf_sticky_color_hover) ? esc_attr($tf_sticky_color_hover) : ''; ?>;
            }
        <?php endif; ?>

        /* footer background */
        <?php if(!empty($tf_footer_bg)): ?>
            #tft-site-main-body footer.tft-site-footer {
                background-color: <?php echo !empty($tf_footer_bg) ? esc_attr($tf_footer_bg) : ''; ?>;
            }
        <?php endif; ?>

        /* footer heading color */
        <?php if(!empty($tf_footer_heading_color)): ?>
            #tft-site-main-body footer.tft-site-footer :is(h2, h3, h4, h5, h6) {
                color: <?php echo !empty($tf_footer_heading_color) ? esc_attr($tf_footer_heading_color) : ''; ?>;
            }
        <?php endif; ?>

        /* footer text color */
        <?php if (!empty($tf_footer_text_color)): ?>
            #tft-site-main-body footer.tft-site-footer :is(p, ul li, ul li a, a, table caption, table tr th, table tr td, .wpcf7-response-output, .wpcf7-not-valid-tip) {
                color: <?php echo !empty($tf_footer_text_color) ? esc_attr($tf_footer_text_color) : ''; ?>;
            }
            #tft-site-main-body footer.tft-site-footer :is(.tft-copyright-inner), #tft-site-main-body footer table :is(th, td) {
                border-color: <?php echo !empty($tf_footer_text_color) ? esc_attr($tf_footer_text_color) : ''; ?>;
            }
             #tft-site-main-body footer.tft-site-footer a:hover{
                color: <?php echo $tf_primary_color; ?>;
             }
        <?php endif; ?>

        /* scroll to top */
        #tft-site-main-body .tft-scroll-to-top {
            <?php echo ($tf_scroll_icon_position == 'left') ? 'left: 30px; right: auto;' : 'right: 30px; left: auto;'; ?>
        }

        <?php if ($tf_scroll_icon_display == 'desktop') {
            echo '#tft-site-main-body .tft-scroll-to-top-wrap { display: block; }';
            echo '@media (max-width: 600px) { #tft-site-main-body .tft-scroll-to-top-wrap { display: none; } }';
        } elseif ($tf_scroll_icon_display == 'mobile') {
            echo '#tft-site-main-body .tft-scroll-to-top-wrap { display: none; }';
            echo '@media (max-width: 600px) { #tft-site-main-body .tft-scroll-to-top-wrap { display: block; } }';
        } ?>

         /* 
         * Button
        */
        <?php
        $tf_button_styles = [];

        // Font styles
        if (!empty($tf_button_font_family)) {
           $tf_button_styles[] = 'font-family: "' . esc_attr($tf_button_font_family) . '";';
        }
        if (!empty($tf_button_font_weight)) {
            $tf_button_styles[] = "font-weight: " . esc_attr($tf_button_font_weight) . ";";
        }
        if (!empty($tf_desktop_button_size)) {
            $tf_button_styles[] = "font-size: " . esc_attr($tf_desktop_button_size) . "px;";
        }
        if (!empty($tf_button_font_line_height)) {
            $tf_button_styles[] = "line-height: " . esc_attr($tf_button_font_line_height) . ";";
        }
        if (!empty($tf_button_font_letter_space)) {
            $tf_button_styles[] = "letter-spacing: " . esc_attr($tf_button_font_letter_space) . "px;";
        }
        if (!empty($tf_button_font_transform)) {
            $tf_button_styles[] = "text-transform: " . esc_attr($tf_button_font_transform) . ";";
        }
        if (!empty($tf_button_font_decoration) && $tf_button_font_decoration != 'italic') {
            $tf_button_styles[] = "text-decoration: " . esc_attr($tf_button_font_decoration) . ";";
        }elseif(!empty($tf_button_font_decoration) && $tf_button_font_decoration == 'italic'){
            $tf_button_styles[] = "font-style: italic;";
        }

        // Background, text, and border colors
        if (!empty($tf_button_bg_color)) {
            $tf_button_styles[] = "background-color: " . esc_attr($tf_button_bg_color) . ";";
        }
        if (!empty($tf_button_text_color)) {
            $tf_button_styles[] = "color: " . esc_attr($tf_button_text_color) . ";";
        }
        if (!empty($tf_button_border_color)) {
            $tf_button_styles[] = "border-color: " . esc_attr($tf_button_border_color) . ";";
        }
        
        // Padding
        if (!empty(array_filter($tf_desktop_button_padding))) {
            if (!empty($tf_desktop_button_padding['top']) && !empty($tf_desktop_button_padding['right']) && !empty($tf_desktop_button_padding['bottom']) && !empty($tf_desktop_button_padding['left'])) {
                $tf_button_styles[] = "padding: " . esc_attr("{$tf_desktop_button_padding['top']} {$tf_desktop_button_padding['right']} {$tf_desktop_button_padding['bottom']} {$tf_desktop_button_padding['left']}") . ";";
            } else {
                if (!empty($tf_desktop_button_padding['top'])) {
                    $tf_button_styles[] = "padding-top: " . esc_attr($tf_desktop_button_padding['top']) . ";";
                }
                if (!empty($tf_desktop_button_padding['right'])) {
                    $tf_button_styles[] = "padding-right: " . esc_attr($tf_desktop_button_padding['right']) . ";";
                }
                if (!empty($tf_desktop_button_padding['bottom'])) {
                    $tf_button_styles[] = "padding-bottom: " . esc_attr($tf_desktop_button_padding['bottom']) . ";";
                }
                if (!empty($tf_desktop_button_padding['left'])) {
                    $tf_button_styles[] = "padding-left: " . esc_attr($tf_desktop_button_padding['left']) . ";";
                }
            }
        }
       
        // Border width
        if (!empty(array_filter($tf_desktop_button_border))) {
            if (!empty($tf_desktop_button_border['top']) && !empty($tf_desktop_button_border['right']) && !empty($tf_desktop_button_border['bottom']) && !empty($tf_desktop_button_border['left'])) {
                $tf_button_styles[] = "border-width: " . esc_attr("{$tf_desktop_button_border['top']} {$tf_desktop_button_border['right']} {$tf_desktop_button_border['bottom']} {$tf_desktop_button_border['left']}") . ";";
            } else {
                 if (!empty($tf_desktop_button_border['top'])) {
                    $tf_button_styles[] = "border-top-width: " . esc_attr($tf_desktop_button_border['top']) . ";";
                }
                if (!empty($tf_desktop_button_border['right'])) {
                    $tf_button_styles[] = "border-right-width: " . esc_attr($tf_desktop_button_border['right']) . ";";
                }
                if (!empty($tf_desktop_button_border['bottom'])) {
                    $tf_button_styles[] = "border-bottom-width: " . esc_attr($tf_desktop_button_border['bottom']) . ";";
                }
                if (!empty($tf_desktop_button_border['left'])) {
                    $tf_button_styles[] = "border-left-width: " . esc_attr($tf_desktop_button_border['left']) . ";";
                }
            }

            $tf_button_styles[] = "border-style: solid;";
        }


        // Border radius
         if (!empty(array_filter($tf_desktop_button_radius))) {
            if (!empty($tf_desktop_button_radius['top']) && !empty($tf_desktop_button_radius['right']) && !empty($tf_desktop_button_radius['bottom']) && !empty($tf_desktop_button_radius['left'])) {
                $tf_button_styles[] = "border-radius: " . esc_attr("{$tf_desktop_button_radius['top']} {$tf_desktop_button_radius['right']} {$tf_desktop_button_radius['bottom']} {$tf_desktop_button_radius['left']}") . ";";
            } else {
                if (!empty($tf_desktop_button_radius['top'])) {
                    $tf_button_styles[] = "border-top-left-radius: " . esc_attr($tf_desktop_button_radius['top']) . ";";
                }
                if (!empty($tf_desktop_button_radius['right'])) {
                    $tf_button_styles[] = "border-top-right-radius: " . esc_attr($tf_desktop_button_radius['right']) . ";";
                }
                if (!empty($tf_desktop_button_radius['bottom'])) {
                    $tf_button_styles[] = "border-bottom-right-radius: " . esc_attr($tf_desktop_button_radius['bottom']) . ";";
                }
                if (!empty($tf_desktop_button_radius['left'])) {
                    $tf_button_styles[] = "border-bottom-left-radius: " . esc_attr($tf_desktop_button_radius['left']) . ";";
                }
            }
        }
         
        // Box shadow
        $box_shadow_values = array_filter([
            !empty($tf_button_shadow_horizontal) ? esc_attr($tf_button_shadow_horizontal) . "px" : null,
            !empty($tf_button_shadow_vertical) ? esc_attr($tf_button_shadow_vertical) . "px" : null,
            !empty($tf_button_shadow_blur) ? esc_attr($tf_button_shadow_blur) . "px" : null,
            !empty($tf_button_shadow_color) ? esc_attr($tf_button_shadow_color) : null,
        ]);
        if (!empty($box_shadow_values)) {
            $tf_button_styles[] = "box-shadow: " . implode(" ", $box_shadow_values) . ";";
        }


        // Output CSS only if styles exist
        if (!empty($tf_button_styles)) {
            $new_button_styles = array_filter($tf_button_styles, function($style) {
                return !preg_match('/:\s*px(?:\s|;|$)/', $style);
            });
            echo "#tft-site-main-body .site :is(.tf_btn, .tft-btn, .comment-form .submit, .wpcf7-form .wpcf7-submit, .tft-popular-hotels-design__two .tft-desination-btn .tft-btn, .tft-latest-posts-design__three .tft-read-more a, .wp-element-button, .tft-account a) { " . implode(" ", $new_button_styles) . " }";
        }
        

        $tf_btn_has_background = array_filter($tf_button_styles, function($style) {
            return stripos($style, 'background-color') !== false;
        });

        if (!empty($tf_btn_has_background) && empty($tf_primary_color) && ($tf_button_preset !== 'set-4' || $tf_button_preset !== 'set-5' || $tf_button_preset !== 'set-6')) {
            echo "#tft-site-main-body #page .tft-popular-hotels-design__two .tft-btn{ background-color: rgba(250,100,0,.1); }";
            echo "#tft-site-main-body #page .tft-latest-posts-design__three .tft-read-more a{ background-color: rgba(250,100,0,.1); }";
            echo "#tft-site-main-body #page .tft-destination-design__three .tft-btn{ background-color: rgba(250,100,0,.1); }";
        }

        ?>
     
        <?php if (!empty($tf_button_bg_hover_color) || !empty($tf_button_text_hover_color) || !empty($tf_button_border_hover_color)): ?>
            #tft-site-main-body #page :is(.tft-btn:hover, .tf_btn:hover, .tft-account a:hover, .comment-form .submit:hover, .wpcf7-form .wpcf7-submit:hover, button.wp-block-search__button:hover, .wp-element-button:hover) {
                <?php if (!empty($tf_button_bg_hover_color)): ?>
                    background-color: <?php echo esc_attr($tf_button_bg_hover_color); ?>;
                <?php endif; ?>
                <?php if (!empty($tf_button_text_hover_color)): ?>
                    color: <?php echo esc_attr($tf_button_text_hover_color); ?>;
                <?php endif; ?>
                <?php if (!empty($tf_button_border_hover_color)): ?>
                    border-color: <?php echo esc_attr($tf_button_border_hover_color); ?>;
                <?php endif; ?>
            }
        <?php endif; ?>

        <?php if(!empty($tf_button_text_hover_color)): ?>
            #tft-site-main-body #page :is( .tft-btn:hover svg path, .tf_btn:hover svg path) {
                fill: <?php echo esc_attr($tf_button_text_hover_color); ?>;
            }
        <?php endif; ?>

        /* button set button background transparent */
        #tft-site-main-body:is(.button-set-4, .button-set-5, .button-set-6) :is(.tft-btn, .tf_btn, .tft-account a, .comment-form .submit, .wpcf7-form input.wpcf7-submit.tft-btn, button.wp-block-search__button, .wp-element-button) {
            background-color: transparent;
        }

        <?php if(!empty($tf_button_text_color)): ?>
        /* button svg path color */
            body#tft-site-main-body :is(.tft-btn path, .tf_btn path) {
                fill: <?php echo esc_attr($tf_button_text_color); ?>;
            }
        <?php endif; ?>
        
        /* button set button hover background */
        <?php if(!empty($tf_button_bg_hover_color)): ?>
            #tft-site-main-body:is(.button-set-4, .button-set-5, .button-set-6) :is(.tft-btn:hover, .tf_btn:hover, .tft-account a:hover, .comment-form .submit, .wp-element-button:hover) {
                background-color: <?php echo esc_attr($tf_button_bg_hover_color); ?>;
            }    
        <?php endif; ?>

        <?php if(!empty(array_filter($tf_desktop_button_border))): ?>
            #tft-site-main-body #page :is(.tft-btn.tft-large-circle) {
                border-radius: 50%;
            }
        <?php endif; ?>

        <?php if(empty(array_filter($tf_desktop_button_border)) && ($tf_button_preset === 'set-1' || $tf_button_preset === 'set-2' || $tf_button_preset === 'set-3')): ?>
            #tft-site-main-body .site :is( .tft-btn, .tf_btn, .comment-form .submit, .wpcf7-form .wpcf7-submit, .tft-popular-hotels-design__two .tft-desination-btn .tft-btn, .tft-latest-posts-design__three .tft-read-more a, .wp-element-button) {
                border: 0;
            }
        <?php endif;?> 
        <?php if(empty(array_filter($tf_desktop_button_border)) && ($tf_button_preset === 'set-4' || $tf_button_preset === 'set-5' || $tf_button_preset === 'set-6')): ?>
            #tft-site-main-body .site :is( .tft-btn, .tf_btn, .tft-account a, .comment-form .submit, .wpcf7-form .wpcf7-submit, .tft-popular-hotels-design__two .tft-desination-btn .tft-btn, .tft-latest-posts-design__three .tft-read-more a, .wp-element-button) {
                border: 1px solid;
            }
        <?php endif;?> 
        
        <?php 
        if(empty(array_filter($tf_desktop_button_radius)) && ($tf_button_preset === 'set-1' || $tf_button_preset === 'set-4')): ?>
            #tft-site-main-body .site :is( .tft-btn, .tf_btn, .tft-account a, .comment-form .submit, .wpcf7-form .wpcf7-submit, .tft-popular-hotels-design__two .tft-desination-btn .tft-btn, .tft-latest-posts-design__three .tft-read-more a, .wp-element-button) {
                border-radius: 0;
            }
        <?php endif; ?>

        <?php if(empty(array_filter($tf_desktop_button_radius)) && ($tf_button_preset === 'set-3' || $tf_button_preset === 'set-6')): ?>
            #tft-site-main-body .site :is( .tft-btn, .tf_btn, .tft-account a, .comment-form .submit, .wpcf7-form .wpcf7-submit, .tft-popular-hotels-design__two .tft-desination-btn .tft-btn, .tft-latest-posts-design__three .tft-read-more a, .wp-element-button) {
                border-radius: 100px;
            }
        <?php endif; 

        if(empty(array_filter($tf_desktop_button_radius)) && ($tf_button_preset === 'set-2' || $tf_button_preset === 'set-5')): ?>
            #tft-site-main-body .site :is( .tft-btn, .tf_btn, .tft-account a, .comment-form .submit, .wpcf7-form .wpcf7-submit, .tft-popular-hotels-design__two .tft-desination-btn .tft-btn, .tft-latest-posts-design__three .tft-read-more a, .wp-element-button) {
                border-radius: 3px;
            }
        <?php endif;
        if (!empty($tf_desktop_scroll_icon_size) || !empty($tf_scroll_icon_color) || !empty($tf_scroll_icon_background_color) || !empty($tf_scroll_icon_hover) || !empty($tf_scroll_icon_background_hover) || !empty($tf_scroll_icon_border) || !empty(array_filter($tf_desktop_scroll_radius))): ?>
            #tft-site-main-body .tft-scroll-to-top {
                <?php if (!empty($tf_desktop_scroll_icon_size)): ?>
                    font-size: <?php echo esc_attr($tf_desktop_scroll_icon_size); ?>px;
                <?php endif; ?>

                <?php if (!empty($tf_scroll_icon_color)): ?>
                    color: <?php echo esc_attr($tf_scroll_icon_color); ?>;
                <?php endif; ?>

                <?php if (!empty($tf_scroll_icon_background_color)): ?>
                    background-color: <?php echo esc_attr($tf_scroll_icon_background_color); ?>;
                <?php endif; ?>

                <?php
                $radius = $tf_desktop_scroll_radius;
                if (!empty(array_filter($radius))) {
                    if (!empty($radius['top']) && !empty($radius['right']) && !empty($radius['bottom']) && !empty($radius['left']) ) {
                        echo 'border-radius: ' . esc_attr("{$radius['top']} {$radius['right']} {$radius['bottom']} {$radius['left']}") . ';';
                    } else {
                        if(!empty($radius['top'])) {
                            echo 'border-top-left-radius: ' . esc_attr($radius['top']) . ';';
                        }
                        if(!empty($radius['right'])) {
                            echo 'border-top-right-radius: ' . esc_attr($radius['right']) . ';';
                        }
                        if(!empty($radius['bottom'])) {
                            echo 'border-bottom-right-radius: ' . esc_attr($radius['bottom']) . ';';
                        }
                        if(!empty($radius['left'])) {
                            echo 'border-bottom-left-radius: ' . esc_attr($radius['left']) . ';';
                        }
                    }
                }
                ?>
            }

            <?php if (!empty($tf_scroll_icon_hover) || !empty($tf_scroll_icon_background_hover)): ?>
            #tft-site-main-body .tft-scroll-to-top:hover {
                <?php if (!empty($tf_scroll_icon_hover)): ?>
                    color: <?php echo esc_attr($tf_scroll_icon_hover); ?>;
                <?php endif; ?>
                <?php if (!empty($tf_scroll_icon_background_hover)): ?>
                    background-color: <?php echo esc_attr($tf_scroll_icon_background_hover); ?>;
                <?php endif; ?>
            }
            <?php endif; ?>
        <?php endif; 

        if ( !is_plugin_active( 'travelfic-toolkit/travelfic-toolkit.php' ) ) :
            // mobile header
            if(!empty($travelfic_mobile_menu_color)): ?>
                @media screen and (max-width: 991px) {
                    #tft-site-main-body header :is(.main--header-menu > li > a, .tft-site-navigation > ul > li button.toggle, .tft-site-navigation > ul > li a),
                    #tft-site-main-body .tft-site-navigation ul > li > a,
                    #tft-site-main-body .menu-item-has-children > a:after,
                    #tft-site-main-body .page_item_has_children > a:after{
                        color: <?php echo esc_attr($travelfic_mobile_menu_color); ?>;
                    }
                    #tft-site-main-body ul li a path{
                        fill: <?php echo esc_attr($travelfic_mobile_menu_color); ?>;
                    }
                }
                    
            <?php endif;

            if(!empty($travelfic_mobile_submenu_color)): ?>
                #tft-site-main-body ul.sub-menu > li > a,
                #tft-site-main-body header .tft-site-navigation ul li > ul.sub-menu li a,
                #tft-site-main-body .tft_has_transparent .tft-site-navigation ul.sub-menu li a {
                    color: <?php echo esc_attr($travelfic_mobile_submenu_color); ?>;
                }
                    
            <?php endif;
        endif;

        /**
         * 
         * Customizer responsive styles
         * 
        */

        // Selectors
        $tf_logo_selector = '#tft-site-main-body .tft-brand-logo img';
        $tf_body_selector = 'html, #tft-site-main-body .site';
        $tf_headings_selector = '#tft-site-main-body .site :is(h1, h1 >*),
                #tft-site-main-body .site :is(h2, h2 >*),
                #tft-site-main-body .site :is(h3, h3 >*),
                #tft-site-main-body .site :is(h4, h4 >*),
                #tft-site-main-body .site :is(h5, h5 >*),
                #tft-site-main-body .site :is(h6, h6 >*)';
        $tf_container_selector = '#tft-site-main-body .tft-container, #tft-site-main-body .tft-fullwidth-container, #tft-site-main-body .tf-container';
        $tf_button_selector = '#tft-site-main-body .site :is(.tf_btn, .tft-btn, .comment-form .submit, .wpcf7-form .wpcf7-submit, .tft-popular-hotels-design__two .tft-desination-btn .tft-btn, .tft-latest-posts-design__three .tft-read-more a, .wp-element-button, .tft-account a)';
        $tf_scroll_icon_selector = '#tft-site-main-body .tft-scroll-to-top';
        $tf_sticky_selector = ' #tft-site-main-body .tft_has_sticky.tf-navbar-shrink :is(.tft-main-header-wrapper, .tft-menus-section, .tft-header-design__three__bottom)';
        
        // logo responsive styles
        $logo_tablet_styles = tf_tablet_responsive_styles([], [], [], '', $tf_tablet_logo_width ?? '');
        $logo_mobile_styles = tf_mobile_responsive_styles([], [], [], '', $tf_mobile_logo_width ?? '');

        // body responsive styles
        $body_tablet_styles = tf_tablet_responsive_styles([], [], [], $tf_tablet_body_size ?? '');
        $body_mobile_styles = tf_mobile_responsive_styles([], [], [], $tf_mobile_body_size ?? '');

        // headings responsive styles
        $headings_tablet_styles = tf_tablet_responsive_styles([], [], [], $tf_tablet_headings_size ?? '');
        $headings_mobile_styles = tf_mobile_responsive_styles([], [], [], $tf_mobile_headings_size ?? '');
        
        // button responsive styles
        $button_tablet_styles = tf_tablet_responsive_styles( $tf_tablet_button_padding ?? [], $tf_tablet_button_border ?? [], $tf_tablet_button_radius ?? [], $tf_tablet_button_size ?? '');
        $button_mobile_styles = tf_mobile_responsive_styles( $tf_mobile_button_padding ?? [], $tf_mobile_button_border ?? [], $tf_mobile_button_radius ?? [], $tf_mobile_button_size ?? '');
             
        // container responsive styles
        $container_tablet_styles = tf_tablet_responsive_styles($tf_tablet_container_padding ?? [], [], [], '', $tf_tablet_container_width ?? '' );
        $container_mobile_styles = tf_mobile_responsive_styles($tf_mobile_container_padding ?? [], [], [], '', $tf_mobile_container_width ?? '' );
       
        // scroll icon responsive styles
        $scroll_icon_tablet_styles = tf_tablet_responsive_styles([], [], $tf_tablet_scroll_radius ?? [], $tf_tablet_scroll_icon_size ?? '');
        $scroll_icon_mobile_styles = tf_mobile_responsive_styles([], [], $tf_mobile_scroll_radius ?? [], $tf_mobile_scroll_icon_size ?? '' );
         
        // sticky responsive styles
        $sticky_tablet_styles = tf_tablet_responsive_styles($tf_tablet_sticky_padding ?? [], [], [], '', '');
        $sticky_mobile_styles = tf_mobile_responsive_styles($tf_mobile_sticky_padding ?? [], [], [], '', '');
       
        // logo tablet & mobile styles
        if($logo_tablet_styles){
            echo "@media only screen and (max-width: 992px) {
                {$tf_logo_selector} {
                    {$logo_tablet_styles}
                }
            }";
        }
        if($logo_mobile_styles){
            echo "@media only screen and (max-width: 600px) {
                {$tf_logo_selector} {
                    {$logo_mobile_styles}
                }
            }";
        }

        // body tablet & mobile styles
        if($body_tablet_styles){
            echo "@media only screen and (max-width: 992px) {
                {$tf_body_selector} {
                    {$body_tablet_styles}
                }
            }";
        }
        if($body_mobile_styles){
            echo "@media only screen and (max-width: 600px) {
                {$tf_body_selector} {
                    {$body_mobile_styles}
                }
            }";
        }

        // headings tablet & mobile styles
        if($headings_tablet_styles){
            echo "@media only screen and (max-width: 992px) {
                {$tf_headings_selector} {
                    {$headings_tablet_styles}
                }
            }";
        }
        if($headings_mobile_styles){
            echo "@media only screen and (max-width: 600px) {
                {$tf_headings_selector} {
                    {$headings_mobile_styles}
                }
            }";
        }

        // container tablet & mobile styles
        if($container_tablet_styles){
            echo "@media only screen and (max-width: 992px) {
                {$tf_container_selector} {
                    {$container_tablet_styles}
                }
            }";
        }
        if($container_mobile_styles){
            echo "@media only screen and (max-width: 600px) {
                {$tf_container_selector} {
                    {$container_mobile_styles}
                }
            }";
        }
   
        // button tablet & mobile styles
        if($button_tablet_styles){
            echo "@media only screen and (max-width: 992px) {
                {$tf_button_selector} {
                    {$button_tablet_styles}
                }
            }";
        }
        if($button_mobile_styles){
            echo "@media only screen and (max-width: 600px) {
                {$tf_button_selector} {
                    {$button_mobile_styles}
                }
            }";
        }

        // scroll icon tablet & mobile styles
        if($scroll_icon_tablet_styles){
            echo "@media only screen and (max-width: 992px) {
                {$tf_scroll_icon_selector} {
                    {$scroll_icon_tablet_styles}
                }
            }";
        }
        if($scroll_icon_mobile_styles){
            echo "@media only screen and (max-width: 600px) {
                {$tf_scroll_icon_selector} {
                    {$scroll_icon_mobile_styles}
                }
            }";
        }

        // sticky tablet & mobile styles
        if($sticky_tablet_styles){
            echo "@media only screen and (max-width: 992px) {
                {$tf_sticky_selector} {
                    {$sticky_tablet_styles}
                }
            }";
        }
        if($sticky_mobile_styles){
            echo "@media only screen and (max-width: 600px) {
                {$tf_sticky_selector} {
                    {$sticky_mobile_styles}
                }
            }";
        }

        ?>
    </style>

<?php
}
add_action('wp_head', 'travelfic_customizer_style');

