<?php

/**
 * travelfic functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package travelfic
 * @since 1.0.0
 */

if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

if (! defined('TRAVELFIC_VERSION')) {
	define( 'TRAVELFIC_VERSION', '1.3.1' );
}

/**
 * Theme Required Files
 * -----------------------------------------------------------------------------
 * This file includes all the necessary PHP files to set up and run the Travelfic theme.
 * Each file is modularized based on its function.
*/

// Theme setup and basic supports
require get_template_directory() . '/inc/travelfic-theme-setup.php'; // Theme setup functions (menus, supports, etc.)

// Widgets registration and custom widgets
require get_template_directory() . '/inc/theme-widgets/travelfic-widgets.php'; // Register theme widget areas
require get_template_directory() . '/inc/theme-widgets/widgets/travelfic-footer-info.php'; // Custom footer info widget
require get_template_directory() . '/inc/theme-widgets/widgets/travelfic-recent-posts.php'; // Custom recent posts widget

// Fonts and styles
require get_template_directory() . '/inc/wptt-webfont-loader.php'; // Webfont loader
require get_template_directory() . '/inc/travelfic-fonts-functions.php'; // Theme-specific font functions
require get_template_directory() . '/inc/kirki/kirki.php'; // Kirki customizer framework

// Scripts and styles enqueue
require get_template_directory() . '/inc/travelfic-enqueue.php'; // Load JS and CSS assets

// Customizer settings and controls
require get_template_directory() . '/inc/customizer/customizer.php'; // Theme customizer controls
require get_template_directory() . '/inc/customizer/customizer-apply.php'; // Apply customizer settings to front-end

// Customizer Migrator
require get_template_directory() . '/inc/customizer/customizer-migrator.php'; // Migrate customizer settings

// Custom functions and helpers
require get_template_directory() . '/inc/template-tags.php'; // Custom template tags
require get_template_directory() . '/inc/template-functions.php'; // Theme helper functions
require get_template_directory() . '/inc/template-notice.php'; // Admin dashboard notices
require get_template_directory() . '/inc/travelfic-functions.php'; // Additional theme functions

// Header and Footer templates
require get_template_directory() . '/inc/travelfic-header.php'; // Custom header markup
require get_template_directory() . '/inc/travelfic-footer.php'; // Custom footer markup

// Menus and Walkers
require get_template_directory() . '/inc/class-travelfic-walker-menu.php'; // Custom walker class for navigation menus

// Meta Boxes
require get_template_directory() . '/inc/meta-boxes/travelfic-meta-boxes.php'; // Custom meta boxes for pages

// TGM Plugin Activation
require get_template_directory() . '/inc/tgm/tgm-init.php'; // Recommend/require plugins via TGM

// Jetpack Compatibility
if (defined('JETPACK__VERSION')) {
    require get_template_directory() . '/inc/jetpack.php'; // Jetpack compatibility file
}

