<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * After setup theme hook
 */
function traveldeck_theme_setup(){
    /*
     * Make chile theme available for translation.
     * Translations can be filed in the /languages/ directory.
     */
    load_child_theme_textdomain( 'traveldeck', get_stylesheet_directory() . '/languages' );

}
add_action( 'after_setup_theme', 'traveldeck_theme_setup' );

function traveldeck_styles() {
    $my_theme = wp_get_theme();
    $version  = $my_theme['Version'];

    if( vilva_is_woocommerce_activated() ){
        $dependencies = array( 'vilva-woocommerce', 'owl-carousel', 'vilva-google-fonts' );
    }else{
        $dependencies = array( 'owl-carousel', 'vilva-google-fonts' );
    }
  
    wp_enqueue_style( 'vilva', get_template_directory_uri() . '/style.css', $dependencies );
    wp_enqueue_style('traveldeck', get_stylesheet_directory_uri() . '/style.css', array('vilva'), $version);
    
	wp_enqueue_script( 'traveldeck', get_stylesheet_directory_uri() . '/js/custom.js', array( 'jquery', 'owl-carousel' ), $version, true );
    
}
add_action( 'wp_enqueue_scripts', 'traveldeck_styles' );

function traveldeck_customize_register( $wp_customize ) {

    /** Move Background Image section to appearance panel */
    $wp_customize->get_section('colors')->panel              = 'appearance_settings';
    $wp_customize->get_section('colors')->priority           = 10;
    $wp_customize->get_section('background_image')->panel    = 'appearance_settings';
    $wp_customize->get_section('background_image')->priority = 15;

    /** Change defaults of color and typography */
    $wp_customize->get_setting('primary_color')->default  = '#ef746a';
    $wp_customize->get_setting('primary_font')->default   = 'Sen';
    $wp_customize->get_setting('secondary_font')->default = 'Cardo';
    $wp_customize->get_setting('font_size')->default      = 17;

    $wp_customize->get_section( 'general_layout_settings' )->panel = 'layout_settings';
    $wp_customize->get_section( 'general_layout_settings' )->title = __('General Sidebar Layout', 'traveldeck');

    $wp_customize->add_panel(
        'layout_settings',
        array(
            'priority'   => 45,
            'capability' => 'edit_theme_options',
            'title'      => __( 'Layout Settings', 'traveldeck' ),
        )
    );

    /** Header Layout */
    $wp_customize->add_section(
        'header_layout',
        array(
            'title'    => __( 'Header Layout', 'traveldeck' ),
            'panel'    => 'layout_settings',
            'priority' => 10,
        )
    );
    
    $wp_customize->add_setting( 
        'header_layout_option', 
        array(
            'default'           => 'ten',
            'sanitize_callback' => 'vilva_sanitize_radio'
        ) 
    );
    
    $wp_customize->add_control(
        new Vilva_Radio_Image_Control(
            $wp_customize,
            'header_layout_option',
            array(
                'section'     => 'header_layout',
                'label'       => __( 'Header Layout', 'traveldeck' ),
                'description' => __( 'This is the layout for header.', 'traveldeck' ),
                'choices'     => array(                 
                    'one' => get_stylesheet_directory_uri() . '/images/header/one.jpg',
                    'ten' => get_stylesheet_directory_uri() . '/images/header/ten.jpg',
                )
            )
        )
    );

    /** Slider Layout Settings */
    $wp_customize->add_section(
        'slider_layout_settings',
        array(
            'title'    => __( 'Slider Layout', 'traveldeck' ),
            'priority' => 20,
            'panel'    => 'layout_settings',
        )
    );
    
    $wp_customize->add_setting( 
        'slider_layout', 
        array(
            'default'           => 'four',
            'sanitize_callback' => 'vilva_sanitize_radio'
        ) 
    );
    
    $wp_customize->add_control(
        new Vilva_Radio_Image_Control(
            $wp_customize,
            'slider_layout',
            array(
                'section'     => 'slider_layout_settings',
                'label'       => __( 'Slider Layout', 'traveldeck' ),
                'description' => __( 'Choose the layout of the slider for your site.', 'traveldeck' ),
                'choices'     => array(
                    'one'  => get_stylesheet_directory_uri() . '/images/slider/one.jpg',
                    'four' => get_stylesheet_directory_uri() . '/images/slider/four.jpg',
                )
            )
        )
    );

    /** Home Layout Settings */
    $wp_customize->add_section(
        'home_layout_settings',
        array(
            'title'    => __( 'Home Page Layout', 'traveldeck' ),
            'priority' => 20,
            'panel'    => 'layout_settings',
        )
    );
    
    $wp_customize->add_setting( 
        'homepage_layout', 
        array(
            'default'           => 'three',
            'sanitize_callback' => 'vilva_sanitize_radio'
        ) 
    );
    
    $wp_customize->add_control(
        new Vilva_Radio_Image_Control(
            $wp_customize,
            'homepage_layout',
            array(
                'section'     => 'home_layout_settings',
                'label'       => __( 'Homepage Layout', 'traveldeck' ),
                'description' => __( 'Choose the layout of the homepage for your site.', 'traveldeck' ),
                'choices'     => array(
                    'one'   => get_stylesheet_directory_uri() . '/images/home/one.jpg',
                    'three' => get_stylesheet_directory_uri() . '/images/home/three.jpg',
                )
            )
        )
    );
    
}
add_action( 'customize_register', 'traveldeck_customize_register', 99 );

require get_stylesheet_directory() . '/inc/parent-functions.php';