<?php 

if ( ! function_exists( 'travel_ride_support' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */

	function travel_ride_support() {

		// Add support for block styles.
		add_theme_support( 'wp-block-styles' );

		// Add support for post thumbnails
		add_theme_support( 'post-thumbnails' );

		// Enqueue editor styles.
		//add_editor_style( 'style.css' );

	}

endif;
add_action( 'after_setup_theme', 'travel_ride_support' );

if ( ! function_exists( 'travel_ride_enqueue_scripts_and_styles' ) ) :
	/**
	 * Enqueue styles.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	function travel_ride_enqueue_scripts_and_styles() {
		$min = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';
		$version = wp_get_theme()->get('version');
		$template_dir = get_template_directory_uri();
		$template_assets_dir = $template_dir . '/assets';

		// Styles
		$styles = array(
			'travel-ride-style'         => array(get_stylesheet_uri(), array(), $version),
			'travel-ride-custom-css'    => array($template_assets_dir . '/css/custom.css', array(), $version),
			'travel-ride-animate'       => array($template_assets_dir . '/css/animate' . $min . '.css', array(), '3.7.0'),
			'travel-ride-wp-travel'     => array($template_assets_dir . '/css/wp-travel.css', array(), $version),
			'travel-ride-woocommerce'   => array($template_assets_dir . '/css/woocommerce.css', array(), $version)
		);

		// Scripts
		$scripts = array(
			'travel-ride-wow-js'        => array($template_assets_dir . '/js/wow' . $min . '.js', array(), '1.1.2', true),
			'travel-ride-custom'  => array($template_assets_dir . '/js/custom.js', array('jquery'), '1.0.0', true),
		);

		// Enqueue Styles
		foreach ($styles as $handle => $data) {
			list($src, $deps, $ver) = $data;
			wp_enqueue_style($handle, $src, $deps, $ver);
		}

		// Enqueue Scripts
		foreach ($scripts as $handle => $data) {
			list($src, $deps, $ver, $in_footer) = $data;
			wp_enqueue_script($handle, $src, $deps, $ver, $in_footer);
		}
	}

endif;

add_action('wp_enqueue_scripts', 'travel_ride_enqueue_scripts_and_styles');

/* PreLoader */

add_action( 'wp_body_open', 'travel_ride_preloader' );

/**
 * Adds the Preloader
 *
 * @since  1.0
 *
 * @package Travel Ride WordPress Theme
 */
 function travel_ride_preloader() {

 	?>
 	<div id="loader-wrapper">
 		<div id="loader"></div>
 	</div>
 	<?php
 }

require get_theme_file_path( '/inc/tgm-plugin/tgmpa-hook.php' );
