<?php
/**
 * Title: Logistics Solution Section
 * Slug: transport-services/logistics-solution-section
 * Categories: transport-services, logistics-solution-section
 */
?>

<!-- wp:group {"className":"logistics-solution-section wow zoomIn","layout":{"type":"constrained","contentSize":"80%"}} -->
<div class="wp-block-group logistics-solution-section wow zoomIn"><!-- wp:group {"className":"logistics-solution-head-box","layout":{"type":"default"}} -->
<div class="wp-block-group logistics-solution-head-box"><!-- wp:heading {"textAlign":"center","level":3,"style":{"typography":{"fontSize":"28px","fontStyle":"normal","fontWeight":"600","textTransform":"capitalize","lineHeight":"1.4"},"spacing":{"margin":{"bottom":"var:preset|spacing|30"}}}} -->
<h3 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--30);font-size:28px;font-style:normal;font-weight:600;line-height:1.4;text-transform:capitalize"><?php esc_html_e('our logistics ','transport-services'); ?><mark style="background-color:rgba(0, 0, 0, 0)" class="has-inline-color has-primary-color"><?php esc_html_e('solutions','transport-services'); ?></mark></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"17px","fontStyle":"normal","fontWeight":"600"},"spacing":{"margin":{"top":"var:preset|spacing|20","bottom":"0"}}}} -->
<p class="has-text-align-center" style="margin-top:var(--wp--preset--spacing--20);margin-bottom:0;font-size:17px;font-style:normal;font-weight:600"><?php esc_html_e('Comprehensive services tailored for your shipping needs.','transport-services'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:columns {"className":"owl-carousel logistics-solution-cont-box"} -->
<div class="wp-block-columns owl-carousel logistics-solution-cont-box"><!-- wp:column {"className":"logistics-solution-inner-cont-box","style":{"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}},"border":{"color":"#00000000","width":"2px","radius":"12px"}},"backgroundColor":"base"} -->
<div class="wp-block-column logistics-solution-inner-cont-box has-border-color has-base-background-color has-background" style="border-color:#00000000;border-width:2px;border-radius:12px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() . '/images/logistic1.png'); ?>","id":57,"dimRatio":0,"isUserOverlayColor":true,"minHeight":200,"sizeSlug":"full","className":"logistics-solution-inner-img","style":{"border":{"radius":{"topLeft":"5px","topRight":"5px","bottomLeft":"0px","bottomRight":"0px"}},"spacing":{"padding":{"top":"0px","bottom":"0px","left":"0px","right":"0px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover logistics-solution-inner-img" style="border-top-left-radius:5px;border-top-right-radius:5px;border-bottom-left-radius:0px;border-bottom-right-radius:0px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px;min-height:200px"><img class="wp-block-cover__image-background wp-image-57 size-full" alt="" src="<?php echo esc_url( get_template_directory_uri() . '/images/logistic1.png'); ?>" data-object-fit="cover"/><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim"></span><div class="wp-block-cover__inner-container"><!-- wp:buttons {"className":"logistics-solution-btn","layout":{"type":"flex","verticalAlignment":"center"}} -->
<div class="wp-block-buttons logistics-solution-btn"><!-- wp:button {"style":{"color":{"background":"#00000000"},"spacing":{"padding":{"left":"10px","right":"10px","top":"5px","bottom":"5px"}}}} -->
<div class="wp-block-button"><a class="wp-block-button__link has-background wp-element-button" href="#" style="background-color:#00000000;padding-top:5px;padding-right:10px;padding-bottom:5px;padding-left:10px"><img class="wp-image-58" style="width: 66px;" src="<?php echo esc_url( get_template_directory_uri() . '/images/shipping-btn.png'); ?>" alt=""></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div></div>
<!-- /wp:cover -->

<!-- wp:heading {"level":5,"style":{"typography":{"fontStyle":"normal","fontWeight":"600","textTransform":"capitalize"},"spacing":{"padding":{"left":"var:preset|spacing|40"},"margin":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|40"}}}} -->
<h5 class="wp-block-heading" style="margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40);font-style:normal;font-weight:600;text-transform:capitalize"><?php esc_html_e('1. air freight','transport-services'); ?></h5>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"fontSize":"13px"},"spacing":{"margin":{"top":"4px","bottom":"4px"}}}} -->
<p style="margin-top:4px;margin-bottom:4px;font-size:13px"><?php esc_html_e('Fast, secure, and efficient international shipping for high-value or time-sensitive goods. With global air carrier partnerships, we ensure rapid customs clearance and delivery.','transport-services'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"className":"logistics-solution-inner-cont-box","style":{"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}},"border":{"color":"#00000000","width":"2px","radius":"12px"}},"backgroundColor":"base"} -->
<div class="wp-block-column logistics-solution-inner-cont-box has-border-color has-base-background-color has-background" style="border-color:#00000000;border-width:2px;border-radius:12px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() . '/images/logistic2.png'); ?>","id":83,"dimRatio":0,"isUserOverlayColor":true,"minHeight":200,"isDark":false,"sizeSlug":"full","className":"logistics-solution-inner-img","style":{"border":{"radius":{"topLeft":"5px","topRight":"5px","bottomLeft":"0px","bottomRight":"0px"}},"spacing":{"padding":{"top":"0px","bottom":"0px","left":"0px","right":"0px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover is-light logistics-solution-inner-img" style="border-top-left-radius:5px;border-top-right-radius:5px;border-bottom-left-radius:0px;border-bottom-right-radius:0px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px;min-height:200px"><img class="wp-block-cover__image-background wp-image-83 size-full" alt="" src="<?php echo esc_url( get_template_directory_uri() . '/images/logistic2.png'); ?>" data-object-fit="cover"/><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim"></span><div class="wp-block-cover__inner-container"><!-- wp:buttons {"className":"logistics-solution-btn","layout":{"type":"flex","verticalAlignment":"center"}} -->
<div class="wp-block-buttons logistics-solution-btn"><!-- wp:button {"style":{"color":{"background":"#00000000"},"spacing":{"padding":{"left":"10px","right":"10px","top":"5px","bottom":"5px"}}}} -->
<div class="wp-block-button"><a class="wp-block-button__link has-background wp-element-button" href="#" style="background-color:#00000000;padding-top:5px;padding-right:10px;padding-bottom:5px;padding-left:10px"><img class="wp-image-58" style="width: 66px;" src="<?php echo esc_url( get_template_directory_uri() . '/images/shipping-btn.png'); ?>" alt=""></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div></div>
<!-- /wp:cover -->

<!-- wp:heading {"level":5,"style":{"typography":{"fontStyle":"normal","fontWeight":"600","textTransform":"capitalize"},"spacing":{"padding":{"left":"var:preset|spacing|40"},"margin":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|40"}}}} -->
<h5 class="wp-block-heading" style="margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40);font-style:normal;font-weight:600;text-transform:capitalize"><?php esc_html_e('2. sea freight','transport-services'); ?></h5>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"fontSize":"13px"},"spacing":{"margin":{"top":"4px","bottom":"4px"}}}} -->
<p style="margin-top:4px;margin-bottom:4px;font-size:13px"><?php esc_html_e('Cost-effective and reliable transport for bulk or oversized shipments. Ideal for long-distance international trade with full container (FCL) or less-than-container load (LCL) options.','transport-services'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"className":"logistics-solution-inner-cont-box","style":{"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}},"border":{"color":"#00000000","width":"2px","radius":"12px"}},"backgroundColor":"base"} -->
<div class="wp-block-column logistics-solution-inner-cont-box has-border-color has-base-background-color has-background" style="border-color:#00000000;border-width:2px;border-radius:12px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() . '/images/logistic3.png'); ?>","id":84,"dimRatio":0,"isUserOverlayColor":true,"minHeight":200,"isDark":false,"sizeSlug":"full","className":"logistics-solution-inner-img","style":{"border":{"radius":{"topLeft":"5px","topRight":"5px","bottomLeft":"0px","bottomRight":"0px"}},"spacing":{"padding":{"top":"0px","bottom":"0px","left":"0px","right":"0px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover is-light logistics-solution-inner-img" style="border-top-left-radius:5px;border-top-right-radius:5px;border-bottom-left-radius:0px;border-bottom-right-radius:0px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px;min-height:200px"><img class="wp-block-cover__image-background wp-image-84 size-full" alt="" src="<?php echo esc_url( get_template_directory_uri() . '/images/logistic3.png'); ?>" data-object-fit="cover"/><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim"></span><div class="wp-block-cover__inner-container"><!-- wp:buttons {"className":"logistics-solution-btn","layout":{"type":"flex","verticalAlignment":"center"}} -->
<div class="wp-block-buttons logistics-solution-btn"><!-- wp:button {"style":{"color":{"background":"#00000000"},"spacing":{"padding":{"left":"10px","right":"10px","top":"5px","bottom":"5px"}}}} -->
<div class="wp-block-button"><a class="wp-block-button__link has-background wp-element-button" href="#" style="background-color:#00000000;padding-top:5px;padding-right:10px;padding-bottom:5px;padding-left:10px"><img class="wp-image-58" style="width: 66px;" src="<?php echo esc_url( get_template_directory_uri() . '/images/shipping-btn.png'); ?>" alt=""></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div></div>
<!-- /wp:cover -->

<!-- wp:heading {"level":5,"style":{"typography":{"fontStyle":"normal","fontWeight":"600","textTransform":"capitalize"},"spacing":{"padding":{"left":"var:preset|spacing|40"},"margin":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|40"}}}} -->
<h5 class="wp-block-heading" style="margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40);font-style:normal;font-weight:600;text-transform:capitalize"><?php esc_html_e('3. road transport','transport-services'); ?></h5>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"fontSize":"13px"},"spacing":{"margin":{"top":"4px","bottom":"4px"}}}} -->
<p style="margin-top:4px;margin-bottom:4px;font-size:13px"><?php esc_html_e('Domestic and cross-border ground transportation with real-time tracking and route optimization. Perfect for regional deliveries, retail logistics, and last-mile fulfillment.','transport-services'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"className":"logistics-solution-inner-cont-box","style":{"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}},"border":{"color":"#00000000","width":"2px","radius":"12px"}},"backgroundColor":"base"} -->
<div class="wp-block-column logistics-solution-inner-cont-box has-border-color has-base-background-color has-background" style="border-color:#00000000;border-width:2px;border-radius:12px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() . '/images/logistic4.png'); ?>","id":86,"dimRatio":0,"isUserOverlayColor":true,"minHeight":200,"isDark":false,"sizeSlug":"full","className":"logistics-solution-inner-img","style":{"border":{"radius":{"topLeft":"5px","topRight":"5px","bottomLeft":"0px","bottomRight":"0px"}},"spacing":{"padding":{"top":"0px","bottom":"0px","left":"0px","right":"0px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover is-light logistics-solution-inner-img" style="border-top-left-radius:5px;border-top-right-radius:5px;border-bottom-left-radius:0px;border-bottom-right-radius:0px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px;min-height:200px"><img class="wp-block-cover__image-background wp-image-86 size-full" alt="" src="<?php echo esc_url( get_template_directory_uri() . '/images/logistic4.png'); ?>" data-object-fit="cover"/><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim"></span><div class="wp-block-cover__inner-container"><!-- wp:buttons {"className":"logistics-solution-btn","layout":{"type":"flex","verticalAlignment":"center"}} -->
<div class="wp-block-buttons logistics-solution-btn"><!-- wp:button {"style":{"color":{"background":"#00000000"},"spacing":{"padding":{"left":"10px","right":"10px","top":"5px","bottom":"5px"}}}} -->
<div class="wp-block-button"><a class="wp-block-button__link has-background wp-element-button" href="#" style="background-color:#00000000;padding-top:5px;padding-right:10px;padding-bottom:5px;padding-left:10px"><img class="wp-image-58" style="width: 66px;" src="<?php echo esc_url( get_template_directory_uri() . '/images/shipping-btn.png'); ?>" alt=""></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div></div>
<!-- /wp:cover -->

<!-- wp:heading {"level":5,"style":{"typography":{"fontStyle":"normal","fontWeight":"600","textTransform":"capitalize"},"spacing":{"padding":{"left":"var:preset|spacing|40"},"margin":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|40"}}}} -->
<h5 class="wp-block-heading" style="margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40);font-style:normal;font-weight:600;text-transform:capitalize"><?php esc_html_e('4. Warehousing','transport-services'); ?></h5>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"fontSize":"13px"},"spacing":{"margin":{"top":"4px","bottom":"4px"}}}} -->
<p style="margin-top:4px;margin-bottom:4px;font-size:13px"><?php esc_html_e('Secure storage facilities with inventory management, packaging, and fulfillment support. Strategically located hubs to speed up delivery and reduce handling costs.','transport-services'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"className":"logistics-solution-inner-cont-box","style":{"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}},"border":{"color":"#00000000","width":"2px","radius":"12px"}},"backgroundColor":"base"} -->
<div class="wp-block-column logistics-solution-inner-cont-box has-border-color has-base-background-color has-background" style="border-color:#00000000;border-width:2px;border-radius:12px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() . '/images/logistic5.png'); ?>","id":90,"dimRatio":0,"isUserOverlayColor":true,"minHeight":200,"isDark":false,"sizeSlug":"full","className":"logistics-solution-inner-img","style":{"border":{"radius":{"topLeft":"5px","topRight":"5px","bottomLeft":"0px","bottomRight":"0px"}},"spacing":{"padding":{"top":"0px","bottom":"0px","left":"0px","right":"0px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover is-light logistics-solution-inner-img" style="border-top-left-radius:5px;border-top-right-radius:5px;border-bottom-left-radius:0px;border-bottom-right-radius:0px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px;min-height:200px"><img class="wp-block-cover__image-background wp-image-90 size-full" alt="" src="<?php echo esc_url( get_template_directory_uri() . '/images/logistic5.png'); ?>" data-object-fit="cover"/><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim"></span><div class="wp-block-cover__inner-container"><!-- wp:buttons {"className":"logistics-solution-btn","layout":{"type":"flex","verticalAlignment":"center"}} -->
<div class="wp-block-buttons logistics-solution-btn"><!-- wp:button {"style":{"color":{"background":"#00000000"},"spacing":{"padding":{"left":"10px","right":"10px","top":"5px","bottom":"5px"}}}} -->
<div class="wp-block-button"><a class="wp-block-button__link has-background wp-element-button" href="#" style="background-color:#00000000;padding-top:5px;padding-right:10px;padding-bottom:5px;padding-left:10px"><img class="wp-image-58" style="width: 66px;" src="<?php echo esc_url( get_template_directory_uri() . '/images/shipping-btn.png'); ?>" alt=""></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div></div>
<!-- /wp:cover -->

<!-- wp:heading {"level":5,"style":{"typography":{"fontStyle":"normal","fontWeight":"600","textTransform":"capitalize"},"spacing":{"padding":{"left":"var:preset|spacing|40"},"margin":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|40"}}}} -->
<h5 class="wp-block-heading" style="margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40);font-style:normal;font-weight:600;text-transform:capitalize"><?php esc_html_e('5. relief aid logistics','transport-services'); ?></h5>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"fontSize":"13px"},"spacing":{"margin":{"top":"4px","bottom":"4px"}}}} -->
<p style="margin-top:4px;margin-bottom:4px;font-size:13px"><?php esc_html_e('Rapid deployment of food, shelter, and essentials to crisis zones. Expert coordination ensures urgent aid reaches affected communities on time.','transport-services'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:spacer {"height":"30px"} -->
<div style="height:30px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->