<?php
/**
 * Title: FAQ Section
 * Slug: transport-services/faq-section
 * Categories: transport-services, faq-section
 */
?>

<!-- wp:group {"className":"faq-section wow fadeInUp","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","right":"0px","bottom":"var:preset|spacing|70","left":"0px"}},"background":{"backgroundImage":{"url":"<?php echo esc_url( get_template_directory_uri() . '/images/faq-bg.png'); ?>","id":74,"source":"file","title":"faq-bg"},"backgroundSize":"cover"}},"layout":{"type":"constrained","contentSize":"80%"}} -->
<div class="wp-block-group faq-section wow fadeInUp" style="padding-top:var(--wp--preset--spacing--70);padding-right:0px;padding-bottom:var(--wp--preset--spacing--70);padding-left:0px"><!-- wp:group {"className":"head-box","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|70"}}},"layout":{"type":"default"}} -->
<div class="wp-block-group head-box" style="margin-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"600","fontSize":"28px","textTransform":"capitalize"},"spacing":{"margin":{"top":"var:preset|spacing|20","bottom":"0"}},"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"textColor":"base"} -->
<h2 class="wp-block-heading has-text-align-center has-base-color has-text-color has-link-color" style="margin-top:var(--wp--preset--spacing--20);margin-bottom:0;font-size:28px;font-style:normal;font-weight:600;text-transform:capitalize"><?php esc_html_e('got questions? we’ve got ','transport-services'); ?><mark style="background-color:rgba(0, 0, 0, 0)" class="has-inline-color has-primary-color"><?php esc_html_e('answers.','transport-services'); ?></mark></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","className":"sec-sub-heading","style":{"typography":{"fontStyle":"normal","fontWeight":"600"},"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"spacing":{"margin":{"top":"var:preset|spacing|40"}}},"textColor":"base","fontSize":"small"} -->
<p class="has-text-align-center sec-sub-heading has-base-color has-text-color has-link-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--40);font-style:normal;font-weight:600"><?php esc_html_e('Everything you need to know about our logistics services and how we operate.','transport-services'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:columns {"className":"faq-section-cols"} -->
<div class="wp-block-columns faq-section-cols"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"className":"faq-section-main-box","layout":{"type":"default"}} -->
<div class="wp-block-group faq-section-main-box"><!-- wp:details {"showContent":true,"className":"faq-detail-block","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"typography":{"fontSize":"20px"},"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|40","right":"var:preset|spacing|40"}},"border":{"width":"2px"}},"textColor":"white","borderColor":"base"} -->
<details class="wp-block-details faq-detail-block has-border-color has-base-border-color has-white-color has-text-color has-link-color" style="border-width:2px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--40);font-size:20px" open><summary><?php esc_html_e('How do I track my shipment?','transport-services'); ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontSize":"14px","fontStyle":"normal","fontWeight":"300"}}} -->
<p style="font-size:14px;font-style:normal;font-weight:300"><?php esc_html_e('You can track your shipment in real time using our Track Your Shipment page. Just enter your tracking number to get live updates on location and estimated delivery time.','transport-services'); ?></p>
<!-- /wp:paragraph --></details>
<!-- /wp:details -->

<!-- wp:details {"className":"faq-detail-block","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"typography":{"fontSize":"20px"},"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|40","right":"var:preset|spacing|40"}},"border":{"width":"2px"}},"textColor":"white","borderColor":"base"} -->
<details class="wp-block-details faq-detail-block has-border-color has-base-border-color has-white-color has-text-color has-link-color" style="border-width:2px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--40);font-size:20px"><summary><?php esc_html_e('What shipping modes do you offer?','transport-services'); ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontSize":"14px","fontStyle":"normal","fontWeight":"300"}}} -->
<p style="font-size:14px;font-style:normal;font-weight:300"><?php esc_html_e('You can track your shipment in real time using our Track Your Shipment page. Just enter your tracking number to get live updates on location and estimated delivery time.','transport-services'); ?></p>
<!-- /wp:paragraph --></details>
<!-- /wp:details -->

<!-- wp:details {"className":"faq-detail-block","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"typography":{"fontSize":"20px"},"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|40","right":"var:preset|spacing|40"}},"border":{"width":"2px"}},"textColor":"white","borderColor":"base"} -->
<details class="wp-block-details faq-detail-block has-border-color has-base-border-color has-white-color has-text-color has-link-color" style="border-width:2px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--40);font-size:20px"><summary><?php esc_html_e('Do you handle international shipping?','transport-services'); ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontSize":"14px","fontStyle":"normal","fontWeight":"300"}}} -->
<p style="font-size:14px;font-style:normal;font-weight:300"><?php esc_html_e('You can track your shipment in real time using our Track Your Shipment page. Just enter your tracking number to get live updates on location and estimated delivery time.','transport-services'); ?></p>
<!-- /wp:paragraph --></details>
<!-- /wp:details -->

<!-- wp:details {"className":"faq-detail-block","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"typography":{"fontSize":"20px"},"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|40","right":"var:preset|spacing|40"}},"border":{"width":"2px"}},"textColor":"white","borderColor":"base"} -->
<details class="wp-block-details faq-detail-block has-border-color has-base-border-color has-white-color has-text-color has-link-color" style="border-width:2px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--40);font-size:20px"><summary><?php esc_html_e('What shipping methods do you offer?','transport-services'); ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontSize":"14px","fontStyle":"normal","fontWeight":"300"}}} -->
<p style="font-size:14px;font-style:normal;font-weight:300"><?php esc_html_e('You can track your shipment in real time using our Track Your Shipment page. Just enter your tracking number to get live updates on location and estimated delivery time.','transport-services'); ?></p>
<!-- /wp:paragraph --></details>
<!-- /wp:details --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"className":"faq-section-main-box","layout":{"type":"default"}} -->
<div class="wp-block-group faq-section-main-box"><!-- wp:details {"className":"faq-detail-block","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"typography":{"fontSize":"20px"},"border":{"width":"2px"},"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|40","right":"var:preset|spacing|40"}}},"textColor":"white","borderColor":"base"} -->
<details class="wp-block-details faq-detail-block has-border-color has-base-border-color has-white-color has-text-color has-link-color" style="border-width:2px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--40);font-size:20px"><summary><?php esc_html_e('How much does shipping cost?','transport-services'); ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontSize":"14px","fontStyle":"normal","fontWeight":"300"}}} -->
<p style="font-size:14px;font-style:normal;font-weight:300"><?php esc_html_e('You can track your shipment in real time using our Track Your Shipment page. Just enter your tracking number to get live updates on location and estimated delivery time.','transport-services'); ?></p>
<!-- /wp:paragraph --></details>
<!-- /wp:details -->

<!-- wp:details {"className":"faq-detail-block","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"typography":{"fontSize":"20px"},"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|40","right":"var:preset|spacing|40"}},"border":{"width":"2px"}},"textColor":"white","borderColor":"base"} -->
<details class="wp-block-details faq-detail-block has-border-color has-base-border-color has-white-color has-text-color has-link-color" style="border-width:2px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--40);font-size:20px"><summary><?php esc_html_e('Do you offer free shipping?','transport-services'); ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontSize":"14px","fontStyle":"normal","fontWeight":"300"}}} -->
<p style="font-size:14px;font-style:normal;font-weight:300"><?php esc_html_e('You can track your shipment in real time using our Track Your Shipment page. Just enter your tracking number to get live updates on location and estimated delivery time.','transport-services'); ?></p>
<!-- /wp:paragraph --></details>
<!-- /wp:details -->

<!-- wp:details {"className":"faq-detail-block","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"typography":{"fontSize":"20px"},"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|40","right":"var:preset|spacing|40"}},"border":{"width":"2px"}},"textColor":"white","borderColor":"base"} -->
<details class="wp-block-details faq-detail-block has-border-color has-base-border-color has-white-color has-text-color has-link-color" style="border-width:2px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--40);font-size:20px"><summary><?php esc_html_e('How long does shipping take?','transport-services'); ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontSize":"14px","fontStyle":"normal","fontWeight":"300"}}} -->
<p style="font-size:14px;font-style:normal;font-weight:300"><?php esc_html_e('You can track your shipment in real time using our Track Your Shipment page. Just enter your tracking number to get live updates on location and estimated delivery time.','transport-services'); ?></p>
<!-- /wp:paragraph --></details>
<!-- /wp:details -->

<!-- wp:details {"className":"faq-detail-block","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"typography":{"fontSize":"20px"},"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|40","right":"var:preset|spacing|40"}},"border":{"width":"2px"}},"textColor":"white","borderColor":"base"} -->
<details class="wp-block-details faq-detail-block has-border-color has-base-border-color has-white-color has-text-color has-link-color" style="border-width:2px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--40);font-size:20px"><summary><?php esc_html_e('Can I track my order?','transport-services'); ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontSize":"14px","fontStyle":"normal","fontWeight":"300"}}} -->
<p style="font-size:14px;font-style:normal;font-weight:300"><?php esc_html_e('You can track your shipment in real time using our Track Your Shipment page. Just enter your tracking number to get live updates on location and estimated delivery time.','transport-services'); ?></p>
<!-- /wp:paragraph --></details>
<!-- /wp:details -->

<!-- wp:details {"className":"faq-detail-block","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"typography":{"fontSize":"20px"},"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|40","right":"var:preset|spacing|40"}},"border":{"width":"2px"}},"textColor":"white","borderColor":"base"} -->
<details class="wp-block-details faq-detail-block has-border-color has-base-border-color has-white-color has-text-color has-link-color" style="border-width:2px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--40);font-size:20px"><summary><?php esc_html_e('Can I change my shipping address after placing an order?','transport-services'); ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontSize":"14px","fontStyle":"normal","fontWeight":"300"}}} -->
<p style="font-size:14px;font-style:normal;font-weight:300"><?php esc_html_e('You can track your shipment in real time using our Track Your Shipment page. Just enter your tracking number to get live updates on location and estimated delivery time.','transport-services'); ?></p>
<!-- /wp:paragraph --></details>
<!-- /wp:details --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:spacer {"height":"10px"} -->
<div style="height:10px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->