<?php

add_action( 'admin_menu', 'transport_services_gettingstarted' );
function transport_services_gettingstarted() {
	add_theme_page( esc_html__('Begin Installation', 'transport-services'), esc_html__('Begin Installation', 'transport-services'), 'edit_theme_options', 'transport-services-guide-page', 'transport_services_guide');
}

if ( ! defined( 'TRANSPORT_SERVICES_SUPPORT' ) ) {
define('TRANSPORT_SERVICES_SUPPORT',__('https://wordpress.org/support/theme/transport-services/','transport-services'));
}
if ( ! defined( 'TRANSPORT_SERVICES_REVIEW' ) ) {
define('TRANSPORT_SERVICES_REVIEW',__('https://wordpress.org/support/theme/transport-services/reviews/','transport-services'));
}
if ( ! defined( 'TRANSPORT_SERVICES_LIVE_DEMO' ) ) {
define('TRANSPORT_SERVICES_LIVE_DEMO',__('https://trial.ovationthemes.com/transport-services/','transport-services'));
}
if ( ! defined( 'TRANSPORT_SERVICES_BUY_PRO' ) ) {
define('TRANSPORT_SERVICES_BUY_PRO',__('https://www.ovationthemes.com/products/transport-wordpress-theme','transport-services'));
}
if ( ! defined( 'TRANSPORT_SERVICES_PRO_DOC' ) ) {
define('TRANSPORT_SERVICES_PRO_DOC',__('https://trial.ovationthemes.com/docs/transport-services-pro-doc/','transport-services'));
}
if ( ! defined( 'TRANSPORT_SERVICES_FREE_DOC' ) ) {
define('TRANSPORT_SERVICES_FREE_DOC',__('https://trial.ovationthemes.com/docs/transport-services-free-doc/','transport-services'));
}
if ( ! defined( 'TRANSPORT_SERVICES_THEME_NAME' ) ) {
define('TRANSPORT_SERVICES_THEME_NAME',__('Premium Transport Services Theme','transport-services'));
}
if ( ! defined( 'TRANSPORT_SERVICES_BUNDLE_LINK' ) ) {
define('TRANSPORT_SERVICES_BUNDLE_LINK',__('https://www.ovationthemes.com/products/wordpress-bundle','transport-services'));
}
/**
 * Theme Info Page
 */
function transport_services_guide() {

	// Theme info
	$return = add_query_arg( array()) ;
	$theme = wp_get_theme( '' ); ?>

	<div class="getting-started__header">
		<div class="header-box-left">
			<h2><?php echo esc_html( $theme ); ?></h2>
			<p><?php esc_html_e('Version: ', 'transport-services'); ?><?php echo esc_html($theme['Version']);?></p>
		</div>
		<div class="header-box-right">
			<div class="btn_box">
				<a class="button-primary" href="<?php echo esc_url( TRANSPORT_SERVICES_FREE_DOC ); ?>" target="_blank"><?php esc_html_e('Documentation', 'transport-services'); ?></a>
				<a class="button-primary" href="<?php echo esc_url( TRANSPORT_SERVICES_SUPPORT ); ?>" target="_blank"><?php esc_html_e('Support', 'transport-services'); ?></a>
				<a class="button-primary" href="<?php echo esc_url( TRANSPORT_SERVICES_REVIEW ); ?>" target="_blank"><?php esc_html_e('Review', 'transport-services'); ?></a>
			</div>
		</div>
	</div>

	<div class="wrap getting-started">
		<div class="box-container">
			<div class="box-left-main">
				<div class="leftbox">
					<h3><?php esc_html_e('Documentation','transport-services'); ?></h3>
					<p><?php $theme = wp_get_theme(); 
						echo wp_kses_post( apply_filters( 'description', esc_html( $theme->get( 'Description' ) ) ) );
					?></p>

					<h4><?php esc_html_e('Edit Your Site','transport-services'); ?></h4>
					<p><?php esc_html_e('Now create your website with easy drag and drop powered by gutenburg.','transport-services'); ?></p>
					<a class="button-primary" href="<?php echo esc_url( admin_url() . 'site-editor.php' ); ?>" target="_blank"><?php esc_html_e('Edit Your Site','transport-services'); ?></a>

					<h4><?php esc_html_e('Visit Your Site','transport-services'); ?></h4>
					<p><?php esc_html_e('To check your website click here','transport-services'); ?></p>
					<a class="button-primary" href="<?php echo esc_url( home_url() ); ?>" target="_blank"><?php esc_html_e('Visit Your Site','transport-services'); ?></a>

					<h4><?php esc_html_e('Theme Documentation','transport-services'); ?></h4>
					<p><?php esc_html_e('Check the theme documentation to easily set up your website.','transport-services'); ?></p>
					<a class="button-primary" href="<?php echo esc_url( TRANSPORT_SERVICES_FREE_DOC ); ?>" target="_blank"><?php esc_html_e('Documentation','transport-services'); ?></a>
				</div>
       	</div>
			<div class="box-right-main">
				<h3><?php echo esc_html(TRANSPORT_SERVICES_THEME_NAME); ?></h3>
				<img class="transport_services_img_responsive" style="width: 100%;" src="<?php echo esc_url( $theme->get_screenshot() ); ?>" />
				<div class="pro-links">
					<div class="pro-links-inner">
						<a class="button-primary livedemo" href="<?php echo esc_url( TRANSPORT_SERVICES_LIVE_DEMO ); ?>" target="_blank"><?php esc_html_e('Live Demo', 'transport-services'); ?></a>
						<a class="button-primary buynow" href="<?php echo esc_url( TRANSPORT_SERVICES_BUY_PRO ); ?>" target="_blank"><?php esc_html_e('Buy Now', 'transport-services'); ?></a>
						<a class="button-primary docs" href="<?php echo esc_url( TRANSPORT_SERVICES_PRO_DOC ); ?>" target="_blank"><?php esc_html_e('Documentation', 'transport-services'); ?></a>
					</div>
						<a class="button-primary bundle-btn" href="<?php echo esc_url( TRANSPORT_SERVICES_BUNDLE_LINK ); ?>" target="_blank"><?php esc_html_e('WordPress Theme Bundle (125+ Themes at Just $99)', 'transport-services'); ?></a>
				</div>
				<ul style="padding-top:10px">
					<li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Responsive Design', 'transport-services');?> </li>                 
					<li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Demo Importer', 'transport-services');?> </li>
					<li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Section Reordering', 'transport-services');?> </li>
					<li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Contact Page Template', 'transport-services');?> </li>
					<li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Multiple Blog Layouts', 'transport-services');?> </li>
					<li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Unlimited Color Options', 'transport-services');?> </li>
					<li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Cross Browser Support', 'transport-services');?> </li>
					<li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Detailed Documentation Included', 'transport-services');?> </li>
					<li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('WPML Compatible (Translation Ready)', 'transport-services');?> </li>
					<li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Woo-commerce Compatible', 'transport-services');?> </li>
					<li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Full Support', 'transport-services');?> </li>
					<li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('10+ Sections', 'transport-services');?> </li>
					<li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('SEO Friendly', 'transport-services');?> </li>
               <li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Supper Fast', 'transport-services');?> </li>
            </ul>
        	</div>
		</div>
	</div>

<?php }?>