<?php
/**
 * Transport Services: Customizer
 *
 * @subpackage Transport Services
 * @since 1.0
 */

function transport_services_customize_register( $wp_customize ) {

	wp_enqueue_style('customizercustom_css', esc_url( get_template_directory_uri() ). '/inc/customizer/customizer.css');

	// Pro Section
 	$wp_customize->add_section('transport_services_pro', array(
        'title'    => __('TRANSPORT SERVICES PREMIUM', 'transport-services'),
        'priority' => 1,
    ));
    $wp_customize->add_setting('transport_services_pro', array(
        'default'           => null,
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control(new Transport_Services_Pro_Control($wp_customize, 'transport_services_pro', array(
        'label'    => __('TRANSPORT SERVICES PREMIUM', 'transport-services'),
        'section'  => 'transport_services_pro',
        'settings' => 'transport_services_pro',
        'priority' => 1,
    )));
}
add_action( 'customize_register', 'transport_services_customize_register' );


define('TRANSPORT_SERVICES_PRO_LINK',__('https://www.ovationthemes.com/products/transport-wordpress-theme','transport-services'));

define('TRANSPORT_SERVICES_BUNDLE_BTN',__('https://www.ovationthemes.com/products/wordpress-bundle','transport-services'));

/* Pro control */
if (class_exists('WP_Customize_Control') && !class_exists('Transport_Services_Pro_Control')):
    class Transport_Services_Pro_Control extends WP_Customize_Control{

    public function render_content(){?>
        <label style="overflow: hidden; zoom: 1;">
	        <div class="col-md upsell-btn">
                <a href="<?php echo esc_url( TRANSPORT_SERVICES_PRO_LINK ); ?>" target="blank" class="btn btn-success btn"><?php esc_html_e('UPGRADE TRANSPORT SERVICES PREMIUM','transport-services');?> </a>
	        </div>
            <div class="col-md">
                <img class="transport_services_img_responsive " src="<?php echo esc_url(get_template_directory_uri()); ?>/screenshot.png">
            </div>
	        <div class="col-md">
                <ul style="padding-top:10px">
                    <li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Responsive Design', 'transport-services');?> </li>                 
                    <li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Demo Importer', 'transport-services');?> </li>
                    <li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Section Reordering', 'transport-services');?> </li>
                    <li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Contact Page Template', 'transport-services');?> </li>
                    <li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Multiple Blog Layouts', 'transport-services');?> </li>
                    <li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Unlimited Color Options', 'transport-services');?> </li>
                    <li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Cross Browser Support', 'transport-services');?> </li>
                    <li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Detailed Documentation Included', 'transport-services');?> </li>
                    <li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('WPML Compatible (Translation Ready)', 'transport-services');?> </li>
                    <li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Woo-commerce Compatible', 'transport-services');?> </li>
                    <li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Full Support', 'transport-services');?> </li>
                    <li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('10+ Sections', 'transport-services');?> </li>
                    <li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('SEO Friendly', 'transport-services');?> </li>
                    <li class="upsell-transport_services"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Supper Fast', 'transport-services');?> </li>
                </ul>
        	</div>
            <div class="col-md upsell-btn upsell-btn-bottom">
                <a href="<?php echo esc_url( TRANSPORT_SERVICES_BUNDLE_BTN ); ?>" target="blank" class="btn btn-success btn"><?php esc_html_e('WP Theme Bundle (125+ Themes)','transport-services');?> </a>
            </div>
        </label>
    <?php } }
endif;