<?php 

function transport_services_add_admin_menu() {
    add_menu_page(
        'Theme Settings', // Page title
        'Theme Settings', // Menu title
        'manage_options', // Capability
        'transport-services-theme-settings', // Menu slug
        'transport_services_settings_page' // Function to display the page
    );
}
add_action( 'admin_menu', 'transport_services_add_admin_menu' );

function transport_services_settings_page() {
    ?>
    <div class="wrap">
        <h1><?php esc_html_e( 'Theme Settings', 'transport-services' ); ?></h1>
        <form action="options.php" method="post">
            <?php
            settings_fields( 'transport_services_settings_group' );
            do_settings_sections( 'transport-services-theme-settings' );
            submit_button();
            ?>
        </form>
    </div>
    <?php
}

function transport_services_register_settings() {
    register_setting( 'transport_services_settings_group', 'transport_services_enable_animations' );

    add_settings_section(
        'transport_services_settings_section',
        __( 'Animation Settings', 'transport-services' ),
        null,
        'transport-services-theme-settings'
    );

    add_settings_field(
        'transport_services_enable_animations',
        __( 'Enable Animations', 'transport-services' ),
        'transport_services_enable_animations_callback',
        'transport-services-theme-settings',
        'transport_services_settings_section'
    );
}
add_action( 'admin_init', 'transport_services_register_settings' );

function transport_services_enable_animations_callback() {
    $checked = get_option( 'transport_services_enable_animations', true );
    ?>
    <input type="checkbox" name="transport_services_enable_animations" value="1" <?php checked( 1, $checked ); ?> />
    <?php
}

