<?php
/**
 * Transport Services: Block Patterns
 *
 * @since Transport Services 1.0
 */

/**
 * Registers block patterns and categories.
 *
 * @since Transport Services 1.0
 *
 * @return void
 */
function transport_services_register_block_patterns() {
	$transport_services_block_pattern_categories = array(
		'transport-services'    => array( 'label' => __( 'Transport Services', 'transport-services' ) ),
	);

	$transport_services_block_pattern_categories = apply_filters( 'transport_services_block_pattern_categories', $transport_services_block_pattern_categories );

	foreach ( $transport_services_block_pattern_categories as $name => $properties ) {
		if ( ! WP_Block_Pattern_Categories_Registry::get_instance()->is_registered( $name ) ) {
			register_block_pattern_category( $name, $properties );
		}
	}
}
add_action( 'init', 'transport_services_register_block_patterns', 9 );
