<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package TR_Affreview_Lite
 */

get_header(); ?>
	<!-- ========== start of post-details section ========== -->
	<section id="post-details" class="section-padding">
		<div class="container">
			<div class="post-details-area">
				<?php while(have_posts()): the_post(); ?>
				<div class="post-content">
					
					<?php 
						if(has_post_thumbnail()){
							the_post_thumbnail('tr-photography-lite-thumbnail', array('class'=>'img-responsive'));
						}
						?>
						<h2 class="post-title"><?php the_title(); ?></h2>
					<div class="row">
						<div class="<?php echo esc_attr( tr_affreview_lite_content_layout() ); ?>">
							<div class="caption"> 
								<p class="author-text"><span><a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ) )); ?>"><?php the_author(); ?></a>  /</span>  <?php echo get_the_date(get_option( 'date_format' )) ?> </p>
								
								<?php the_content();
								
								 edit_post_link( __('Edit Your Post','tr-affreview-lite') , '<p>', '</p>'); ?>
							</div>

							<div class="filed-under">
								<p class="filed-one col-md-6">
									<?php esc_html_e( 'FILED UNDER : ' , 'tr-affreview-lite' ); ?><?php the_category( ' , ' ); ?></p>

								<p class="filed-two col-md-6">
									<?php esc_html_e( 'TAG :' , 'tr-affreview-lite' ); ?><?php the_tags( ' ' ); ?></p>
							</div>
                   
				<?php endwhile; ?>
                    
							<!-- Comment -->
					 <?php 
					 	if ( comments_open() || get_comments_number() ) :
                            comments_template();
                        endif;
                        ?>
						</div><!-- /.end of col-md-8 -->
						<?php get_sidebar(); ?>
					</div><!-- /.end of row -->
				<?php if(have_posts()): while(have_posts()): the_post(); ?>
					<!-- pager -->
					<nav>
						<ul class="pager">
							<li class="previous pull-left"><?php previous_post_link( '<i class="fa fa-chevron-left" aria-hidden="true"></i>'.'%link' ); ?></li>
				
							<li class="next pull-right"> <?php next_post_link( '%link<i class="fa fa-chevron-right" aria-hidden="true"></i>' ); ?> </li>
						</ul>
					</nav>
				<?php endwhile; endif; ?>
				</div><!-- /.end of post-content -->
			</div><!-- /.end of post-details-area -->
		</div><!-- /.end of container -->
	</section><!-- /#end of post-details section -->

<?php
 
get_footer();
