<?php

/**
 * Featured section
 *
 * This is the template for the content of featured section
 *
 * @package Theme Palace
 * @subpackage TP Coast
 * @since TP Coast 1.0.0
 */
if (!function_exists('tp_coast_add_hero_banner_section')) :
    /**
     * Add featured section
     *
     *@since TP Coast 1.0.0
     */
    function tp_coast_add_hero_banner_section()
    {
        $options = tp_coast_get_theme_options();
        // Check if destination is enabled on frontpage
        $hero_banner_enable = apply_filters('tp_coast_section_status', true, 'hero_banner_section_enable');

        if (true !== $hero_banner_enable) {
            return false;
        }


        // Render destination section now.
        tp_coast_render_hero_banner_section();
    }
endif;

if (!function_exists('tp_coast_render_hero_banner_section')) :
    /**
     * Start destination section
     *
     * @return string destination content
     * @since TP Coast 1.0.0
     *
     */
    function tp_coast_render_hero_banner_section($content_details = array())
    {
        $options = tp_coast_get_theme_options();

        $hero_banner_background_default = get_template_directory_uri() . '/assets/images/hero.png';
        $featured_video = !empty($options['hero_banner_play_video_url']) ? $options['hero_banner_play_video_url'] : '';

        $section_class = 'page-section';

?>
        <div id="tp_coast_hero_banner" class="<?php echo esc_attr($section_class); ?>">

            <div class="wrapper">
                <div class="tp_coast-hero-banner-wrapper">
                    <div class="entry-container">
                        <div class="entry-header">
                            <?php if (!empty($options['hero_banner_sub_title'])) : ?>
                                <p class="entry-subtitle"><?php echo esc_html($options['hero_banner_sub_title']); ?></p>
                            <?php endif ?>


                            <?php if (!empty($options['hero_banner_title'])) : ?>
                                <h2 class="entry-title"><?php echo esc_html($options['hero_banner_title']); ?></h2>
                        </div><!-- .section-header -->
                    <?php endif ?>


                    <div class="entry-content">
                        <?php if (!empty($options['hero_banner_content'])) : ?>

                            <p class="tp_coast-content-p"><?php echo esc_html($options['hero_banner_content']); ?>
                            </p>
                        <?php endif ?>

                        <div class="hero-banner-search">
                            <?php if (class_exists('WP_Travel')) : ?>
                                <div class="travel-search-wrapper">
                                    <div class="wp-travel-search">
                                        <?php wptravel_search_form(); ?>
                                    </div>
                                </div><!-- .travel-search-wrapper -->
                            <?php endif; ?>
                        </div>
                    </div><!-- .entry-content -->
                    </div><!-- .entry-container -->

                    <div class="featured-image">
                        <img src="<?php echo (empty($options['hero_banner_background']) ? esc_url($hero_banner_background_default) : esc_url($options['hero_banner_background'])); ?>">
                    </div>
                </div>
            </div><!-- .wrapper -->

        </div><!-- #tp_coast_hero_banner -->
        <script>

        </script>
<?php }
endif;
