<?php

/**
 * Featured section
 *
 * This is the template for the content of featured section
 *
 * @package Theme Palace
 * @subpackage TP Coast
 * @since TP Coast 1.0.0
 */
if (!function_exists('tp_coast_add_featured_section')) :
    /**
     * Add featured section
     *
     *@since TP Coast 1.0.0
     */
    function tp_coast_add_featured_section()
    {   
        if (!class_exists('WP_Travel'))
        return;

        $options = tp_coast_get_theme_options();
        // Check if featured is enabled on frontpage
        $featured_enable = apply_filters('tp_coast_section_status', true, 'featured_section_enable');

        if (true !== $featured_enable) {
            return false;
        }
        // Get featured section details
        $section_details = array();
        $section_details = apply_filters('tp_coast_filter_featured_section_details', $section_details);

        if (empty($section_details)) {
            return;
        }

        // Render featured section now.
        tp_coast_render_featured_section($section_details);
    }
endif;

if (!function_exists('tp_coast_get_featured_section_details')) :
    /**
     * featured section details.
     *
     * @since TP Coast 1.0.0
     * @param array $input featured section details.
     */
    function tp_coast_get_featured_section_details($input)
    {
        $options = tp_coast_get_theme_options();


        $featured_count = 4;
        $content = array();

                
        $page_ids = array();

        for ($i = 1; $i <= $featured_count; $i++) {
            if (!empty($options['featured_content_trip_' . $i]))
                $page_ids[] = $options['featured_content_trip_' . $i];
        }

        $args = array(
            'post_type'         => 'itineraries',
            'post__in'          => (array) $page_ids,
            'posts_per_page'    => absint($featured_count),
            'orderby'           => 'post__in',
        );
               
        // Run The Loop.
        $query = new WP_Query($args);
        if ($query->have_posts()) :
            while ($query->have_posts()) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['image']      = has_post_thumbnail() ? get_the_post_thumbnail_url(get_the_id(), 'post-thumbnail') : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                // Push to the main array.
                array_push($content, $page_post);
            endwhile;
        endif;
        wp_reset_postdata();

        if (!empty($content)) {
            $input = $content;
        }
        return $input;
    }
endif;
// featured section content details.
add_filter('tp_coast_filter_featured_section_details', 'tp_coast_get_featured_section_details');


if (!function_exists('tp_coast_render_featured_section')) :
    /**
     * Start featured section
     *
     * @return string featured content
     * @since TP Coast 1.0.0
     *
     */
    function tp_coast_render_featured_section($content_details = array())
    {
        $options = tp_coast_get_theme_options();

        $section_class = 'page-section';

        if (empty($content_details)) {
            return;
        } ?>

        <div id="tp_coast-interest" class="relative <?php echo esc_attr($section_class); ?>">
            <div class="wrapper">
                <div class="section-header">
                    <?php if (!empty($options['featured_title'])) : ?>
                        <h2 class="section-title"><?php echo esc_html($options['featured_title']); ?></h2>
                    <?php endif; ?>
                </div><!-- .section-header -->
                <div class="section-content">
                    <p><?php echo isset($options['featured_sub_title']) && !empty($options['featured_sub_title']) ? esc_html($options['featured_sub_title']) : __( 'Know More', 'tp-coast' ); ?></p>
                </div><!-- .section-content -->

                <div class="clear"></div>

                <div class="tp_coast-interest-slider relative">

                    <?php $i = 1;
                    foreach ($content_details as $content) : ?>
                        <article style="width: 365px; display: inline;">
                            <div class="featured-image" style="background-image: url('<?php echo esc_url($content['image']); ?>');"></div>
                            <div class="entry-container">
                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php echo esc_url($content['url']); ?>"><?php echo esc_html($content['title']); ?></a></h2>
                                </header>
                                <?php if (!empty($content['count'])) : ?>
                                    <span class="featured-description">
                                        <?php echo sprintf('<p>%d&nbsp;%s</p>', esc_html($content['count']), __('Packages', 'tp-coast')); ?> </p>
                                    </span>
                                <?php endif ?>
                            </div>

                        </article>
                    <?php $i++;
                    endforeach; ?>

                </div><!-- .section-content -->
            </div><!-- .wrapper -->
        </div><!-- .client-featured -->

<?php }
endif;
