<?php

/**
 * Destination section
 *
 * This is the template for the content of destination section
 *
 * @package Theme Palace
 * @subpackage TP Coast
 * @since TP Coast 1.0.0
 */
if (!function_exists('tp_coast_add_destination_section')) :
    /**
     * Add destination section
     *
     *@since TP Coast 1.0.0
     */
    function tp_coast_add_destination_section()
    {   
        if (!class_exists('WP_Travel'))
        return;

        $options = tp_coast_get_theme_options();
        // Check if destination is enabled on frontpage
        $destination_enable = apply_filters('tp_coast_section_status', true, 'destination_section_enable');

        if (true !== $destination_enable) {
            return false;
        }
        // Get destination section details
        $section_details = array();
        $section_details = apply_filters('tp_coast_filter_destination_section_details', $section_details);

        if (empty($section_details)) {
            return;
        }

        // Render destination section now.
        tp_coast_render_destination_section($section_details);
    }
endif;

if (!function_exists('tp_coast_get_destination_section_details')) :
    /**
     * destination section details.
     *
     * @since TP Coast 1.0.0
     * @param array $input destination section details.
     */
    function tp_coast_get_destination_section_details($input)
    {
        $options = tp_coast_get_theme_options();

        $destination_count =  4;

        $content = array();
     
        for ($i = 1; $i <= $destination_count; $i++) {
            if (!empty($options['destination_content_destination_' . $i])) {
                $page_post['id']      = $options['destination_content_destination_' . $i];

                $cat_image = get_term_meta($page_post['id'], 'wp_travel_trip_type_image_id', true);
                $terms = get_term_by('id',  $page_post['id'], 'travel_locations');

                if (!empty($terms) && !is_wp_error($terms)) :
                    $page_post['image'] = !empty($cat_image) ? wp_get_attachment_url($cat_image) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';
                    $page_post['title']   = $terms->name;
                    $page_post['url']     = get_term_link($page_post['id'], 'travel_locations');
                    $page_post['count']   = $terms->count;
                endif;
            }

            if (!empty($options['destination_content_destination_' . $i]))
                array_push($content, $page_post);
        }


        if (!empty($content)) {
            $input = $content;
        }
        return $input;
    }
endif;
// destination section content details.
add_filter('tp_coast_filter_destination_section_details', 'tp_coast_get_destination_section_details');

if (!function_exists('tp_coast_render_destination_section')) :
    /**
     * Start destination section
     *
     * @return string destination content
     * @since TP Coast 1.0.0
     *
     */
    function tp_coast_render_destination_section($content_details = array())
    {

        $options = tp_coast_get_theme_options();

        $section_class = 'page-section';

        if (empty($content_details)) {
            return;
        } ?>

        <div id="tp_coast_destination_section" class="relative <?php echo esc_attr($section_class); ?>">
            <div class="wrapper">
                <?php if (!empty($options['destination_sub_title'])) :  ?>

                    <div class="section-header">
                        <h2 class="section-title"><?php echo esc_html($options['destination_title']); ?></h2>
                    </div><!-- .section-header -->
                <?php endif; ?>


                <?php if (!empty($options['destination_sub_title'])) : ?>
                    <div class="section-content">
                        <p><?php echo esc_html($options['destination_sub_title']) ?></p>
                    </div><!-- .section-content -->
                <?php endif; ?>
                <div class="clear"></div>
                <div class="tp_coast-rect-block1"></div>
                <div class="tp_coast-rect-block2"></div>

                <div class="tp_coast_destination_section-slider">
                    <?php $i = 1;
                    foreach ($content_details as $content) : ?>
                        <article style="width: 365px; display: inline;">
                            <div class="featured-image">
                                <img src="<?php echo esc_url($content['image']); ?>">
                                <div class="entry-container">
                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url($content['url']); ?>"><?php echo esc_html($content['title']); ?></a></h2>
                                    </header>
                                    <?php if (!empty($content['count'])) : ?>
                                        <span class="destination-description">
                                            <?php echo sprintf('<p>%d&nbsp;%s</p>', esc_html($content['count']), __('Packages', 'tp-coast')); ?> </p>
                                        </span>
                                    <?php endif ?>
                                </div>
                            </div>

                        </article>
                    <?php $i++;
                    endforeach; ?>
                </div><!-- .section-content -->
            </div><!-- .wrapper -->
        </div><!-- .client-destination -->

<?php }
endif;
