<?php

/**
 * About section
 *
 * This is the template for the content of about section
 *
 * @package Theme Palace
 * @subpackage TP Coast
 * @since TP Coast 1.0.0
 */
if (!function_exists('tp_coast_add_about_section')) :
    /**
     * Add about section
     *
     *@since TP Coast 1.0.0
     */
    function tp_coast_add_about_section()
    {
        $options = tp_coast_get_theme_options();
        // Check if about is enabled on frontpage
        $about_enable = apply_filters('tp_coast_section_status', true, 'about_section_enable');
        if (true !== $about_enable) {
            return false;
        }
        // Render about section now.
        tp_coast_render_about_section();
    }
endif;

if (!function_exists('tp_coast_render_about_section')) :
    /**
     * Start about section
     *
     * @return string about content
     * @since TP Coast 1.0.0
     *
     */
    function tp_coast_render_about_section()
    {
        $options = tp_coast_get_theme_options();

        $section_class = 'page-section';
      ?>

        <div id="tp_coast-about-us" class="tp_coast-about-us section  text-align-right <?php echo esc_attr($section_class); ?>">
            <div class="wrapper">
                <div class="section-content-wrapper tp_coast-about-us-wrapper">
                    <article id="post-0" class="tp_coast-about-us-wrapper hentry has-post-thumbnail content-align-left">
                        <div class="hentry-inner">
                            <div class="entry-container">
                                <header class="entry-header section-title-wrapper">

                                    <?php if (!empty($options['about_sub_title'])) : ?>
                                        <div class="section-subtitle">
                                            <p><?php echo esc_html($options['about_sub_title']); ?> </p>
                                        </div><!-- .section-description-wrapper -->
                                    <?php endif; ?>

                                    <?php if (!empty($options['about_title'])) : ?>
                                        <h2 class="entry-title section-title"> <?php echo esc_html($options['about_title']); ?> </h2>
                                    <?php endif; ?>

                                </header><!-- .entry-header -->

                                <div class="entry-content">
                                    <?php if (!empty($options['about_description'])) : ?>
                                        <p class="tp_coast-paragraph">
                                            <?php echo esc_html($options['about_description']); ?>
                                        </p>
                                    <?php endif; ?>
                                        <p class="more-button">
                                            <a href="<?php echo esc_url($options['about_btn_link']); ?>">
                                                <button target="_self" class="more-link">
                                                    <?php echo isset($options['about_btn_title']) && !empty($options['about_btn_title']) ? esc_html($options['about_btn_title']) : __( 'Know More', 'tp-coast' ); ?>
                                                </button>
                                            </a>
                                        </p>
                                </div><!-- .entry-content -->
                            </div><!-- .entry-container -->
                            <?php if (!empty($options['about_us_background'])) : ?>
                                <div class="post-thumbnail-background" style="background-image: url('<?php echo esc_url($options['about_us_background'], 'tp-coast'); ?>');">
                                    <a class="cover-link" href="<?php echo esc_url($options['about_btn_link']); ?>" target="_self">
                                    </a>
                                </div><!-- .post-thumbnail -->
                            <?php endif; ?>

                        </div><!-- .hentry-inner -->
                    </article><!-- article-->
                </div>
            </div><!-- .wrapper -->
        </div>
<?php

    }
endif;
