<?php
/**
 * Theme Palace options
 *
 * @package Theme Palace
 * @subpackage TP Coast
 * @since TP Coast 1.0.0
 */

/**
 * List of pages for page choices.
 * @return Array Array of page ids and name.
 */
function tp_coast_page_choices() {
    $pages = get_pages();
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'tp-coast' );
    foreach ( $pages as $page ) {
        $choices[ $page->ID ] = $page->post_title;
    }
    return  $choices;
}

/**
 * List of posts for post choices.
 * @return Array Array of post ids and name.
 */
function tp_coast_post_choices() {
    $posts = get_posts( array( 'numberposts' => -1 ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'tp-coast' );
    foreach ( $posts as $post ) {
        $choices[ $post->ID ] = $post->post_title;
    }
    return  $choices;
}

/**
 * List of trips for post choices.
 * @return Array Array of post ids and name.
 */
function tp_coast_trip_choices() {
    $posts = get_posts( array( 'post_type' => 'itineraries', 'numberposts' => -1 ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'tp-coast' );
    foreach ( $posts as $post ) {
        $choices[ $post->ID ] = $post->post_title;
    }
    return  $choices;
}

function tp_coast_category_choices() {
    $tax_args = array(
        'hierarchical' => 0,
        'taxonomy'     => 'category',
    );
    $taxonomies = get_categories( $tax_args );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'tp-coast' );
    foreach ( $taxonomies as $tax ) {
        $choices[ $tax->term_id ] = $tax->name;
    }
    return  $choices;
}


if ( ! function_exists( 'tp_coast_selected_sidebar' ) ) :
    /**
     * Sidebars options
     * @return array Sidbar positions
     */
    function tp_coast_selected_sidebar() {
        $tp_coast_selected_sidebar = array(
            'sidebar-1'             => esc_html__( 'Default Sidebar', 'tp-coast' ),
            'optional-sidebar'      => esc_html__( 'Optional Sidebar 1', 'tp-coast' ),
            'optional-sidebar-2'    => esc_html__( 'Optional Sidebar 2', 'tp-coast' ),
            'optional-sidebar-3'    => esc_html__( 'Optional Sidebar 3', 'tp-coast' ),
            'optional-sidebar-4'    => esc_html__( 'Optional Sidebar 4', 'tp-coast' ),
        );

        $output = apply_filters( 'tp_coast_selected_sidebar', $tp_coast_selected_sidebar );

        return $output;
    }
endif;

if ( ! function_exists( 'tp_coast_site_layout' ) ) :
    /**
     * Site Layout
     * @return array site layout options
     */
    function tp_coast_site_layout() {
        $tp_coast_site_layout = array(
            'wide-layout'  => get_template_directory_uri() . '/assets/images/full.png',
            'boxed-layout' => get_template_directory_uri() . '/assets/images/boxed.png',
            'frame-layout' => get_template_directory_uri() . '/assets/images/framed.png',
        );

        $output = apply_filters( 'tp_coast_site_layout', $tp_coast_site_layout );
        return $output;
    }
endif;


if ( ! function_exists( 'tp_coast_global_sidebar_position' ) ) :
    /**
     * Global Sidebar position
     * @return array Global Sidebar positions
     */
    function tp_coast_global_sidebar_position() {
        $tp_coast_global_sidebar_position = array(
            'right-sidebar' => get_template_directory_uri() . '/assets/images/right.png',
            'no-sidebar'    => get_template_directory_uri() . '/assets/images/full.png',
        );

        $output = apply_filters( 'tp_coast_global_sidebar_position', $tp_coast_global_sidebar_position );

        return $output;
    }
endif;


if ( ! function_exists( 'tp_coast_sidebar_position' ) ) :
    /**
     * Sidebar position
     * @return array Sidbar positions
     */
    function tp_coast_sidebar_position() {
        $tp_coast_sidebar_position = array(
            'right-sidebar' => get_template_directory_uri() . '/assets/images/right.png',
            'no-sidebar'    => get_template_directory_uri() . '/assets/images/full.png',
        );

        $output = apply_filters( 'tp_coast_sidebar_position', $tp_coast_sidebar_position );

        return $output;
    }
endif;


if ( ! function_exists( 'tp_coast_pagination_options' ) ) :
    /**
     * Pagination
     * @return array site pagination options
     */
    function tp_coast_pagination_options() {
        $tp_coast_pagination_options = array(
            'numeric'   => esc_html__( 'Numeric', 'tp-coast' ),
            'default'   => esc_html__( 'Default(Older/Newer)', 'tp-coast' ),
        );

        $output = apply_filters( 'tp_coast_pagination_options', $tp_coast_pagination_options );

        return $output;
    }
endif;

if ( ! function_exists( 'tp_coast_get_spinner_list' ) ) :
    /**
     * List of spinner icons options.
     * @return array List of all spinner icon options.
     */
    function tp_coast_get_spinner_list() {
        $arr = array(
            'default'               => esc_html__( 'Default', 'tp-coast' ),
            'spinner-wheel'         => esc_html__( 'Wheel', 'tp-coast' ),
            'spinner-double-circle' => esc_html__( 'Double Circle', 'tp-coast' ),
            'spinner-two-way'       => esc_html__( 'Two Way', 'tp-coast' ),
            'spinner-umbrella'      => esc_html__( 'Umbrella', 'tp-coast' ),
            'spinner-dots'          => esc_html__( 'Dots', 'tp-coast' ),
            'spinner-one-way'       => esc_html__( 'One Way', 'tp-coast' ),
            'spinner-fidget'        => esc_html__( 'Fidget', 'tp-coast' ),
        );
        return apply_filters( 'tp_coast_spinner_list', $arr );
    }
endif;

if ( ! function_exists( 'tp_coast_switch_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function tp_coast_switch_options() {
        $arr = array(
            'on'        => esc_html__( 'Enable', 'tp-coast' ),
            'off'       => esc_html__( 'Disable', 'tp-coast' )
        );
        return apply_filters( 'tp_coast_switch_options', $arr );
    }
endif;

if ( ! function_exists( 'tp_coast_hide_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function tp_coast_hide_options() {
        $arr = array(
            'on'        => esc_html__( 'Yes', 'tp-coast' ),
            'off'       => esc_html__( 'No', 'tp-coast' )
        );
        return apply_filters( 'tp_coast_hide_options', $arr );
    }
endif;

if ( ! function_exists( 'tp_coast_sortable_sections' ) ) :
    /**
     * List of sections Control options
     * @return array List of Sections control options.
     */
    function tp_coast_sortable_sections() {
        $sections = array(
            'hero_banner'                       => esc_html__( 'Hero Banner', 'tp-coast' ),
            'featured'                          => esc_html__( 'Featured', 'tp-coast' ),
            'blog'                              => esc_html__( 'Blog', 'tp-coast' ),
            'testimonial'                       => esc_html__( 'Testimonial', 'tp-coast' ),
            'destination'                       => esc_html__( 'Destination', 'tp-coast' ),
            'about'                             => esc_html__( 'About', 'tp-coast' ),
            'gallery'                           => esc_html__( 'Gallery', 'tp-coast' ),
            'counter'                           => esc_html__( 'Counter', 'tp-coast' ),
            'subscribe'                         => esc_html__( 'Subscribe Us', 'tp-coast' ),
        );
        return apply_filters( 'tp_coast_sortable_sections', $sections );
    }
endif;



if ( ! function_exists( 'tp_coast_blog_content_type' ) ) :
    /**
     * blog options
     * @return array site blog options
     */
    function tp_coast_blog_content_type() {
        $tp_coast_blog_content_type = array(
            'category'  => esc_html__( 'Category', 'tp-coast' ),
        );

        $output = apply_filters( 'tp_coast_blog_content_type', $tp_coast_blog_content_type );


        return $output;
    }
endif;

if ( ! function_exists( 'tp_coast_featured_content_type' ) ) :
    /**
     * featured Options
     * @return array site featured options
     */
    function tp_coast_featured_content_type() {
        if ( class_exists( 'WP_Travel' ) ) {
            $tp_coast_featured_content_type = array(
                'trip'          => esc_html__( 'Trip', 'tp-coast' ),
            );
        }
        $output = apply_filters( 'tp_coast_featured_content_type', $tp_coast_featured_content_type );
        return $output;
    }
endif;
// tp_coast_destination_content_type
if ( !function_exists('tp_coast_destination_content_type')):
        /**
     * Destination Options
     * @return array site destination
     */
    function tp_coast_destination_content_type() {
        if ( class_exists( 'WP_Travel' ) ) {
            $tp_coast_destination_content_type =  array(
                'destination'   => esc_html__( 'Destination', 'tp-coast' ),
                );
        }

        $output = apply_filters( 'tp_coast_destination_content_type', $tp_coast_destination_content_type );


        return $output;
    }
endif;

