<?php
/**
 * Reset options
 *
 * @package Theme Palace
 * @subpackage TP Coast
 * @since TP Coast 1.0.0
 */

/**
* Reset section
*/
// Add reset enable section
$wp_customize->add_section( 'tp_coast_reset_section', array(
	'title'             => esc_html__('Reset all settings','tp-coast'),
	'description'       => esc_html__( 'Caution: All settings will be reset to default. Refresh the page after clicking Save & Publish.', 'tp-coast' ),
) );

// Add reset enable setting and control.
$wp_customize->add_setting( 'tp_coast_theme_options[reset_options]', array(
	'default'           => $options['reset_options'],
	'sanitize_callback' => 'tp_coast_sanitize_checkbox',
	'transport'			  => 'postMessage',
) );

$wp_customize->add_control( 'tp_coast_theme_options[reset_options]', array(
	'label'             => esc_html__( 'Check to reset all settings', 'tp-coast' ),
	'section'           => 'tp_coast_reset_section',
	'type'              => 'checkbox',
) );
