<?php
/**
 * pagination options
 *
 * @package Theme Palace
 * @subpackage TP Coast
 * @since TP Coast 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'tp_coast_pagination', array(
	'title'               => esc_html__('Pagination','tp-coast'),
	'description'         => esc_html__( 'Pagination section options.', 'tp-coast' ),
	'panel'               => 'tp_coast_theme_options_panel',
) );

// Sidebar position setting and control.
$wp_customize->add_setting( 'tp_coast_theme_options[pagination_enable]', array(
	'sanitize_callback' => 'tp_coast_sanitize_switch_control',
	'default'             => $options['pagination_enable'],
) );

$wp_customize->add_control( new TP_Coast_Switch_Control( $wp_customize, 'tp_coast_theme_options[pagination_enable]', array(
	'label'               => esc_html__( 'Pagination Enable', 'tp-coast' ),
	'section'             => 'tp_coast_pagination',
	'on_off_label' 		=> tp_coast_switch_options(),
) ) );

// Site layout setting and control.
$wp_customize->add_setting( 'tp_coast_theme_options[pagination_type]', array(
	'sanitize_callback'   => 'tp_coast_sanitize_select',
	'default'             => $options['pagination_type'],
) );

$wp_customize->add_control( 'tp_coast_theme_options[pagination_type]', array(
	'label'               => esc_html__( 'Pagination Type', 'tp-coast' ),
	'section'             => 'tp_coast_pagination',
	'type'                => 'select',
	'choices'			  => tp_coast_pagination_options(),
	'active_callback'	  => 'tp_coast_is_pagination_enable',
) );
