<?php
/**
 * Loader options
 *
 * @package Theme Palace
 * @subpackage TP Coast
 * @since TP Coast 1.0.0
 */

$wp_customize->add_section( 'tp_coast_loader', array(
	'title'            		=> esc_html__( 'Loader','tp-coast' ),
	'description'      		=> esc_html__( 'Loader section options.', 'tp-coast' ),
	'panel'            		=> 'tp_coast_theme_options_panel',
) );

// Loader enable setting and control.
$wp_customize->add_setting( 'tp_coast_theme_options[loader_enable]', array(
	'sanitize_callback' => 'tp_coast_sanitize_switch_control',
	'default'             	=> $options['loader_enable'],
) );

$wp_customize->add_control(  new TP_Coast_Switch_Control( $wp_customize, 'tp_coast_theme_options[loader_enable]', array(
	'label'               	=> esc_html__( 'Enable loader', 'tp-coast' ),
	'section'             	=> 'tp_coast_loader',
	'on_off_label' 		=> tp_coast_switch_options(),
) ) );

// Loader icons setting and control.
$wp_customize->add_setting( 'tp_coast_theme_options[loader_icon]', array(
	'sanitize_callback' 	=> 'tp_coast_sanitize_select',
	'default'				=> $options['loader_icon'],
) );

$wp_customize->add_control( 'tp_coast_theme_options[loader_icon]', array(
	'label'           		=> esc_html__( 'Icon', 'tp-coast' ),
	'section'         		=> 'tp_coast_loader',
	'type'					=> 'select',
	'choices'				=> tp_coast_get_spinner_list(),
	'active_callback' 		=> 'tp_coast_is_loader_enable',
) );
