<?php
/**
 * Layout options
 *
 * @package Theme Palace
 * @subpackage TP Coast
 * @since TP Coast 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'tp_coast_layout', array(
	'title'               => esc_html__('Layout','tp-coast'),
	'description'         => esc_html__( 'Layout section options.', 'tp-coast' ),
	'panel'               => 'tp_coast_theme_options_panel',
) );

// Site layout setting and control.
$wp_customize->add_setting( 'tp_coast_theme_options[site_layout]', array(
	'sanitize_callback'   => 'tp_coast_sanitize_select',
	'default'             => $options['site_layout'],
) );

$wp_customize->add_control(  new TP_Coast_Custom_Radio_Image_Control ( $wp_customize, 'tp_coast_theme_options[site_layout]', array(
	'label'               => esc_html__( 'Site Layout', 'tp-coast' ),
	'section'             => 'tp_coast_layout',
	'choices'			  => tp_coast_site_layout(),
) ) );

// Sidebar position setting and control.
$wp_customize->add_setting( 'tp_coast_theme_options[sidebar_position]', array(
	'sanitize_callback'   => 'tp_coast_sanitize_select',
	'default'             => $options['sidebar_position'],
) );

$wp_customize->add_control(  new TP_Coast_Custom_Radio_Image_Control ( $wp_customize, 'tp_coast_theme_options[sidebar_position]', array(
	'label'               => esc_html__( 'Global Sidebar Position', 'tp-coast' ),
	'section'             => 'tp_coast_layout',
	'choices'			  => tp_coast_global_sidebar_position(),
) ) );

// Post sidebar position setting and control.
$wp_customize->add_setting( 'tp_coast_theme_options[post_sidebar_position]', array(
	'sanitize_callback'   => 'tp_coast_sanitize_select',
	'default'             => $options['post_sidebar_position'],
) );

$wp_customize->add_control(  new TP_Coast_Custom_Radio_Image_Control ( $wp_customize, 'tp_coast_theme_options[post_sidebar_position]', array(
	'label'               => esc_html__( 'Posts Sidebar Position', 'tp-coast' ),
	'section'             => 'tp_coast_layout',
	'choices'			  => tp_coast_sidebar_position(),
) ) );

// Post sidebar position setting and control.
$wp_customize->add_setting( 'tp_coast_theme_options[page_sidebar_position]', array(
	'sanitize_callback'   => 'tp_coast_sanitize_select',
	'default'             => $options['page_sidebar_position'],
) );

$wp_customize->add_control( new TP_Coast_Custom_Radio_Image_Control( $wp_customize, 'tp_coast_theme_options[page_sidebar_position]', array(
	'label'               => esc_html__( 'Pages Sidebar Position', 'tp-coast' ),
	'section'             => 'tp_coast_layout',
	'choices'			  => tp_coast_sidebar_position(),
) ) );