<?php
/**
 * Footer options
 *
 * @package Theme Palace
 * @subpackage TP Coast
 * @since TP Coast 1.0.0
 */

// Footer Section
$wp_customize->add_section( 'tp_coast_section_footer',
	array(
		'title'      			=> esc_html__( 'Footer Options', 'tp-coast' ),
		'priority'   			=> 900,
		'panel'      			=> 'tp_coast_theme_options_panel',
	)
);

// footer text
$wp_customize->add_setting( 'tp_coast_theme_options[copyright_text]',
	array(
		'default'       		=> $options['copyright_text'],
		'sanitize_callback'		=> 'tp_coast_santize_allow_tag',
		'transport'				=> 'postMessage',
	)
);
$wp_customize->add_control( 'tp_coast_theme_options[copyright_text]',
    array(
		'label'      			=> esc_html__( 'Copyright Text', 'tp-coast' ),
		'section'    			=> 'tp_coast_section_footer',
		'type'		 			=> 'textarea',
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'tp_coast_theme_options[copyright_text]', array(
		'selector'            => '.site-info .copyright p',
		'settings'            => 'tp_coast_theme_options[copyright_text]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'tp_coast_copyright_text_partial',
    ) );
}


// footer text
$wp_customize->add_setting( 'tp_coast_theme_options[powered_by_text]',
	array(
		'default'       		=> $options['powered_by_text'],
		'sanitize_callback'		=> 'tp_coast_santize_allow_tag',
		'transport'				=> 'postMessage',
	)
);
$wp_customize->add_control( 'tp_coast_theme_options[powered_by_text]',
    array(
		'label'      			=> esc_html__( 'Powered By Text', 'tp-coast' ),
		'section'    			=> 'tp_coast_section_footer',
		'type'		 			=> 'textarea',
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'tp_coast_theme_options[powered_by_text]', array(
		'selector'            => '.site-info .powered-by p',
		'settings'            => 'tp_coast_theme_options[powered_by_text]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'tp_coast_powered_by_text_partial',
    ) );
}

// scroll top visible
$wp_customize->add_setting( 'tp_coast_theme_options[scroll_top_visible]',
	array(
		'default'       		=> $options['scroll_top_visible'],
		'sanitize_callback' => 'tp_coast_sanitize_switch_control',
	)
);
$wp_customize->add_control( new TP_Coast_Switch_Control( $wp_customize, 'tp_coast_theme_options[scroll_top_visible]',
    array(
		'label'      			=> esc_html__( 'Display Scroll Top Button', 'tp-coast' ),
		'section'    			=> 'tp_coast_section_footer',
		'on_off_label' 		=> tp_coast_switch_options(),
    )
) );