<?php
/**
 * Excerpt options
 *
 * @package Theme Palace
 * @subpackage TP Coast
 * @since TP Coast 1.0.0
 */

// Add excerpt section
$wp_customize->add_section( 'tp_coast_excerpt_section', array(
	'title'             => esc_html__( 'Excerpt','tp-coast' ),
	'description'       => esc_html__( 'Excerpt section options.', 'tp-coast' ),
	'panel'             => 'tp_coast_theme_options_panel',
) );


// long Excerpt length setting and control.
$wp_customize->add_setting( 'tp_coast_theme_options[long_excerpt_length]', array(
	'sanitize_callback' => 'tp_coast_sanitize_number_range',
	'validate_callback' => 'tp_coast_validate_long_excerpt',
	'default'			=> $options['long_excerpt_length'],
) );

$wp_customize->add_control( 'tp_coast_theme_options[long_excerpt_length]', array(
	'label'       		=> esc_html__( 'Blog Page Excerpt Length', 'tp-coast' ),
	'description' 		=> esc_html__( 'Total words to be displayed in archive page/search page.', 'tp-coast' ),
	'section'     		=> 'tp_coast_excerpt_section',
	'type'        		=> 'number',
	'input_attrs' 		=> array(
		'style'       => 'width: 80px;',
		'max'         => 100,
		'min'         => 5,
	),
) );
