<?php
/**
 * Breadcrumb options
 *
 * @package Theme Palace
 * @subpackage TP Coast
 * @since TP Coast 1.0.0
 */

$wp_customize->add_section( 'tp_coast_breadcrumb', array(
	'title'             => esc_html__( 'Breadcrumb','tp-coast' ),
	'description'       => esc_html__( 'Breadcrumb section options.', 'tp-coast' ),
	'panel'             => 'tp_coast_theme_options_panel',
) );

// Breadcrumb enable setting and control.
$wp_customize->add_setting( 'tp_coast_theme_options[breadcrumb_enable]', array(
	'sanitize_callback' => 'tp_coast_sanitize_switch_control',
	'default'          	=> $options['breadcrumb_enable'],
) );

$wp_customize->add_control( new TP_Coast_Switch_Control( $wp_customize, 'tp_coast_theme_options[breadcrumb_enable]', array(
	'label'            	=> esc_html__( 'Enable Breadcrumb', 'tp-coast' ),
	'section'          	=> 'tp_coast_breadcrumb',
	'on_off_label' 		=> tp_coast_switch_options(),
) ) );

// Breadcrumb separator setting and control.
$wp_customize->add_setting( 'tp_coast_theme_options[breadcrumb_separator]', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'          	=> $options['breadcrumb_separator'],
) );

$wp_customize->add_control( 'tp_coast_theme_options[breadcrumb_separator]', array(
	'label'            	=> esc_html__( 'Separator', 'tp-coast' ),
	'active_callback' 	=> 'tp_coast_is_breadcrumb_enable',
	'section'          	=> 'tp_coast_breadcrumb',
) );
