<?php

/**
 * Hero Banner Section options
 *
 * @package Theme Palace
 * @subpackage TP Coast
 * @since TP Coast 1.0.0
 */

// Add Hero Banner section
$wp_customize->add_section('tp_coast_hero_banner_section', array(
	'title'             => esc_html__('Hero Banner', 'tp-coast'),
	'description'       => esc_html__('Hero Banner Section options.', 'tp-coast'),
	'panel'             => 'tp_coast_front_page_panel',
));

// Hero Banner content enable control and setting
$wp_customize->add_setting('tp_coast_theme_options[hero_banner_section_enable]', array(
	'default'			=> 	$options['hero_banner_section_enable'],
	'sanitize_callback' => 'tp_coast_sanitize_switch_control',
));

$wp_customize->add_control(new TP_Coast_Switch_Control($wp_customize, 'tp_coast_theme_options[hero_banner_section_enable]', array(
	'label'             => esc_html__('Hero Banner Section Enable', 'tp-coast'),
	'section'           => 'tp_coast_hero_banner_section',
	'on_off_label' 		=> tp_coast_switch_options(),
)));

// hero_banner background image setting and control
$wp_customize->add_setting('tp_coast_theme_options[hero_banner_background]', array(
	'sanitize_callback' => 'tp_coast_sanitize_image'
));

$wp_customize->add_control(new WP_Customize_Image_Control(
	$wp_customize,
	'tp_coast_theme_options[hero_banner_background]',
	array(
		'label'       		=> esc_html__('Background Image ', 'tp-coast'),
		'description' 		=> sprintf(esc_html__('Recommended size: %1$dpx x %2$dpx ', 'tp-coast'), 1000, 1280),
		'section'     		=> 'tp_coast_hero_banner_section',
		'active_callback'	=> 'tp_coast_is_hero_banner_section_enable',
	)
));


$wp_customize->add_setting('tp_coast_theme_options[hero_banner_sub_title]', array(
	'default'			=> $options['hero_banner_sub_title'],
	'sanitize_callback' => 'sanitize_text_field',
	'transport'			=> 'postMessage',
));

$wp_customize->add_control('tp_coast_theme_options[hero_banner_sub_title]', array(
	'label'           	=> esc_html__('Section Sub Title', 'tp-coast'),
	'section'        	=> 'tp_coast_hero_banner_section',
	'active_callback' 	=> 'tp_coast_is_hero_banner_section_enable',
	'type'				=> 'text',
));

// Abort if selective refresh is not available.
if (isset($wp_customize->selective_refresh)) {
	$wp_customize->selective_refresh->add_partial('tp_coast_theme_options[hero_banner_sub_title]', array(
		'selector'            => '#tp_coast_hero_banner p.entry-subtitle',
		'settings'            => 'tp_coast_theme_options[hero_banner_sub_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'tp_coast_hero_banner_sub_title_partial',
	));
}

// Hero Banner title setting and control
$wp_customize->add_setting('tp_coast_theme_options[hero_banner_title]', array(
	'default'			=> $options['hero_banner_title'],
	'sanitize_callback' => 'sanitize_text_field',
	'transport'			=> 'postMessage',
));

$wp_customize->add_control('tp_coast_theme_options[hero_banner_title]', array(
	'label'           	=> esc_html__('Section Title', 'tp-coast'),
	'section'        	=> 'tp_coast_hero_banner_section',
	'active_callback' 	=> 'tp_coast_is_hero_banner_section_enable',
	'type'				=> 'text',
));

// Abort if selective refresh is not available.
if (isset($wp_customize->selective_refresh)) {
	$wp_customize->selective_refresh->add_partial('tp_coast_theme_options[hero_banner_title]', array(
		'selector'            => '#tp_coast_hero_banner h2.entry-title',
		'settings'            => 'tp_coast_theme_options[hero_banner_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'tp_coast_hero_banner_title_partial',
	));
}

// Hero Banner section setting and control
$wp_customize->add_setting('tp_coast_theme_options[hero_banner_content]', array(
	'default'			=> $options['hero_banner_content'],
	'sanitize_callback' => 'sanitize_text_field',
	'transport'			=> 'postMessage',
));

$wp_customize->add_control('tp_coast_theme_options[hero_banner_content]', array(
	'label'           	=> esc_html__('Section Content', 'tp-coast'),
	'section'        	=> 'tp_coast_hero_banner_section',
	'active_callback' 	=> 'tp_coast_is_hero_banner_section_enable',
	'type'				=> 'textarea',
));

// Abort if selective refresh is not available.
if (isset($wp_customize->selective_refresh)) {
	$wp_customize->selective_refresh->add_partial('tp_coast_theme_options[hero_banner_content]', array(
		'selector'            => '#tp_coast_hero_banner .entry-content p.tp_coast-content-p',
		'settings'            => 'tp_coast_theme_options[hero_banner_content]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'tp_coast_hero_banner_content_partial',
	));
}

// Hero Banner Button setting and control
$wp_customize->add_setting('tp_coast_theme_options[hero_banner_btn_label]', array(
	'default'			=> $options['hero_banner_btn_label'],
	'sanitize_callback' => 'sanitize_text_field',
	'transport'			=> 'postMessage',
));

$wp_customize->add_control('tp_coast_theme_options[hero_banner_btn_label]', array(
	'label'           	=> esc_html__('Btn Label', 'tp-coast'),
	'section'        	=> 'tp_coast_hero_banner_section',
	'active_callback' 	=> 'tp_coast_is_hero_banner_section_enable',
	'type'				=> 'text',
));

// Abort if selective refresh is not available.
if (isset($wp_customize->selective_refresh)) {
	$wp_customize->selective_refresh->add_partial('tp_coast_theme_options[hero_banner_btn_label]', array(
		'selector'            => '#tp_coast_hero_banner .hero-banner-play-video-button a.search-submit',
		'settings'            => 'tp_coast_theme_options[hero_banner_btn_label]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'tp_coast_hero_banner_btn_label_partial',
	));
}